/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.profile2.cache.CacheManager;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.types.PrivacyType;

public class ProfilePrivacyLogicImpl
implements ProfilePrivacyLogic {
    private static final Logger log = Logger.getLogger(ProfilePrivacyLogicImpl.class);
    private Cache cache;
    private final String CACHE_NAME = "org.sakaiproject.profile2.cache.privacy";
    private SakaiProxy sakaiProxy;
    private ProfileDao dao;
    private CacheManager cacheManager;
    private ProfileConnectionsLogic connectionsLogic;

    public ProfilePrivacy getPrivacyRecordForUser(String userId) {
        return this.getPrivacyRecordForUser(userId, true);
    }

    public ProfilePrivacy getPrivacyRecordForUser(String userId, boolean useCache) {
        if (userId == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogic.getPrivacyRecordForUser");
        }
        if (useCache && this.cache.containsKey(userId)) {
            log.debug((Object)("Fetching privacy record from cache for: " + userId));
            return (ProfilePrivacy)this.cache.get(userId);
        }
        ProfilePrivacy privacy = null;
        privacy = this.dao.getPrivacyRecord(userId);
        log.debug((Object)("Fetching privacy record from dao for: " + userId));
        if (privacy == null && (privacy = this.dao.addNewPrivacyRecord(this.getDefaultPrivacyRecord(userId))) != null) {
            this.sakaiProxy.postEvent("profile.privacy.new", "/profile/" + userId, true);
            log.info((Object)("Created default privacy record for user: " + userId));
        }
        if (privacy != null) {
            log.debug((Object)("Adding privacy record to cache for: " + userId));
            this.cache.put(userId, (Object)privacy);
        }
        if (privacy == null) {
            log.error((Object)("Couldn't retrieve or create a privacy record for user: " + userId + " This is an error and you need to fix your installation."));
        }
        return privacy;
    }

    public boolean savePrivacyRecord(ProfilePrivacy privacy) {
        if (!this.sakaiProxy.isPrivacyChangeAllowedGlobally()) {
            log.warn((Object)"Privacy changes are not permitted as per sakai.properties setting 'profile2.privacy.change.enabled'.");
            return false;
        }
        if (this.dao.updatePrivacyRecord(privacy)) {
            log.info((Object)("Saved privacy record for user: " + privacy.getUserUuid()));
            log.debug((Object)("Updated privacy record in cache for: " + privacy.getUserUuid()));
            this.cache.put(privacy.getUserUuid(), (Object)privacy);
            return true;
        }
        return false;
    }

    public boolean isActionAllowed(String userX, String userY, PrivacyType type) {
        if (userY.equals(userX)) {
            return true;
        }
        ProfilePrivacy profilePrivacy = this.getPrivacyRecordForUser(userX);
        if (profilePrivacy == null) {
            log.error((Object)("ProfilePrivacyLogic.isActionAllowed. Couldn't get a ProfilePrivacy record for userX: " + userX));
            return false;
        }
        boolean isConnected = this.connectionsLogic.isUserXFriendOfUserY(userX, userY);
        boolean result = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProfilePrivacyLogic.isActionAllowed. userX: " + userX + ", userY: " + userY + ", type: " + type));
        }
        switch (type) {
            case PRIVACY_OPTION_PROFILEIMAGE: {
                if (isConnected && profilePrivacy.getProfileImage() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getProfileImage() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getProfileImage() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_BASICINFO: {
                if (isConnected && profilePrivacy.getBasicInfo() == 1) {
                    result = true;
                    break;
                }
                if (profilePrivacy.getBasicInfo() == 2) {
                    result = false;
                    break;
                }
                if (!isConnected && profilePrivacy.getBasicInfo() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getBasicInfo() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_CONTACTINFO: {
                if (isConnected && profilePrivacy.getContactInfo() == 1) {
                    result = true;
                    break;
                }
                if (profilePrivacy.getContactInfo() == 2) {
                    result = false;
                    break;
                }
                if (!isConnected && profilePrivacy.getContactInfo() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getContactInfo() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_STAFFINFO: {
                if (profilePrivacy.getStaffInfo() == 2) {
                    result = false;
                    break;
                }
                if (isConnected && profilePrivacy.getStaffInfo() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getStaffInfo() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getStaffInfo() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_STUDENTINFO: {
                if (profilePrivacy.getStudentInfo() == 2) {
                    result = false;
                    break;
                }
                if (isConnected && profilePrivacy.getStudentInfo() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getStudentInfo() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getStudentInfo() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_BUSINESSINFO: {
                if (profilePrivacy.getBusinessInfo() == 2) {
                    result = false;
                    break;
                }
                if (isConnected && profilePrivacy.getBusinessInfo() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getBusinessInfo() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getBusinessInfo() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_SOCIALINFO: {
                if (profilePrivacy.getSocialNetworkingInfo() == 2) {
                    result = false;
                    break;
                }
                if (isConnected && profilePrivacy.getSocialNetworkingInfo() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getSocialNetworkingInfo() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getSocialNetworkingInfo() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_PERSONALINFO: {
                if (profilePrivacy.getPersonalInfo() == 2) {
                    result = false;
                    break;
                }
                if (isConnected && profilePrivacy.getPersonalInfo() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getPersonalInfo() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getPersonalInfo() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_MYFRIENDS: {
                if (profilePrivacy.getMyFriends() == 2) {
                    result = false;
                    break;
                }
                if (isConnected && profilePrivacy.getMyFriends() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getMyFriends() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getMyFriends() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_MYPICTURES: {
                if (isConnected && profilePrivacy.getMyPictures() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getMyPictures() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getMyPictures() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_MYSTATUS: {
                if (isConnected && profilePrivacy.getMyStatus() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getMyStatus() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getMyStatus() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_MYKUDOS: {
                if (isConnected && profilePrivacy.getMyKudos() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getMyKudos() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getMyKudos() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_MYWALL: {
                if (isConnected && profilePrivacy.getMyWall() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getMyWall() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getMyWall() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_ONLINESTATUS: {
                if (isConnected && profilePrivacy.getOnlineStatus() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getOnlineStatus() == 1) {
                    result = false;
                    break;
                }
                if (profilePrivacy.getOnlineStatus() == 0) {
                    result = true;
                    break;
                }
            }
            case PRIVACY_OPTION_MESSAGES: {
                if (profilePrivacy.getMessages() == 3) {
                    result = false;
                    break;
                }
                if (isConnected && profilePrivacy.getMessages() == 1) {
                    result = true;
                    break;
                }
                if (!isConnected && profilePrivacy.getMessages() == 1) {
                    result = true;
                    break;
                }
            }
            default: {
                log.error((Object)("ProfilePrivacyLogic.isActionAllowed. False for userX: " + userX + ", userY: " + userY + ", type: " + type));
                result = false;
            }
        }
        return result;
    }

    public boolean isBirthYearVisible(String uuid) {
        return this.getPrivacyRecordForUser(uuid).isShowBirthYear();
    }

    private ProfilePrivacy getDefaultPrivacyRecord(String userId) {
        HashMap props = this.sakaiProxy.getOverriddenPrivacySettings();
        ProfilePrivacy privacy = new ProfilePrivacy();
        privacy.setUserUuid(userId);
        privacy.setProfileImage(((Integer)props.get("profileImage")).intValue());
        privacy.setBasicInfo(((Integer)props.get("basicInfo")).intValue());
        privacy.setContactInfo(((Integer)props.get("contactInfo")).intValue());
        privacy.setStaffInfo(((Integer)props.get("staffInfo")).intValue());
        privacy.setStudentInfo(((Integer)props.get("studentInfo")).intValue());
        privacy.setPersonalInfo(((Integer)props.get("personalInfo")).intValue());
        privacy.setShowBirthYear(((Boolean)props.get("birthYear")).booleanValue());
        privacy.setMyFriends(((Integer)props.get("myFriends")).intValue());
        privacy.setMyStatus(((Integer)props.get("myStatus")).intValue());
        privacy.setMyPictures(((Integer)props.get("myPictures")).intValue());
        privacy.setMessages(((Integer)props.get("messages")).intValue());
        privacy.setBusinessInfo(((Integer)props.get("businessInfo")).intValue());
        privacy.setMyKudos(((Integer)props.get("myKudos")).intValue());
        privacy.setMyWall(((Integer)props.get("myWall")).intValue());
        privacy.setSocialNetworkingInfo(((Integer)props.get("socialInfo")).intValue());
        privacy.setOnlineStatus(((Integer)props.get("onlineStatus")).intValue());
        return privacy;
    }

    public void init() {
        this.cache = this.cacheManager.createCache("org.sakaiproject.profile2.cache.privacy");
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setConnectionsLogic(ProfileConnectionsLogic connectionsLogic) {
        this.connectionsLogic = connectionsLogic;
    }
}

