/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.dao.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.CacheMode;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.Type;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.hbm.model.ProfileFriend;
import org.sakaiproject.profile2.hbm.model.ProfileImageExternal;
import org.sakaiproject.profile2.hbm.model.ProfileImageOfficial;
import org.sakaiproject.profile2.hbm.model.ProfileImageUploaded;
import org.sakaiproject.profile2.hbm.model.ProfileKudos;
import org.sakaiproject.profile2.model.CompanyProfile;
import org.sakaiproject.profile2.model.ExternalIntegrationInfo;
import org.sakaiproject.profile2.model.GalleryImage;
import org.sakaiproject.profile2.model.Message;
import org.sakaiproject.profile2.model.MessageParticipant;
import org.sakaiproject.profile2.model.MessageThread;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.model.ProfileStatus;
import org.sakaiproject.profile2.model.SocialNetworkingInfo;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.model.WallItem;
import org.sakaiproject.profile2.model.WallItemComment;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class ProfileDaoImpl
extends HibernateDaoSupport
implements ProfileDao {
    private static final Logger log = Logger.getLogger(ProfileDaoImpl.class);

    @Override
    public List<String> getRequestedConnectionUserIdsForUser(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getFriendRequestsForUser");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setBoolean("false", Boolean.FALSE.booleanValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List<String> getConfirmedConnectionUserIdsForUser(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getConfirmedFriendUserIdsForUser");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setBoolean("true", Boolean.TRUE.booleanValue());
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List<String> findSakaiPersonsByNameOrEmail(final String search) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findSakaiPersonsByNameOrEmail");
                q.setParameter("search", (Object)('%' + search + '%'), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List<String> findSakaiPersonsByInterest(final String search, final boolean includeBusinessBio) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = false == includeBusinessBio ? session.getNamedQuery("findSakaiPersonsByInterest") : session.getNamedQuery("findSakaiPersonsByInterestAndBusinessBio");
                q.setParameter("search", (Object)('%' + search + '%'), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public List<ProfileImageUploaded> getCurrentProfileImageRecords(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getCurrentProfileImageRecord");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public ProfileImageUploaded getCurrentProfileImageRecord(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getCurrentProfileImageRecord");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ProfileImageUploaded)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<ProfileImageUploaded> getOtherProfileImageRecords(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getOtherProfileImageRecords");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public ProfileFriend getConnectionRecord(final String userId, final String friendId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getFriendRecord");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setParameter("friendUuid", (Object)friendId, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ProfileFriend)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public CompanyProfile getCompanyProfile(final String userId, final long companyProfileId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getCompanyProfile");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setParameter("id", (Object)companyProfileId, (Type)Hibernate.LONG);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (CompanyProfile)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public GalleryImage getGalleryImageRecord(final String userId, final long imageId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getGalleryRecord");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setParameter("id", (Object)imageId, (Type)Hibernate.LONG);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (GalleryImage)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public ProfileImageOfficial getOfficialImageRecordForUser(final String userUuid) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getProfileImageOfficialRecord");
                q.setParameter("userUuid", (Object)userUuid, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ProfileImageOfficial)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean addNewConnection(ProfileFriend profileFriend) {
        try {
            this.getHibernateTemplate().save((Object)profileFriend);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("requestFriend failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean updateConnection(ProfileFriend profileFriend) {
        try {
            this.getHibernateTemplate().update((Object)profileFriend);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("confirmFriendRequest failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean removeConnection(ProfileFriend profileFriend) {
        try {
            this.getHibernateTemplate().delete((Object)profileFriend);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("removeConnection failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public ProfileFriend getPendingConnection(final String userId, final String friendId) {
        if (userId == null || friendId == null) {
            throw new IllegalArgumentException("Null Argument in getPendingConnection");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getFriendRequest");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setParameter("friendUuid", (Object)friendId, (Type)Hibernate.STRING);
                q.setParameter("confirmed", (Object)false, (Type)Hibernate.BOOLEAN);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ProfileFriend)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public ProfileStatus getUserStatus(final String userId, final Date oldestDate) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getUserStatus");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setParameter("oldestStatusDate", (Object)oldestDate, (Type)Hibernate.DATE);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ProfileStatus)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean setUserStatus(ProfileStatus profileStatus) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)profileStatus);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("ProfileLogic.setUserStatus() failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean clearUserStatus(ProfileStatus profileStatus) {
        try {
            this.getHibernateTemplate().delete((Object)profileStatus);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("ProfileLogic.clearUserStatus() failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public int getStatusUpdatesCount(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getStatusUpdatesCount");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public ProfilePrivacy addNewPrivacyRecord(ProfilePrivacy privacy) {
        try {
            this.getHibernateTemplate().save((Object)privacy);
            return privacy;
        }
        catch (Exception e) {
            log.error((Object)("addPrivacyRecord failed. " + e.getClass() + ": " + e.getMessage()));
            return null;
        }
    }

    @Override
    public ProfilePrivacy getPrivacyRecord(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getPrivacyRecord");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ProfilePrivacy)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean updatePrivacyRecord(ProfilePrivacy privacy) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)privacy);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("updatePrivacyRecord failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean addNewCompanyProfile(CompanyProfile companyProfile) {
        try {
            this.getHibernateTemplate().save((Object)companyProfile);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("addNewCompanyProfile failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean updateCompanyProfile(CompanyProfile companyProfile) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)companyProfile);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("updateCompanyProfile failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public List<CompanyProfile> getCompanyProfiles(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getCompanyProfiles");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public boolean removeCompanyProfile(CompanyProfile companyProfile) {
        try {
            this.getHibernateTemplate().delete((Object)companyProfile);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("ProfileLogicImpl.removeCompanyProfile() failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean addNewGalleryImage(GalleryImage galleryImage) {
        try {
            this.getHibernateTemplate().save((Object)galleryImage);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("addNewGalleryImage failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public List<GalleryImage> getGalleryImages(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getGalleryImageRecords");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public boolean removeGalleryImage(GalleryImage galleryImage) {
        try {
            this.getHibernateTemplate().delete((Object)galleryImage);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("removeGalleryImage failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public int getGalleryImagesCount(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getGalleryImageRecordsCount");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public SocialNetworkingInfo getSocialNetworkingInfo(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getSocialNetworkingInfo");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (SocialNetworkingInfo)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean saveSocialNetworkingInfo(SocialNetworkingInfo socialNetworkingInfo) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)socialNetworkingInfo);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("saveSocialNetworkingInfo failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean addNewProfileImage(final ProfileImageUploaded profileImage) {
        Boolean success = (Boolean)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                try {
                    ArrayList<ProfileImageUploaded> currentImages = new ArrayList<ProfileImageUploaded>(ProfileDaoImpl.this.getCurrentProfileImageRecords(profileImage.getUserUuid()));
                    for (ProfileImageUploaded currentImage : currentImages) {
                        currentImage.setCurrent(false);
                        session.update((Object)currentImage);
                    }
                    session.save((Object)profileImage);
                    session.flush();
                }
                catch (Exception e) {
                    log.error((Object)("addNewProfileImage failed. " + e.getClass() + ": " + e.getMessage()));
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
        return success;
    }

    @Override
    public List<String> getAllSakaiPersonIds() {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getAllSakaiPersonIds");
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public int getAllSakaiPersonIdsCount() {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getAllSakaiPersonIdsCount");
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<UserProfile> getUserProfiles(final int start, final int count) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getSakaiPerson");
                q.setFirstResult(start);
                q.setMaxResults(count);
                q.setResultTransformer(Transformers.aliasToBean(UserProfile.class));
                q.setCacheMode(CacheMode.GET);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public ProfileImageExternal getExternalImageRecordForUser(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getProfileImageExternalRecord");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ProfileImageExternal)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean saveExternalImage(ProfileImageExternal externalImage) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)externalImage);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("saveExternalImage failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public ProfilePreferences addNewPreferencesRecord(ProfilePreferences prefs) {
        try {
            this.getHibernateTemplate().save((Object)prefs);
            return prefs;
        }
        catch (Exception e) {
            log.error((Object)("ProfileLogic.createDefaultPreferencesRecord() failed. " + e.getClass() + ": " + e.getMessage()));
            return null;
        }
    }

    @Override
    public ProfilePreferences getPreferencesRecordForUser(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getPreferencesRecord");
                q.setParameter("userUuid", (Object)userId, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ProfilePreferences)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean savePreferencesRecord(ProfilePreferences prefs) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)prefs);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("savePreferencesRecord failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public int getAllUnreadMessagesCount(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getAllUnreadMessagesCount");
                q.setParameter("uuid", (Object)userId, (Type)Hibernate.STRING);
                q.setBoolean("false", Boolean.FALSE.booleanValue());
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public int getThreadsWithUnreadMessagesCount(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getThreadsWithUnreadMessagesCount");
                q.setParameter("uuid", (Object)userId, (Type)Hibernate.STRING);
                q.setBoolean("false", Boolean.FALSE.booleanValue());
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<MessageThread> getMessageThreads(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getMessageThreads");
                q.setParameter("uuid", (Object)userId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public int getMessageThreadsCount(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getMessageThreadsCount");
                q.setParameter("uuid", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public int getSentMessagesCount(final String userId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getSentMessagesCount");
                q.setParameter("uuid", (Object)userId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<Message> getMessagesInThread(final String threadId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getMessagesInThread");
                q.setParameter("thread", (Object)threadId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public int getMessagesInThreadCount(final String threadId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getMessagesInThreadCount");
                q.setParameter("thread", (Object)threadId, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public Message getMessage(final String id) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getMessage");
                q.setParameter("id", (Object)id, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (Message)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public MessageThread getMessageThread(final String threadId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getMessageThread");
                q.setParameter("id", (Object)threadId, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (MessageThread)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public Message getLatestMessageInThread(final String threadId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getLatestMessageInThread");
                q.setParameter("thread", (Object)threadId, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (Message)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean toggleMessageRead(MessageParticipant participant, boolean read) {
        try {
            participant.setRead(read);
            this.getHibernateTemplate().saveOrUpdate((Object)participant);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("toggleMessageRead failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public MessageParticipant getMessageParticipant(final String messageId, final String userUuid) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getMessageParticipantForMessageAndUuid");
                q.setParameter("messageId", (Object)messageId, (Type)Hibernate.STRING);
                q.setParameter("uuid", (Object)userUuid, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (MessageParticipant)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public List<String> getThreadParticipants(final String threadId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getThreadParticipants");
                q.setParameter("thread", (Object)threadId, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public void saveNewThread(MessageThread thread) {
        try {
            this.getHibernateTemplate().save((Object)thread);
            log.info((Object)("MessageThread saved with id= " + thread.getId()));
        }
        catch (Exception e) {
            log.error((Object)("saveNewThread failed. " + e.getClass() + ": " + e.getMessage()));
        }
    }

    @Override
    public void saveNewMessage(Message message) {
        try {
            this.getHibernateTemplate().save((Object)message);
            log.info((Object)("Message saved with id= " + message.getId()));
        }
        catch (Exception e) {
            log.error((Object)("saveNewMessage failed. " + e.getClass() + ": " + e.getMessage()));
        }
    }

    @Override
    public void saveNewMessageParticipant(MessageParticipant participant) {
        try {
            this.getHibernateTemplate().save((Object)participant);
            log.info((Object)("MessageParticipant saved with id= " + participant.getId()));
        }
        catch (Exception e) {
            log.error((Object)("saveNewMessageParticipant failed. " + e.getClass() + ": " + e.getMessage()));
        }
    }

    @Override
    public void saveNewMessageParticipants(List<MessageParticipant> participants) {
        for (MessageParticipant participant : participants) {
            try {
                this.getHibernateTemplate().save((Object)participant);
                log.info((Object)("MessageParticipant saved with id= " + participant.getId()));
            }
            catch (Exception e) {
                log.error((Object)("saveNewMessageParticipant failed. " + e.getClass() + ": " + e.getMessage()));
            }
        }
    }

    @Override
    public boolean saveOfficialImageUrl(ProfileImageOfficial officialImage) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)officialImage);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("saveOfficialImageUrl failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public ProfileKudos getKudos(final String userUuid) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getKudosRecord");
                q.setParameter("userUuid", (Object)userUuid, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ProfileKudos)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean updateKudos(ProfileKudos kudos) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)kudos);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("updateKudos failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public ExternalIntegrationInfo getExternalIntegrationInfo(final String userUuid) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getExternalIntegrationInfo");
                q.setParameter("userUuid", (Object)userUuid, (Type)Hibernate.STRING);
                q.setMaxResults(1);
                return q.uniqueResult();
            }
        };
        return (ExternalIntegrationInfo)this.getHibernateTemplate().execute(hcb);
    }

    @Override
    public boolean updateExternalIntegrationInfo(ExternalIntegrationInfo info) {
        try {
            this.getHibernateTemplate().saveOrUpdate((Object)info);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("updateExternalIntegrationInfo failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean addNewWallItemForUser(String userUuid, WallItem item) {
        try {
            this.getHibernateTemplate().save((Object)item);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("addNewWallItemForUser failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean removeWallItemFromWall(WallItem item) {
        try {
            this.getHibernateTemplate().delete((Object)item);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("removeWallItemFromWall failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public WallItem getWallItem(final long wallItemId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getWallItemRecord");
                q.setParameter("id", (Object)wallItemId, (Type)Hibernate.LONG);
                return q.list();
            }
        };
        return (WallItem)this.getHibernateTemplate().executeFind(hcb).get(0);
    }

    @Override
    public WallItemComment getWallItemComment(final long wallItemCommentId) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(WallItemComment.class).add((Criterion)Restrictions.eq((String)"id", (Object)wallItemCommentId)).setFetchMode("wallItem", FetchMode.JOIN).list();
            }
        };
        List comments = this.getHibernateTemplate().executeFind(hcb);
        if (comments.size() > 0) {
            return (WallItemComment)comments.get(0);
        }
        return null;
    }

    @Override
    public List<WallItem> getWallItemsForUser(final String userUuid) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("getWallItemRecords");
                q.setParameter("userUuid", (Object)userUuid, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    @Override
    public boolean addNewCommentToWallItem(WallItemComment wallItemComment) {
        try {
            this.getHibernateTemplate().save((Object)wallItemComment);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("addNewWallItemComment failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean invalidateCurrentProfileImage(String userUuid) {
        try {
            ProfileImageUploaded currentImage = this.getCurrentProfileImageRecord(userUuid);
            currentImage.setCurrent(false);
            this.getHibernateTemplate().save((Object)currentImage);
            return true;
        }
        catch (Exception e) {
            log.error((Object)("invalidateCurrentProfileImage failed. " + e.getClass() + ": " + e.getMessage()));
            return false;
        }
    }

    public void init() {
        log.debug((Object)"init");
    }
}

