/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.hbm.model.ProfileImageExternal;
import org.sakaiproject.profile2.hbm.model.ProfileImageOfficial;
import org.sakaiproject.profile2.hbm.model.ProfileImageUploaded;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.GalleryImage;
import org.sakaiproject.profile2.model.MimeTypeByteArray;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.model.ProfileImage;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.types.PrivacyType;
import org.sakaiproject.profile2.util.Messages;
import org.sakaiproject.profile2.util.ProfileUtils;
import org.sakaiproject.user.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileImageLogicImpl
implements ProfileImageLogic {
    private static final Logger log = LoggerFactory.getLogger(ProfileImageLogicImpl.class);
    private SakaiProxy sakaiProxy;
    private ProfilePrivacyLogic privacyLogic;
    private ProfileConnectionsLogic connectionsLogic;
    private ProfilePreferencesLogic preferencesLogic;
    private ProfileDao dao;

    public ProfileImage getBlankProfileImage() {
        ProfileImage profileImage = new ProfileImage();
        profileImage.setExternalImageUrl(this.getUnavailableImageURL());
        profileImage.setDefault(true);
        return profileImage;
    }

    public ProfileImage getProfileImage(String userUuid, ProfilePreferences prefs, ProfilePrivacy privacy, int size) {
        return this.getProfileImage(userUuid, prefs, privacy, size, null);
    }

    public ProfileImage getOfficialProfileImage(String userUuid, String siteId) {
        ProfileImage profileImage = new ProfileImage();
        profileImage.setDefault(false);
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        String defaultImageUrl = this.getUnavailableImageURL();
        if (!this.sakaiProxy.isUserMyWorkspace(siteId)) {
            log.debug("checking if user: " + currentUserId + " has permissions in site: " + siteId);
            if (!this.sakaiProxy.isUserAllowedInSite(currentUserId, "roster.viewofficialphoto", siteId)) {
                profileImage.setExternalImageUrl(defaultImageUrl);
                profileImage.setDefault(true);
                return profileImage;
            }
        }
        return this.getOfficialImage(userUuid, profileImage, defaultImageUrl, StringUtils.equals((String)userUuid, (String)currentUserId));
    }

    public ProfileImage getProfileImage(String userUuid, ProfilePreferences prefs, ProfilePrivacy privacy, int size, String siteId) {
        ProfileImage image = new ProfileImage();
        boolean allowed = false;
        boolean isSameUser = false;
        image.setDefault(false);
        String defaultImageUrl = 2 == size ? this.getUnavailableImageThumbnailURL() : this.getUnavailableImageURL();
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (StringUtils.equals((String)userUuid, (String)currentUserUuid)) {
            isSameUser = true;
        }
        if (StringUtils.isBlank((String)currentUserUuid)) {
            throw new SecurityException("Must be logged in to request a profile image.");
        }
        if (prefs != null && !StringUtils.equals((String)userUuid, (String)prefs.getUserUuid())) {
            log.error("ProfilePreferences data supplied was not for user: " + userUuid);
            image.setExternalImageUrl(defaultImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, false));
            image.setDefault(true);
            return image;
        }
        if (privacy != null && !StringUtils.equals((String)userUuid, (String)privacy.getUserUuid())) {
            log.error("ProfilePrivacy data supplied was not for user: " + userUuid);
            image.setExternalImageUrl(defaultImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, false));
            image.setDefault(true);
            return image;
        }
        if (isSameUser) {
            allowed = true;
        }
        if (StringUtils.isNotBlank((String)siteId) && !this.sakaiProxy.isUserMyWorkspace(siteId)) {
            log.debug("checking if user: " + currentUserUuid + " has permissions in site: " + siteId);
            allowed = this.sakaiProxy.isUserAllowedInSite(currentUserUuid, "roster.viewofficialphoto", siteId);
        }
        if (!allowed && privacy == null && (privacy = this.privacyLogic.getPrivacyRecordForUser(userUuid)) == null) {
            log.error("Couldn't retrieve ProfilePrivacy data for user: " + userUuid + ". Using default image.");
            image.setExternalImageUrl(defaultImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, false));
            image.setDefault(true);
            return image;
        }
        if (!allowed) {
            allowed = this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_PROFILEIMAGE);
        }
        if (!allowed) {
            image.setExternalImageUrl(defaultImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, false));
            image.setDefault(true);
            return image;
        }
        String userTypeImageUrl = this.getUserTypeImageUrl(userUuid);
        if (StringUtils.isNotBlank((String)userTypeImageUrl)) {
            image.setExternalImageUrl(userTypeImageUrl);
            image.setAltText(this.getAltText(userUuid, isSameUser, true));
            return image;
        }
        int imageType = this.sakaiProxy.getProfilePictureType();
        if (prefs == null) {
            prefs = this.preferencesLogic.getPreferencesRecordForUser(userUuid);
        }
        if (prefs != null && this.sakaiProxy.isUsingOfficialImageButAlternateSelectionEnabled() && prefs.isUseOfficialImage()) {
            imageType = 3;
        }
        if (prefs != null && this.sakaiProxy.isGravatarImageEnabledGlobally() && prefs.isUseGravatar()) {
            imageType = 4;
        }
        if (log.isDebugEnabled()) {
            log.debug("image type: " + imageType);
            log.debug("size requested: " + size);
        }
        switch (imageType) {
            case 1: {
                MimeTypeByteArray mtba = this.getUploadedProfileImage(userUuid, size);
                if (mtba == null || mtba.getBytes() == null) {
                    image.setExternalImageUrl(defaultImageUrl);
                    image.setDefault(true);
                } else {
                    image.setUploadedImage(mtba.getBytes());
                    image.setMimeType(mtba.getMimeType());
                }
                image.setAltText(this.getAltText(userUuid, isSameUser, true));
                break;
            }
            case 2: {
                image.setExternalImageUrl(this.getExternalProfileImageUrl(userUuid, size));
                if (StringUtils.equals((String)image.getExternalImageUrl(), (String)defaultImageUrl)) {
                    image.setDefault(true);
                }
                image.setAltText(this.getAltText(userUuid, isSameUser, true));
                break;
            }
            case 3: {
                image = this.getOfficialImage(userUuid, image, defaultImageUrl, isSameUser);
                break;
            }
            case 4: {
                String gravatarUrl = this.getGravatarUrl(userUuid);
                if (StringUtils.isBlank((String)gravatarUrl)) {
                    image.setExternalImageUrl(defaultImageUrl);
                    image.setAltText(this.getAltText(userUuid, isSameUser, false));
                    image.setDefault(true);
                    break;
                }
                image.setExternalImageUrl(gravatarUrl);
                image.setAltText(this.getAltText(userUuid, isSameUser, true));
                break;
            }
            default: {
                image.setExternalImageUrl(defaultImageUrl);
                image.setAltText(this.getAltText(userUuid, isSameUser, false));
                image.setDefault(true);
            }
        }
        return image;
    }

    private ProfileImage getOfficialImage(String userUuid, ProfileImage image, String defaultImageUrl, boolean isSameUser) {
        String officialImageSource = this.sakaiProxy.getOfficialImageSource();
        log.debug("Fetching official image. userUuid: " + userUuid + ", officialImageSource: " + officialImageSource);
        if (StringUtils.equals((String)officialImageSource, (String)"url")) {
            image.setOfficialImageUrl(this.getOfficialImageUrl(userUuid));
            boolean urlSecurityEnabled = Boolean.valueOf(this.sakaiProxy.getServerConfigurationParameter("profile2.official.image.url.secure", "false"));
            if (urlSecurityEnabled && StringUtils.isNotBlank((String)image.getOfficialImageUrl())) {
                log.debug("URL Security is active");
                byte[] imageUrlBytes = this.getUrlAsBytes(image.getOfficialImageUrl());
                image.setUploadedImage(imageUrlBytes);
                image.setOfficialImageUrl(null);
            }
        } else if (StringUtils.equals((String)officialImageSource, (String)"provider")) {
            String data = this.getOfficialImageEncoded(userUuid);
            if (StringUtils.isBlank((String)data)) {
                image.setExternalImageUrl(defaultImageUrl);
                image.setDefault(true);
            } else {
                image.setOfficialImageEncoded(data);
            }
        } else if (StringUtils.equals((String)officialImageSource, (String)"filesystem")) {
            String filename = this.getOfficialImageFileSystemPath(userUuid);
            File file = new File(filename);
            try {
                byte[] data = this.getBytesFromFile(file);
                if (data != null) {
                    image.setUploadedImage(data);
                } else {
                    image.setExternalImageUrl(defaultImageUrl);
                    image.setDefault(true);
                }
            }
            catch (IOException e) {
                log.error("Could not find/read official profile image file: " + filename + ". The default profile image will be used instead.");
                image.setExternalImageUrl(defaultImageUrl);
                image.setDefault(true);
            }
        }
        image.setAltText(this.getAltText(userUuid, isSameUser, true));
        return image;
    }

    public ProfileImage getProfileImage(Person person, int size) {
        return this.getProfileImage(person.getUuid(), person.getPreferences(), person.getPrivacy(), size, null);
    }

    public ProfileImage getProfileImage(Person person, int size, String siteId) {
        return this.getProfileImage(person.getUuid(), person.getPreferences(), person.getPrivacy(), size, siteId);
    }

    public boolean setUploadedProfileImage(String userUuid, byte[] imageBytes, String mimeType, String fileName) {
        ProfileImageUploaded profileImage;
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to update a user's profile image.");
        }
        if (!this.sakaiProxy.isSuperUser() && !StringUtils.equals((String)currentUserUuid, (String)userUuid)) {
            throw new SecurityException("Not allowed to save.");
        }
        if (!this.sakaiProxy.isProfilePictureChangeEnabled()) {
            log.warn("Profile image changes are not permitted as per sakai.properties setting 'profile2.picture.change.enabled'.");
            return false;
        }
        byte[] mainImageBytes = ProfileUtils.scaleImage((byte[])imageBytes, (int)200, (String)mimeType);
        String mainResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 1);
        if (!this.sakaiProxy.saveFile(mainResourceId, userUuid, fileName, mimeType, mainImageBytes)) {
            log.error("Couldn't add main image to CHS. Aborting.");
            return false;
        }
        byte[] thumbnailImageBytes = ProfileUtils.scaleImage((byte[])imageBytes, (int)100, (String)mimeType);
        String thumbnailResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 2);
        log.debug("Profile.ChangeProfilePicture.onSubmit thumbnailResourceId: " + thumbnailResourceId);
        if (!this.sakaiProxy.saveFile(thumbnailResourceId, userUuid, fileName, mimeType, thumbnailImageBytes)) {
            log.warn("Couldn't add thumbnail image to CHS. Main image will be used instead.");
            thumbnailResourceId = null;
        }
        byte[] avatarImageBytes = ProfileUtils.createAvatar((byte[])imageBytes, (String)mimeType);
        String avatarResourceId = this.sakaiProxy.getProfileImageResourcePath(userUuid, 3);
        log.debug("Profile.ChangeProfilePicture.onSubmit avatarResourceId: " + avatarResourceId);
        if (!this.sakaiProxy.saveFile(avatarResourceId, userUuid, fileName, mimeType, avatarImageBytes)) {
            log.warn("Couldn't add avatar image to CHS. Main image will be used instead.");
            avatarResourceId = null;
        }
        if (this.dao.addNewProfileImage(profileImage = new ProfileImageUploaded(userUuid, mainResourceId, thumbnailResourceId, avatarResourceId, true))) {
            log.info("Added a new profile image for user: " + userUuid);
            return true;
        }
        return false;
    }

    public boolean setExternalProfileImage(String userUuid, String fullSizeUrl, String thumbnailUrl, String avatar) {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to update a user's profile image.");
        }
        if (!this.sakaiProxy.isSuperUser() && !StringUtils.equals((String)currentUserUuid, (String)userUuid)) {
            throw new SecurityException("Not allowed to save.");
        }
        if (!this.sakaiProxy.isProfilePictureChangeEnabled()) {
            log.warn("Profile image changes are not permitted as per sakai.properties setting 'profile2.picture.change.enabled'.");
            return false;
        }
        ProfileImageExternal externalImage = new ProfileImageExternal(userUuid, fullSizeUrl, thumbnailUrl, avatar);
        if (this.dao.saveExternalImage(externalImage)) {
            log.info("Updated external image record for user: " + userUuid);
            return true;
        }
        return false;
    }

    public boolean saveOfficialImageUrl(String userUuid, String url) {
        ProfileImageOfficial officialImage = new ProfileImageOfficial(userUuid, url);
        if (this.dao.saveOfficialImageUrl(officialImage)) {
            log.info("Updated official image record for user: " + userUuid);
            return true;
        }
        return false;
    }

    public boolean addGalleryImage(String userUuid, byte[] imageBytes, String mimeType, String fileName) {
        byte[] scaledImageBytes;
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to add a gallery image.");
        }
        if (!this.sakaiProxy.isSuperUser() && !StringUtils.equals((String)currentUserUuid, (String)userUuid)) {
            throw new SecurityException("You are not allowed to add a gallery image.");
        }
        String imageId = this.sakaiProxy.createUuid();
        String mainResourcePath = this.sakaiProxy.getProfileGalleryImagePath(userUuid, imageId);
        if (!this.sakaiProxy.saveFile(mainResourcePath, userUuid, fileName, mimeType, scaledImageBytes = ProfileUtils.scaleImage((byte[])imageBytes, (int)575, (String)mimeType))) {
            log.error("Couldn't add gallery image to CHS. Aborting.");
            return false;
        }
        byte[] thumbnailBytes = ProfileUtils.scaleImage((byte[])imageBytes, (int)125, (String)mimeType);
        String thumbnailResourcePath = this.sakaiProxy.getProfileGalleryThumbnailPath(userUuid, imageId);
        this.sakaiProxy.saveFile(thumbnailResourcePath, userUuid, fileName, mimeType, thumbnailBytes);
        GalleryImage galleryImage = new GalleryImage(userUuid, mainResourcePath, thumbnailResourcePath, fileName);
        if (this.dao.addNewGalleryImage(galleryImage)) {
            log.info("Added new gallery image for user: " + galleryImage.getUserUuid());
            return true;
        }
        return false;
    }

    public List<GalleryImage> getGalleryImages(String userUuid) {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to make a request for a user's gallery images.");
        }
        return this.dao.getGalleryImages(userUuid);
    }

    public List<GalleryImage> getGalleryImagesRandomized(String userUuid) {
        List<GalleryImage> images = this.getGalleryImages(userUuid);
        Collections.shuffle(images);
        return images;
    }

    public boolean removeGalleryImage(String userId, long imageId) {
        if (userId == null || Long.valueOf(imageId) == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogicImpl.removeGalleryImage()");
        }
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("You must be logged in to remove a gallery image.");
        }
        if (!this.sakaiProxy.isSuperUser() && !StringUtils.equals((String)currentUserUuid, (String)userId)) {
            throw new SecurityException("You are not allowed to remove this gallery image.");
        }
        GalleryImage galleryImage = this.dao.getGalleryImageRecord(userId, imageId);
        if (galleryImage == null) {
            log.error("GalleryImage record does not exist for userId: " + userId + ", imageId: " + imageId);
            return false;
        }
        if (!this.sakaiProxy.removeResource(galleryImage.getMainResource())) {
            log.error("Gallery image not removed: " + galleryImage.getMainResource());
        }
        if (!this.sakaiProxy.removeResource(galleryImage.getThumbnailResource())) {
            log.error("Gallery thumbnail not removed: " + galleryImage.getThumbnailResource());
        }
        if (this.dao.removeGalleryImage(galleryImage)) {
            log.info("User: " + userId + " removed gallery image: " + imageId);
            return true;
        }
        return false;
    }

    public String getGravatarUrl(String userUuid) {
        String email = this.sakaiProxy.getUserEmail(userUuid);
        if (StringUtils.isBlank((String)email)) {
            return null;
        }
        return "//www.gravatar.com/avatar/" + ProfileUtils.calculateMD5((String)email) + "?s=200";
    }

    public boolean resetProfileImage(String userUuid) {
        if (this.dao.invalidateCurrentProfileImage(userUuid)) {
            log.info("Invalidated profile image for user: " + userUuid);
            return true;
        }
        return false;
    }

    public boolean profileImageIsDefault(String userUuid) {
        ProfileImage image = this.getProfileImage(userUuid, null, null, 1);
        return image.isDefault();
    }

    private String getUnavailableImageURL(String imagePath) {
        StringBuilder path = new StringBuilder();
        path.append(this.sakaiProxy.getServerUrl());
        path.append(imagePath);
        return path.toString();
    }

    public String getUnavailableImageURL() {
        return this.getUnavailableImageURL("/profile2-tool/images/no_image.gif");
    }

    public String getUnavailableImageThumbnailURL() {
        return this.getUnavailableImageURL("/profile2-tool/images/no_image_thumbnail.gif");
    }

    public String getProfileImageEntityUrl(String userUuid, int size) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.sakaiProxy.getServerUrl());
        sb.append("/direct/profile/");
        sb.append(userUuid);
        sb.append("/image/");
        if (size == 2) {
            sb.append("thumb/");
        }
        return sb.toString();
    }

    public int getGalleryImagesCount(String userUuid) {
        return this.dao.getGalleryImagesCount(userUuid);
    }

    private MimeTypeByteArray getUploadedProfileImage(String userUuid, int size) {
        MimeTypeByteArray mtba = new MimeTypeByteArray();
        ProfileImageUploaded profileImage = this.dao.getCurrentProfileImageRecord(userUuid);
        if (profileImage == null) {
            log.debug("ProfileLogic.getUploadedProfileImage() null for userUuid: " + userUuid);
            return null;
        }
        if (size == 1) {
            mtba = this.sakaiProxy.getResource(profileImage.getMainResource());
        }
        if (size == 2 && ((mtba = this.sakaiProxy.getResource(profileImage.getThumbnailResource())) == null || mtba.getBytes() == null)) {
            mtba = this.sakaiProxy.getResource(profileImage.getMainResource());
        }
        if (size == 3 && ((mtba = this.sakaiProxy.getResource(profileImage.getAvatarResource())) == null || mtba.getBytes() == null)) {
            mtba = this.sakaiProxy.getResource(profileImage.getMainResource());
        }
        return mtba;
    }

    private String getExternalProfileImageUrl(String userUuid, int size) {
        ProfileImageExternal externalImage = this.dao.getExternalImageRecordForUser(userUuid);
        String defaultImageUrl = this.getUnavailableImageURL();
        if (externalImage == null) {
            return defaultImageUrl;
        }
        String url = null;
        if (size == 1) {
            if (log.isDebugEnabled()) {
                log.debug("Returning main image url for userId: " + userUuid);
            }
            url = externalImage.getMainUrl();
        }
        if (size == 2) {
            if (log.isDebugEnabled()) {
                log.debug("Returning thumb image url for userId: " + userUuid);
            }
            url = externalImage.getThumbnailUrl();
        }
        if (size == 3) {
            if (log.isDebugEnabled()) {
                log.debug("Returning avatar image url for userId: " + userUuid);
            }
            url = externalImage.getAvatarUrl();
        }
        if (StringUtils.isNotBlank((String)url)) {
            return url;
        }
        url = externalImage.getMainUrl();
        if (StringUtils.isBlank((String)url)) {
            url = defaultImageUrl;
        }
        log.info("ProfileLogic.getExternalProfileImageUrl. No URL for userId: " + userUuid + ", imageType: " + size + ". Returning default.");
        return defaultImageUrl;
    }

    private String getOfficialImageUrl(String userUuid) {
        ProfileImageOfficial official = this.dao.getOfficialImageRecordForUser(userUuid);
        String defaultImageUrl = this.getUnavailableImageURL();
        if (official == null) {
            return defaultImageUrl;
        }
        if (StringUtils.isBlank((String)official.getUrl())) {
            log.info("ProfileLogic.getOfficialImageUrl. No URL for userUuid: " + userUuid + ". Returning default.");
            return defaultImageUrl;
        }
        return official.getUrl();
    }

    private String getOfficialImageEncoded(String userUuid) {
        User u = this.sakaiProxy.getUserById(userUuid);
        return u.getProperties().getProperty(this.sakaiProxy.getOfficialImageAttribute());
    }

    private String getAltText(String userUuid, boolean isOwner, boolean hasImage) {
        if (isOwner && hasImage) {
            return Messages.getString((String)"profile.image.my.alt");
        }
        if (isOwner && !hasImage) {
            return Messages.getString((String)"profile.image.my.none.alt");
        }
        if (!isOwner) {
            String displayName = this.sakaiProxy.getUserDisplayName(userUuid);
            return Messages.getString((String)"profile.image.other.alt", (Object[])new Object[]{displayName});
        }
        return null;
    }

    private String getUserTypeImageUrl(String userUuid) {
        String userType;
        boolean enabled = Boolean.valueOf(this.sakaiProxy.getServerConfigurationParameter("profile2.user.type.image.enabled", "false"));
        String imageUrl = null;
        if (enabled && StringUtils.isNotBlank((String)(userType = this.sakaiProxy.getUserType(userUuid)))) {
            imageUrl = this.sakaiProxy.getServerConfigurationParameter("profile.user.type.image." + userType, null);
        }
        return imageUrl;
    }

    private byte[] getBytesFromFile(File file) throws IOException {
        long length = file.length();
        if (length > 0x200000L) {
            log.error("File too large: " + file.getCanonicalPath());
            return null;
        }
        return FileUtils.readFileToByteArray((File)file);
    }

    private String getOfficialImageFileSystemPath(String userUuid) {
        String basepath = this.sakaiProxy.getOfficialImagesDirectory();
        String pattern = this.sakaiProxy.getOfficialImagesFileSystemPattern();
        User user = this.sakaiProxy.getUserById(userUuid);
        String userEid = user.getEid();
        String filename = null;
        if (StringUtils.equals((String)pattern, (String)"ALL_IN_ONE")) {
            filename = basepath + File.separator + userEid + ".jpg";
        } else if (StringUtils.equals((String)pattern, (String)"ONE_DEEP")) {
            String firstLetter = userEid.substring(0, 1);
            filename = basepath + File.separator + firstLetter + File.separator + userEid + ".jpg";
        } else {
            String firstLetter = userEid.substring(0, 1);
            String secondLetter = userEid.substring(1, 2);
            filename = basepath + File.separator + firstLetter + File.separator + secondLetter + File.separator + userEid + ".jpg";
        }
        if (log.isDebugEnabled()) {
            log.debug("Path to official image on filesystem is: " + filename);
        }
        return filename;
    }

    private byte[] getUrlAsBytes(String url) {
        byte[] data = null;
        try {
            URL u = new URL(url);
            URLConnection uc = u.openConnection();
            uc.setReadTimeout(5000);
            InputStream inputStream = uc.getInputStream();
            data = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error("Failed to retrieve url bytes: " + e.getClass() + ": " + e.getMessage());
        }
        return data;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setPrivacyLogic(ProfilePrivacyLogic privacyLogic) {
        this.privacyLogic = privacyLogic;
    }

    public void setConnectionsLogic(ProfileConnectionsLogic connectionsLogic) {
        this.connectionsLogic = connectionsLogic;
    }

    public void setPreferencesLogic(ProfilePreferencesLogic preferencesLogic) {
        this.preferencesLogic = preferencesLogic;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }
}

