/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.logic.ProfileLinkLogic;
import org.sakaiproject.profile2.logic.ProfileMessagingLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.Message;
import org.sakaiproject.profile2.model.MessageParticipant;
import org.sakaiproject.profile2.model.MessageThread;
import org.sakaiproject.profile2.types.EmailType;
import org.sakaiproject.profile2.util.ProfileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMessagingLogicImpl
implements ProfileMessagingLogic {
    private static final Logger log = LoggerFactory.getLogger(ProfileMessagingLogicImpl.class);
    private SakaiProxy sakaiProxy;
    private ProfileLinkLogic linkLogic;
    private ProfilePreferencesLogic preferencesLogic;
    private ProfileDao dao;

    public int getAllUnreadMessagesCount(String userId) {
        return this.dao.getAllUnreadMessagesCount(userId);
    }

    public int getThreadsWithUnreadMessagesCount(String userId) {
        return this.dao.getThreadsWithUnreadMessagesCount(userId);
    }

    public int getSentMessagesCount(String userId) {
        return this.dao.getSentMessagesCount(userId);
    }

    public boolean sendNewMessage(String uuidTo, String uuidFrom, String threadId, String subject, String messageStr) {
        MessageThread thread = new MessageThread();
        thread.setId(threadId);
        if (StringUtils.isBlank((String)subject)) {
            thread.setSubject("(no subject)");
        } else {
            thread.setSubject(subject);
        }
        Message message = new Message();
        message.setId(ProfileUtils.generateUuid());
        message.setFrom(uuidFrom);
        message.setMessage(messageStr);
        message.setDatePosted(new Date());
        message.setThread(thread.getId());
        ArrayList<String> threadParticipants = new ArrayList<String>();
        threadParticipants.add(uuidTo);
        threadParticipants.add(uuidFrom);
        ArrayList<MessageParticipant> participants = new ArrayList<MessageParticipant>();
        for (String threadParticipant : threadParticipants) {
            MessageParticipant p = new MessageParticipant();
            p.setMessageId(message.getId());
            p.setUuid(threadParticipant);
            if (StringUtils.equals((String)threadParticipant, (String)message.getFrom())) {
                p.setRead(true);
            } else {
                p.setRead(false);
            }
            p.setDeleted(false);
            participants.add(p);
        }
        if (this.saveAllNewMessageParts(thread, message, participants)) {
            this.sendMessageEmailNotification(threadParticipants, uuidFrom, threadId, subject, messageStr, EmailType.EMAIL_NOTIFICATION_MESSAGE_NEW);
            this.sakaiProxy.postEvent("profile.message.sent", "/profile/" + uuidTo, true);
            return true;
        }
        return false;
    }

    public Message replyToThread(String threadId, String reply, String uuidFrom) {
        try {
            Message message = new Message();
            message.setId(ProfileUtils.generateUuid());
            message.setFrom(uuidFrom);
            message.setMessage(reply);
            message.setDatePosted(new Date());
            message.setThread(threadId);
            this.dao.saveNewMessage(message);
            String subject = this.getMessageThread(threadId).getSubject();
            List<String> uuids = this.getThreadParticipants(threadId);
            for (String uuidTo : uuids) {
                MessageParticipant participant = this.getDefaultMessageParticipantRecord(message.getId(), uuidTo);
                if (StringUtils.equals((String)uuidFrom, (String)uuidTo)) {
                    participant.setRead(true);
                }
                this.dao.saveNewMessageParticipant(participant);
            }
            this.sendMessageEmailNotification(uuids, uuidFrom, threadId, subject, reply, EmailType.EMAIL_NOTIFICATION_MESSAGE_REPLY);
            return message;
        }
        catch (Exception e) {
            log.error("ProfileLogic.replyToThread(): Couldn't send reply: " + e.getClass() + " : " + e.getMessage());
            return null;
        }
    }

    public List<MessageThread> getMessageThreads(String userId) {
        List<MessageThread> threads = this.dao.getMessageThreads(userId);
        for (MessageThread thread : threads) {
            thread.setMostRecentMessage(this.dao.getLatestMessageInThread(thread.getId()));
        }
        return threads;
    }

    public int getMessageThreadsCount(String userId) {
        return this.dao.getMessageThreadsCount(userId);
    }

    public List<Message> getMessagesInThread(String threadId) {
        return this.dao.getMessagesInThread(threadId);
    }

    public int getMessagesInThreadCount(String threadId) {
        return this.dao.getMessagesInThreadCount(threadId);
    }

    public Message getMessage(String id) {
        return this.dao.getMessage(id);
    }

    public MessageThread getMessageThread(String threadId) {
        MessageThread thread = this.dao.getMessageThread(threadId);
        if (thread == null) {
            return null;
        }
        thread.setMostRecentMessage(this.dao.getLatestMessageInThread(threadId));
        return thread;
    }

    public boolean toggleMessageRead(MessageParticipant participant, boolean status) {
        return this.dao.toggleMessageRead(participant, status);
    }

    public MessageParticipant getMessageParticipant(String messageId, String userUuid) {
        return this.dao.getMessageParticipant(messageId, userUuid);
    }

    private MessageParticipant getDefaultMessageParticipantRecord(String messageId, String userUuid) {
        MessageParticipant participant = new MessageParticipant();
        participant.setMessageId(messageId);
        participant.setUuid(userUuid);
        participant.setRead(false);
        participant.setDeleted(false);
        return participant;
    }

    public List<String> getThreadParticipants(String threadId) {
        return this.dao.getThreadParticipants(threadId);
    }

    public boolean isThreadParticipant(String threadId, String userId) {
        return this.getThreadParticipants(threadId).contains(userId);
    }

    public String getThreadSubject(String threadId) {
        MessageThread thread = this.dao.getMessageThread(threadId);
        return thread.getSubject();
    }

    private void sendMessageEmailNotification(List<String> toUuids, String fromUuid, String directId, String subject, String messageStr, EmailType messageType) {
        String emailTemplateKey;
        Iterator<String> it = toUuids.iterator();
        while (it.hasNext()) {
            if (this.preferencesLogic.isPreferenceEnabled(it.next(), messageType.toPreference())) continue;
            it.remove();
        }
        toUuids.remove(fromUuid);
        if (messageType == EmailType.EMAIL_NOTIFICATION_MESSAGE_NEW) {
            emailTemplateKey = "profile2.messageNew";
            HashMap<String, String> replacementValues = new HashMap<String, String>();
            replacementValues.put("senderDisplayName", this.sakaiProxy.getUserDisplayName(fromUuid));
            replacementValues.put("localSakaiName", this.sakaiProxy.getServiceName());
            replacementValues.put("messageSubject", subject);
            replacementValues.put("messageBody", messageStr);
            replacementValues.put("messageLink", this.linkLogic.getEntityLinkToProfileMessages(directId));
            replacementValues.put("localSakaiUrl", this.sakaiProxy.getPortalUrl());
            replacementValues.put("toolName", this.sakaiProxy.getCurrentToolTitle());
            this.sakaiProxy.sendEmail(toUuids, emailTemplateKey, replacementValues);
            return;
        }
        if (messageType == EmailType.EMAIL_NOTIFICATION_MESSAGE_REPLY) {
            emailTemplateKey = "profile2.messageReply";
            HashMap<String, String> replacementValues = new HashMap<String, String>();
            replacementValues.put("senderDisplayName", this.sakaiProxy.getUserDisplayName(fromUuid));
            replacementValues.put("localSakaiName", this.sakaiProxy.getServiceName());
            replacementValues.put("messageSubject", subject);
            replacementValues.put("messageBody", messageStr);
            replacementValues.put("messageLink", this.linkLogic.getEntityLinkToProfileMessages(directId));
            replacementValues.put("localSakaiUrl", this.sakaiProxy.getPortalUrl());
            replacementValues.put("toolName", this.sakaiProxy.getCurrentToolTitle());
            this.sakaiProxy.sendEmail(toUuids, emailTemplateKey, replacementValues);
            return;
        }
    }

    private boolean saveAllNewMessageParts(MessageThread thread, Message message, List<MessageParticipant> participants) {
        this.dao.saveNewThread(thread);
        this.dao.saveNewMessage(message);
        this.dao.saveNewMessageParticipants(participants);
        return true;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setLinkLogic(ProfileLinkLogic linkLogic) {
        this.linkLogic = linkLogic;
    }

    public void setPreferencesLogic(ProfilePreferencesLogic preferencesLogic) {
        this.preferencesLogic = preferencesLogic;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }
}

