/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.profile2.cache.CacheManager;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.types.PreferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePreferencesLogicImpl
implements ProfilePreferencesLogic {
    private static final Logger log = LoggerFactory.getLogger(ProfilePreferencesLogicImpl.class);
    private Cache cache;
    private final String CACHE_NAME = "org.sakaiproject.profile2.cache.preferences";
    private SakaiProxy sakaiProxy;
    private ProfileDao dao;
    private CacheManager cacheManager;

    public ProfilePreferences getPreferencesRecordForUser(String userId) {
        return this.getPreferencesRecordForUser(userId, true);
    }

    public ProfilePreferences getPreferencesRecordForUser(String userId, boolean useCache) {
        if (userId == null) {
            throw new IllegalArgumentException("Null argument in ProfileLogic.getPreferencesRecordForUser");
        }
        ProfilePreferences prefs = null;
        if (useCache && this.cache.containsKey((Object)userId)) {
            log.debug("Fetching preferences record from cache for: " + userId);
            prefs = (ProfilePreferences)this.cache.get((Object)userId);
            if (prefs != null) {
                return prefs;
            }
            log.debug("Preferences cache appears to have expired for " + userId);
            this.evictFromCache(userId);
        }
        prefs = this.dao.getPreferencesRecordForUser(userId);
        log.debug("Fetching preferences record from dao for: " + userId);
        if (prefs == null && (prefs = this.dao.addNewPreferencesRecord(this.getDefaultPreferencesRecord(userId))) != null) {
            this.sakaiProxy.postEvent("profile.prefs.new", "/profile/" + userId, true);
            log.info("Created default preferences record for user: " + userId);
        }
        if (prefs != null) {
            log.debug("Adding preferences record to cache for: " + userId);
            this.cache.put((Object)userId, (Object)prefs);
        }
        if (prefs == null) {
            log.error("Couldn't retrieve or create a preferences record for user: " + userId + " This is an error and you need to fix your installation.");
        }
        return prefs;
    }

    public boolean savePreferencesRecord(ProfilePreferences prefs) {
        if (this.dao.savePreferencesRecord(prefs)) {
            log.info("Updated preferences record for user: " + prefs.getUserUuid());
            log.debug("Updated preferences record in cache for: " + prefs.getUserUuid());
            this.cache.put((Object)prefs.getUserUuid(), (Object)prefs);
            return true;
        }
        return false;
    }

    public boolean isPreferenceEnabled(String userUuid, PreferenceType type) {
        ProfilePreferences prefs = this.getPreferencesRecordForUser(userUuid);
        boolean result = false;
        switch (type) {
            case EMAIL_NOTIFICATION_REQUEST: {
                result = prefs.isRequestEmailEnabled();
                break;
            }
            case EMAIL_NOTIFICATION_CONFIRM: {
                result = prefs.isConfirmEmailEnabled();
                break;
            }
            case EMAIL_NOTIFICATION_MESSAGE_NEW: {
                result = prefs.isMessageNewEmailEnabled();
                break;
            }
            case EMAIL_NOTIFICATION_MESSAGE_REPLY: {
                result = prefs.isMessageReplyEmailEnabled();
                break;
            }
            case EMAIL_NOTIFICATION_WALL_EVENT_NEW: {
                result = prefs.isWallItemNewEmailEnabled();
                break;
            }
            case EMAIL_NOTIFICATION_WALL_STATUS_NEW: {
                result = prefs.isWallItemNewEmailEnabled();
                break;
            }
            case EMAIL_NOTIFICATION_WALL_POST_MY_NEW: {
                result = prefs.isWallItemNewEmailEnabled();
                break;
            }
            case EMAIL_NOTIFICATION_WALL_POST_CONNECTION_NEW: {
                result = prefs.isWallItemNewEmailEnabled();
                break;
            }
            case EMAIL_NOTIFICATION_WORKSITE_NEW: {
                result = prefs.isWorksiteNewEmailEnabled();
                break;
            }
            default: {
                log.debug("ProfileLogic.isPreferenceEnabled. False for userId: " + userUuid + ", type: " + type);
                result = false;
            }
        }
        return result;
    }

    private ProfilePreferences getDefaultPreferencesRecord(String userId) {
        ProfilePreferences prefs = new ProfilePreferences();
        prefs.setUserUuid(userId);
        prefs.setRequestEmailEnabled(true);
        prefs.setConfirmEmailEnabled(true);
        prefs.setMessageNewEmailEnabled(true);
        prefs.setMessageReplyEmailEnabled(true);
        prefs.setWallItemNewEmailEnabled(true);
        prefs.setWorksiteNewEmailEnabled(true);
        prefs.setUseOfficialImage(false);
        prefs.setShowKudos(true);
        prefs.setShowGalleryFeed(true);
        prefs.setUseGravatar(false);
        prefs.setShowOnlineStatus(true);
        return prefs;
    }

    private void evictFromCache(String cacheKey) {
        this.cache.remove((Object)cacheKey);
        log.debug("Evicted data in cache for key: " + cacheKey);
    }

    public void init() {
        this.cache = this.cacheManager.createCache("org.sakaiproject.profile2.cache.preferences");
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

