/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.profile2.logic.ProfileLinkLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;

public class ProfileLinkLogicImpl
implements ProfileLinkLogic {
    private SakaiProxy sakaiProxy;

    public String getInternalDirectUrlToUserProfile() {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("Must be logged in.");
        }
        return this.sakaiProxy.getDirectUrlToProfileComponent(currentUserUuid, "profile", null);
    }

    public String getInternalDirectUrlToUserProfile(String userUuid) {
        if (this.sakaiProxy.getCurrentUserId() == null) {
            throw new SecurityException("Must be logged in.");
        }
        return this.sakaiProxy.getDirectUrlToProfileComponent(userUuid, "viewprofile", null);
    }

    public String getInternalDirectUrlToUserWall(String userUuid, String wallItemId) {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("Must be logged in.");
        }
        String extraParams = null;
        if (this.sakaiProxy.isUsingNormalPortal()) {
            HashMap<String, String> vars = new HashMap<String, String>();
            vars.put("id", userUuid);
            vars.put("wallItemId", wallItemId);
            vars.put("tab", "1");
            extraParams = this.getFormattedStateParamForWicketTool("org.sakaiproject.profile2.tool.pages.ViewProfile", vars);
        }
        return this.sakaiProxy.getDirectUrlToUserProfile(currentUserUuid, extraParams);
    }

    public String getInternalDirectUrlToUserMessages(String threadId) {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("Must be logged in.");
        }
        String extraParams = null;
        if (this.sakaiProxy.isUsingNormalPortal()) {
            HashMap<String, String> vars = null;
            if (StringUtils.isNotBlank((String)threadId)) {
                vars = new HashMap<String, String>();
                vars.put("thread", threadId);
            }
            extraParams = this.getFormattedStateParamForWicketTool("org.sakaiproject.profile2.tool.pages.MyMessages", vars);
        }
        return this.sakaiProxy.getDirectUrlToUserProfile(currentUserUuid, extraParams);
    }

    public String getInternalDirectUrlToUserConnections() {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (currentUserUuid == null) {
            throw new SecurityException("Must be logged in.");
        }
        String extraParams = null;
        if (this.sakaiProxy.isUsingNormalPortal()) {
            extraParams = this.getFormattedStateParamForWicketTool("org.sakaiproject.profile2.tool.pages.MyFriends", null);
        }
        return this.sakaiProxy.getDirectUrlToUserProfile(currentUserUuid, extraParams);
    }

    public String getEntityLinkToProfileHome(String userUuid) {
        StringBuilder url = new StringBuilder();
        url.append(this.getEntityLinkBase());
        url.append("/profile");
        if (StringUtils.isNotBlank((String)userUuid)) {
            url.append("/");
            url.append(userUuid);
        }
        return url.toString();
    }

    public String getEntityLinkToProfileMessages(String threadId) {
        StringBuilder url = new StringBuilder();
        url.append(this.getEntityLinkBase());
        url.append("/messages");
        if (StringUtils.isNotBlank((String)threadId)) {
            url.append("/");
            url.append(threadId);
        }
        return url.toString();
    }

    public String getEntityLinkToProfileConnections() {
        StringBuilder url = new StringBuilder();
        url.append(this.getEntityLinkBase());
        url.append("/connections");
        return url.toString();
    }

    public String getEntityLinkToProfileWall(String userUuid) {
        StringBuilder url = new StringBuilder();
        url.append(this.getEntityLinkBase());
        url.append("/wall");
        if (StringUtils.isNotBlank((String)userUuid)) {
            url.append("/");
            url.append(userUuid);
        }
        return url.toString();
    }

    @Deprecated
    private String getFormattedStateParamForWicketTool(String pageClass, Map<String, String> vars) {
        StringBuilder params = new StringBuilder();
        params.append("?wicket:bookmarkablePage=:");
        params.append(pageClass);
        if (vars != null) {
            for (Map.Entry<String, String> var : vars.entrySet()) {
                params.append("&");
                params.append(var.getKey());
                params.append("=");
                params.append(var.getValue());
            }
        }
        return params.toString();
    }

    private String getEntityLinkBase() {
        StringBuilder base = new StringBuilder();
        base.append(this.sakaiProxy.getServerUrl());
        base.append("/direct");
        base.append("/my");
        return base.toString();
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }
}

