/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileLinkLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.model.WallItem;
import org.sakaiproject.profile2.model.WallItemComment;
import org.sakaiproject.profile2.types.EmailType;
import org.sakaiproject.profile2.types.PrivacyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileWallLogicImpl
implements ProfileWallLogic {
    private static final Logger log = LoggerFactory.getLogger(ProfileWallLogic.class);
    private ProfileDao dao;
    private ProfilePrivacyLogic privacyLogic;
    private ProfileConnectionsLogic connectionsLogic;
    private ProfileLinkLogic linkLogic;
    private ProfilePreferencesLogic preferencesLogic;
    private SakaiProxy sakaiProxy;

    private boolean addNewItemToWall(int itemType, String itemText, String userUuid) {
        WallItem wallItem = new WallItem();
        wallItem.setUserUuid(userUuid);
        wallItem.setCreatorUuid(userUuid);
        wallItem.setType(itemType);
        wallItem.setDate(new Date());
        wallItem.setText(itemText);
        return this.dao.addNewWallItemForUser(userUuid, wallItem);
    }

    public boolean addNewCommentToWallItem(WallItemComment wallItemComment) {
        if (this.dao.addNewCommentToWallItem(wallItemComment)) {
            String ref = "/profile/wall/item/comment/" + wallItemComment.getId();
            this.sakaiProxy.postEvent("profile.wall.item.comment.new", ref, false);
            return true;
        }
        return false;
    }

    private void notifyConnections(int itemType, String itemText, final String userUuid) {
        EmailType itemMessageType;
        final List connections = this.connectionsLogic.getConnectionsForUser(userUuid);
        if (null == connections || 0 == connections.size()) {
            return;
        }
        switch (itemType) {
            case 0: {
                itemMessageType = EmailType.EMAIL_NOTIFICATION_WALL_EVENT_NEW;
                break;
            }
            case 1: {
                itemMessageType = EmailType.EMAIL_NOTIFICATION_WALL_STATUS_NEW;
                break;
            }
            default: {
                log.warn("not sending email due to unknown wall item type: " + itemType);
                return;
            }
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                ArrayList<String> uuidsToEmail = new ArrayList<String>();
                for (Person connection : connections) {
                    if (!ProfileWallLogicImpl.this.preferencesLogic.isPreferenceEnabled(connection.getUuid(), itemMessageType.toPreference())) continue;
                    uuidsToEmail.add(connection.getUuid());
                }
                ProfileWallLogicImpl.this.sendWallNotificationEmailToConnections(uuidsToEmail, userUuid, itemMessageType);
            }
        };
        thread.start();
    }

    public void addNewEventToWall(String event, String userUuid) {
        if (this.addNewItemToWall(0, event, userUuid)) {
            this.notifyConnections(0, event, userUuid);
        }
    }

    public void addNewStatusToWall(String status, String userUuid) {
        if (this.addNewItemToWall(1, status, userUuid)) {
            this.notifyConnections(1, status, userUuid);
        }
    }

    public boolean postWallItemToWall(final String userUuid, WallItem wallItem) {
        if (!this.dao.addNewWallItemForUser(userUuid, wallItem)) {
            return false;
        }
        String ref = "/profile/" + wallItem.getUserUuid() + "/wall/item/" + wallItem.getId();
        this.sakaiProxy.postEvent("profile.wall.item.new", ref, false);
        if (!StringUtils.equals((String)this.sakaiProxy.getCurrentUserId(), (String)userUuid)) {
            this.sendWallNotificationEmailToUser(userUuid, wallItem.getCreatorUuid(), EmailType.EMAIL_NOTIFICATION_WALL_POST_MY_NEW);
        } else {
            final List connections = this.connectionsLogic.getConnectionsForUser(userUuid);
            if (null != connections) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        ArrayList<String> uuidsToEmail = new ArrayList<String>();
                        for (Person connection : connections) {
                            if (!ProfileWallLogicImpl.this.preferencesLogic.isPreferenceEnabled(connection.getUuid(), EmailType.EMAIL_NOTIFICATION_WALL_POST_CONNECTION_NEW.toPreference())) continue;
                            uuidsToEmail.add(connection.getUuid());
                        }
                        ProfileWallLogicImpl.this.sendWallNotificationEmailToConnections(uuidsToEmail, userUuid, EmailType.EMAIL_NOTIFICATION_WALL_POST_CONNECTION_NEW);
                    }
                };
                thread.start();
            }
        }
        return true;
    }

    public boolean removeWallItemFromWall(WallItem wallItem) {
        if (this.dao.removeWallItemFromWall(wallItem)) {
            String ref = "/profile/wall/item/remove/" + wallItem.getId();
            this.sakaiProxy.postEvent("profile.wall.item.remove", ref, false);
            return true;
        }
        return false;
    }

    public WallItem getWallItem(long wallItemId) {
        return this.dao.getWallItem(wallItemId);
    }

    public WallItemComment getWallItemComment(long wallItemCommentId) {
        return this.dao.getWallItemComment(wallItemCommentId);
    }

    public List<WallItem> getWallItemsForUser(String userUuid, ProfilePrivacy privacy) {
        if (null == userUuid) {
            throw new IllegalArgumentException("must provide user id");
        }
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (null == currentUserUuid) {
            throw new SecurityException("You must be logged in to make a request for a user's wall items.");
        }
        if (null == privacy) {
            return new ArrayList<WallItem>();
        }
        if (!(StringUtils.equals((String)userUuid, (String)currentUserUuid) || this.sakaiProxy.isSuperUser() || this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_MYWALL))) {
            return new ArrayList<WallItem>();
        }
        List<WallItem> wallItems = this.dao.getWallItemsForUser(userUuid);
        ArrayList<WallItem> filteredWallItems = new ArrayList<WallItem>();
        for (WallItem wallItem : wallItems) {
            if (StringUtils.equals((String)userUuid, (String)currentUserUuid) || this.sakaiProxy.isSuperUser()) {
                filteredWallItems.add(wallItem);
                continue;
            }
            if (!this.privacyLogic.isActionAllowed(wallItem.getCreatorUuid(), currentUserUuid, PrivacyType.PRIVACY_OPTION_MYWALL)) continue;
            filteredWallItems.add(wallItem);
        }
        Collections.sort(filteredWallItems);
        return filteredWallItems;
    }

    public List<WallItem> getWallItemsForUser(String userUuid) {
        return this.getWallItemsForUser(userUuid, this.privacyLogic.getPrivacyRecordForUser(userUuid));
    }

    public int getWallItemsCount(String userUuid) {
        return this.getWallItemsCount(userUuid, this.privacyLogic.getPrivacyRecordForUser(userUuid));
    }

    public int getWallItemsCount(String userUuid, ProfilePrivacy privacy) {
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (null == this.sakaiProxy.getCurrentUserId()) {
            throw new SecurityException("You must be logged in to make a request for a user's wall items.");
        }
        if (null == privacy) {
            return 0;
        }
        if (!(StringUtils.equals((String)userUuid, (String)currentUserUuid) || this.sakaiProxy.isSuperUser() || this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_MYWALL))) {
            return 0;
        }
        List<WallItem> wallItems = this.dao.getWallItemsForUser(userUuid);
        ArrayList<WallItem> filteredWallItems = new ArrayList<WallItem>();
        for (WallItem wallItem : wallItems) {
            if (StringUtils.equals((String)userUuid, (String)currentUserUuid) || this.sakaiProxy.isSuperUser()) {
                filteredWallItems.add(wallItem);
                continue;
            }
            if (!this.privacyLogic.isActionAllowed(wallItem.getCreatorUuid(), currentUserUuid, PrivacyType.PRIVACY_OPTION_MYWALL)) continue;
            filteredWallItems.add(wallItem);
        }
        return filteredWallItems.size();
    }

    private void sendWallNotificationEmailToConnections(List<String> toUuids, String fromUuid, EmailType messageType) {
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("senderDisplayName", this.sakaiProxy.getUserDisplayName(fromUuid));
        replacementValues.put("senderWallLink", this.linkLogic.getEntityLinkToProfileWall(fromUuid));
        replacementValues.put("localSakaiName", this.sakaiProxy.getServiceName());
        replacementValues.put("localSakaiUrl", this.sakaiProxy.getPortalUrl());
        replacementValues.put("toolName", this.sakaiProxy.getCurrentToolTitle());
        String emailTemplateKey = null;
        if (EmailType.EMAIL_NOTIFICATION_WALL_EVENT_NEW == messageType) {
            emailTemplateKey = "profile2.wallEventNew";
        } else if (EmailType.EMAIL_NOTIFICATION_WALL_POST_CONNECTION_NEW == messageType) {
            emailTemplateKey = "profile2.wallPostConnectionWallNew";
        } else if (EmailType.EMAIL_NOTIFICATION_WALL_STATUS_NEW == messageType) {
            emailTemplateKey = "profile2.wallStatusNew";
        }
        if (null != emailTemplateKey) {
            for (String toUuid : toUuids) {
                replacementValues.put("wallLink", this.linkLogic.getEntityLinkToProfileWall(toUuid));
                this.sakaiProxy.sendEmail(toUuid, emailTemplateKey, replacementValues);
            }
        } else {
            log.warn("not sending email, unknown message type for sendWallNotificationEmailToConnections: " + messageType);
        }
    }

    private void sendWallNotificationEmailToUser(String toUuid, String fromUuid, EmailType messageType) {
        if (!this.preferencesLogic.isPreferenceEnabled(toUuid, messageType.toPreference())) {
            return;
        }
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("senderDisplayName", this.sakaiProxy.getUserDisplayName(fromUuid));
        replacementValues.put("localSakaiName", this.sakaiProxy.getServiceName());
        replacementValues.put("localSakaiUrl", this.sakaiProxy.getPortalUrl());
        replacementValues.put("toolName", this.sakaiProxy.getCurrentToolTitle());
        String emailTemplateKey = null;
        if (EmailType.EMAIL_NOTIFICATION_WALL_POST_MY_NEW == messageType) {
            emailTemplateKey = "profile2.wallPostMyWallNew";
            replacementValues.put("profileLink", this.linkLogic.getEntityLinkToProfileWall(toUuid));
        }
        if (null != emailTemplateKey) {
            this.sakaiProxy.sendEmail(toUuid, emailTemplateKey, replacementValues);
        } else {
            log.warn("not sending email, unknown message type for sendWallNotificationEmailToUser: " + messageType);
        }
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }

    public void setPrivacyLogic(ProfilePrivacyLogic privacyLogic) {
        this.privacyLogic = privacyLogic;
    }

    public void setConnectionsLogic(ProfileConnectionsLogic connectionsLogic) {
        this.connectionsLogic = connectionsLogic;
    }

    public void setLinkLogic(ProfileLinkLogic linkLogic) {
        this.linkLogic = linkLogic;
    }

    public void setPreferencesLogic(ProfilePreferencesLogic preferencesLogic) {
        this.preferencesLogic = preferencesLogic;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }
}

