/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.profile2.logic.ProfileWorksiteLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.util.Messages;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.user.api.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ProfileWorksiteLogicImpl
implements ProfileWorksiteLogic {
    private static final Logger log = LoggerFactory.getLogger(ProfileWorksiteLogicImpl.class);
    private static final String SITE_TYPE_PROJECT = "project";
    private static final String ROLE_ACCESS = "access";
    private static final String ROLE_MAINTAIN = "maintain";
    private static final String TOOL_ID_HOME = "home";
    private static final String TOOL_ID_IFRAME = "sakai.iframe";
    private static final String TOOL_ID_SUMMARY_CALENDAR = "sakai.summary.calendar";
    private static final String TOOL_ID_SYNOPTIC_ANNOUNCEMENT = "sakai.synoptic.announcement";
    private static final String TOOL_ID_SYNOPTIC_CHAT = "sakai.synoptic.chat";
    private static final String TOOL_ID_SYNOPTIC_DISCUSSION = "sakai.synoptic.discussion";
    private static final String TOOL_ID_SYNOPTIC_MESSAGECENTER = "sakai.synoptic.messagecenter";
    private static final Map<String, List<String>> SYNOPTIC_TOOL_ID_MAP = new HashMap<String, List<String>>();
    private static final Map<String, String> TOOLS_WITH_SYNOPTIC_ID_MAP;
    private static final String HOME_TOOL = "sakai.iframe.site";
    private static final String SITEINFO_TOOL = "sakai.siteinfo";
    private static final String MEMBERSHIP_TOOL = "sakai.membership";
    private static final String WORKSITE_SETUP_TOOLS = "wsetup.home.toolids";
    private SakaiProxy sakaiProxy;

    public boolean createWorksite(String siteTitle, String ownerId, Collection<Person> members, boolean notifyByEmail) {
        if (!this.sakaiProxy.isUserAllowedAddSite(ownerId)) {
            log.warn("user " + ownerId + " tried to create worksite without site.add");
            return false;
        }
        String siteId = this.sakaiProxy.createUuid();
        while (this.sakaiProxy.checkForSite(siteId)) {
            siteId = this.sakaiProxy.createUuid();
        }
        Site site = this.sakaiProxy.addSite(siteId, SITE_TYPE_PROJECT);
        if (null == site) {
            log.warn("unable to create new worksite from Profile2");
            return false;
        }
        User owner = this.sakaiProxy.getUserById(ownerId);
        if (null == owner) {
            log.warn("unknown user " + ownerId + " tried to create worksite");
            return false;
        }
        site.addMember(ownerId, site.getMaintainRole(), true, false);
        this.addSiteMembers(members, site);
        this.addTitleAndDescription(siteTitle, ownerId, site);
        this.addHomePageAndTools(site);
        site.setPublished(true);
        if (!this.sakaiProxy.saveSite(site)) {
            log.warn("unable to save new worksite from Profile2");
            return false;
        }
        this.emailSiteMembers(siteTitle, ownerId, members, notifyByEmail, site);
        return true;
    }

    private void addHomePageAndTools(Site site) {
        SitePage homePage = site.addPage();
        homePage.getPropertiesEdit().addProperty("is_home_page", Boolean.TRUE.toString());
        Tool homeTool = this.sakaiProxy.getTool(HOME_TOOL);
        ToolConfiguration homeToolConfig = homePage.addTool();
        homeToolConfig.setTool(TOOL_ID_HOME, homeTool);
        homeToolConfig.setTitle(homeTool.getTitle());
        List toolIds = this.sakaiProxy.getToolsRequired(SITE_TYPE_PROJECT);
        int synopticToolIndex = this.addRequiredToolsForWorksite(site, homePage, toolIds);
        if (synopticToolIndex > 0) {
            homePage.setLayout(1);
        }
        this.addRequiredHomeTools(homePage, toolIds, synopticToolIndex);
    }

    private int addRequiredToolsForWorksite(Site site, SitePage homePage, List<String> toolIds) {
        int synopticToolIndex = 0;
        for (String toolId : toolIds) {
            SitePage toolPage;
            if (this.isToolToIgnore(toolId)) continue;
            if (this.isToolWithSynopticTool(toolId)) {
                ToolConfiguration toolConfig;
                toolPage = site.addPage();
                toolPage.addTool(toolId);
                if (this.isToolAlreadyAdded(homePage, TOOLS_WITH_SYNOPTIC_ID_MAP.get(toolId)) || null == (toolConfig = homePage.addTool(TOOLS_WITH_SYNOPTIC_ID_MAP.get(toolId)))) continue;
                toolConfig.setLayoutHints(synopticToolIndex + ",1");
                for (int i = 0; i < synopticToolIndex; ++i) {
                    toolConfig.moveUp();
                }
                ++synopticToolIndex;
                continue;
            }
            if (null == this.sakaiProxy.getTool(toolId)) continue;
            toolPage = site.addPage();
            toolPage.addTool(toolId);
        }
        return synopticToolIndex;
    }

    private void addRequiredHomeTools(SitePage homePage, List<String> toolIds, int synopticToolIndex) {
        List<String> homeToolIds = this.getHomeToolIds();
        for (String homeToolId : homeToolIds) {
            ToolConfiguration toolConfig;
            if (this.isToolToIgnore(homeToolId) || SYNOPTIC_TOOL_ID_MAP.get(homeToolId) == null || !CollectionUtils.containsAny((Collection)SYNOPTIC_TOOL_ID_MAP.get(homeToolId), toolIds) || this.isToolAlreadyAdded(homePage, homeToolId) || null == (toolConfig = homePage.addTool(homeToolId))) continue;
            toolConfig.setLayoutHints(synopticToolIndex + ",1");
            for (int i = 0; i < synopticToolIndex; ++i) {
                toolConfig.moveUp();
            }
            ++synopticToolIndex;
        }
    }

    private List<String> getHomeToolIds() {
        ArrayList<String> homeToolIds = null != this.sakaiProxy.getServerConfigurationParameter("wsetup.home.toolids.project", null) ? new ArrayList<String>(Arrays.asList(this.sakaiProxy.getServerConfigurationParameter("wsetup.home.toolids.project", null))) : (null != this.sakaiProxy.getServerConfigurationParameter(WORKSITE_SETUP_TOOLS, null) ? new ArrayList<String>(Arrays.asList(this.sakaiProxy.getServerConfigurationParameter(WORKSITE_SETUP_TOOLS, null))) : new ArrayList<String>());
        return homeToolIds;
    }

    private void addTitleAndDescription(String siteTitle, String ownerId, Site site) {
        site.setTitle(siteTitle);
        site.setDescription(Messages.getString((String)"worksite.help", (Object[])new Object[]{this.sakaiProxy.getTool(SITEINFO_TOOL).getTitle(), this.sakaiProxy.getTool(MEMBERSHIP_TOOL).getTitle(), this.sakaiProxy.getUserDisplayName(ownerId), this.sakaiProxy.getUserEmail(ownerId), siteTitle}));
    }

    private void addSiteMembers(Collection<Person> members, Site site) {
        if (null != members) {
            for (Person member : members) {
                User user = this.sakaiProxy.getUserById(member.getUuid());
                if (null != user) {
                    site.addMember(member.getUuid(), this.sakaiProxy.getServerConfigurationParameter("profile2.worksite.access.role", ROLE_ACCESS), true, false);
                    continue;
                }
                log.warn("attempt to add unknown user " + member.getUuid() + " to worksite");
            }
        }
    }

    private boolean isToolAlreadyAdded(SitePage homePage, String homeToolId) {
        for (ToolConfiguration tool : homePage.getTools()) {
            if (!StringUtils.equals((String)tool.getToolId(), (String)homeToolId)) continue;
            return true;
        }
        return false;
    }

    private boolean isToolWithSynopticTool(String toolId) {
        return TOOLS_WITH_SYNOPTIC_ID_MAP.containsKey(toolId);
    }

    private boolean isToolToIgnore(String toolId) {
        return StringUtils.equals((String)toolId, (String)TOOL_ID_IFRAME) || StringUtils.equals((String)toolId, (String)HOME_TOOL);
    }

    private void emailSiteMembers(final String siteTitle, final String ownerId, final Collection<Person> members, boolean notifyByEmail, final Site site) {
        if (notifyByEmail) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ProfileWorksiteLogicImpl.this.emailSiteMembers(siteTitle, site.getUrl(), ownerId, members);
                }
            };
            thread.start();
        }
    }

    private void emailSiteMembers(String siteTitle, String siteUrl, String ownerId, Collection<Person> members) {
        for (Person member : members) {
            if (!member.getPreferences().isWorksiteNewEmailEnabled()) continue;
            this.emailSiteMember(siteTitle, siteUrl, ownerId, member);
        }
    }

    private void emailSiteMember(String siteTitle, String siteUrl, String ownerId, Person member) {
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("senderDisplayName", this.sakaiProxy.getUserDisplayName(ownerId));
        replacementValues.put("worksiteTitle", siteTitle);
        replacementValues.put("worksiteLink", siteUrl);
        replacementValues.put("localSakaiName", this.sakaiProxy.getServiceName());
        replacementValues.put("localSakaiUrl", this.sakaiProxy.getPortalUrl());
        replacementValues.put("toolName", this.sakaiProxy.getCurrentToolTitle());
        this.sakaiProxy.sendEmail(member.getUuid(), "profile2.worksiteNew", replacementValues);
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    static {
        SYNOPTIC_TOOL_ID_MAP.put(TOOL_ID_SUMMARY_CALENDAR, new ArrayList<String>(Arrays.asList("sakai.schedule")));
        SYNOPTIC_TOOL_ID_MAP.put(TOOL_ID_SYNOPTIC_ANNOUNCEMENT, new ArrayList<String>(Arrays.asList("sakai.announcements")));
        SYNOPTIC_TOOL_ID_MAP.put(TOOL_ID_SYNOPTIC_CHAT, new ArrayList<String>(Arrays.asList("sakai.chat")));
        SYNOPTIC_TOOL_ID_MAP.put(TOOL_ID_SYNOPTIC_DISCUSSION, new ArrayList<String>(Arrays.asList("sakai.discussion")));
        SYNOPTIC_TOOL_ID_MAP.put(TOOL_ID_SYNOPTIC_MESSAGECENTER, new ArrayList<String>(Arrays.asList("sakai.messages", "sakai.forums", "sakai.messagecenter")));
        TOOLS_WITH_SYNOPTIC_ID_MAP = new HashMap<String, String>();
        TOOLS_WITH_SYNOPTIC_ID_MAP.put("sakai.schedule", TOOL_ID_SUMMARY_CALENDAR);
        TOOLS_WITH_SYNOPTIC_ID_MAP.put("sakai.announcements", TOOL_ID_SYNOPTIC_ANNOUNCEMENT);
        TOOLS_WITH_SYNOPTIC_ID_MAP.put("sakai.chat", TOOL_ID_SYNOPTIC_CHAT);
        TOOLS_WITH_SYNOPTIC_ID_MAP.put("sakai.discussion", TOOL_ID_SYNOPTIC_DISCUSSION);
        TOOLS_WITH_SYNOPTIC_ID_MAP.put("sakai.messages", TOOL_ID_SYNOPTIC_MESSAGECENTER);
        TOOLS_WITH_SYNOPTIC_ID_MAP.put("sakai.forums", TOOL_ID_SYNOPTIC_MESSAGECENTER);
        TOOLS_WITH_SYNOPTIC_ID_MAP.put("sakai.messagecenter", TOOL_ID_SYNOPTIC_MESSAGECENTER);
    }
}

