/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.job;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileExternalIntegrationLogic;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfileKudosLogic;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileMessagingLogic;
import org.sakaiproject.profile2.logic.ProfileStatusLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ExternalIntegrationInfo;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.model.ProfileImage;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KudosJob
implements StatefulJob {
    private static final Logger log = LoggerFactory.getLogger(KudosJob.class);
    private final String BEAN_ID = "org.sakaiproject.profile2.job.KudosJob";
    private final HashMap<String, BigDecimal> RULES = new HashMap<String, BigDecimal>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("nickname", new BigDecimal("1"));
            this.put("birthday", new BigDecimal("0.5"));
            this.put("email", new BigDecimal("1"));
            this.put("homePage", new BigDecimal("1"));
            this.put("workPhone", new BigDecimal("1"));
            this.put("homePhone", new BigDecimal("1"));
            this.put("mobilePhone", new BigDecimal("1"));
            this.put("position", new BigDecimal("0.5"));
            this.put("department", new BigDecimal("0.5"));
            this.put("school", new BigDecimal("0.5"));
            this.put("room", new BigDecimal("0.5"));
            this.put("course", new BigDecimal("0.5"));
            this.put("subjects", new BigDecimal("0.5"));
            this.put("favouriteBooks", new BigDecimal("0.25"));
            this.put("favouriteTvShows", new BigDecimal("0.25"));
            this.put("favouriteMovies", new BigDecimal("0.25"));
            this.put("favouriteQuotes", new BigDecimal("0.25"));
            this.put("personalSummary", new BigDecimal("2"));
            this.put("profileImageShared", new BigDecimal("0.05"));
            this.put("profileImageBonus", new BigDecimal("0.05"));
            this.put("basicInfoShared", new BigDecimal("0.05"));
            this.put("basicInfoBonus", new BigDecimal("0.05"));
            this.put("contactInfoShared", new BigDecimal("0.05"));
            this.put("contactInfoBonus", new BigDecimal("0.05"));
            this.put("personalInfoShared", new BigDecimal("0.05"));
            this.put("personalInfoBonus", new BigDecimal("0.05"));
            this.put("staffInfoShared", new BigDecimal("0.05"));
            this.put("staffInfoBonus", new BigDecimal("0.05"));
            this.put("studentInfoShared", new BigDecimal("0.05"));
            this.put("studentInfoBonus", new BigDecimal("0.05"));
            this.put("viewConnectionsShared", new BigDecimal("0.05"));
            this.put("viewConnectionsBonus", new BigDecimal("0.05"));
            this.put("viewStatusShared", new BigDecimal("0.05"));
            this.put("viewStatusBonus", new BigDecimal("0.05"));
            this.put("viewPicturesShared", new BigDecimal("0.05"));
            this.put("viewPicturesBonus", new BigDecimal("0.05"));
            this.put("showBirthYear", new BigDecimal("0.1"));
            this.put("hasImage", new BigDecimal("5"));
            this.put("hasOneConnection", new BigDecimal("2"));
            this.put("hasMoreThanTenConnections", new BigDecimal("3"));
            this.put("hasOneSentMessage", new BigDecimal("2"));
            this.put("hasMoreThanTenSentMessages", new BigDecimal("3"));
            this.put("hasOneStatusUpdate", new BigDecimal("0.25"));
            this.put("twitterEnabled", new BigDecimal("2"));
            this.put("hasOneGalleryPicture", new BigDecimal("0.25"));
            this.put("hasMoreThanTenGalleryPictures", new BigDecimal("1"));
        }
    };
    private SakaiProxy sakaiProxy;
    private ProfileLogic profileLogic;
    private ProfileKudosLogic kudosLogic;
    private ProfileImageLogic imageLogic;
    private ProfileConnectionsLogic connectionsLogic;
    private ProfileMessagingLogic messagingLogic;
    private ProfileStatusLogic statusLogic;
    private ProfileExternalIntegrationLogic externalIntegrationLogic;
    private SessionManager sessionManager;

    private BigDecimal getScore(Person person) {
        ExternalIntegrationInfo externalIntegrationInfo;
        int numStatusUpdates;
        int numSentMessages;
        int numConnections;
        ProfileImage image;
        ProfilePrivacy privacy;
        BigDecimal score = new BigDecimal(0);
        UserProfile profile = person.getProfile();
        if (profile != null) {
            if (this.nb(profile.getNickname())) {
                score = score.add(this.val("nickname"));
            }
            if (this.nb(profile.getBirthday())) {
                score = score.add(this.val("birthday"));
            }
            if (this.nb(profile.getEmail())) {
                score = score.add(this.val("email"));
            }
            if (this.nb(profile.getHomepage())) {
                score = score.add(this.val("homePage"));
            }
            if (this.nb(profile.getWorkphone())) {
                score = score.add(this.val("workPhone"));
            }
            if (this.nb(profile.getHomephone())) {
                score = score.add(this.val("homePhone"));
            }
            if (this.nb(profile.getMobilephone())) {
                score = score.add(this.val("mobilePhone"));
            }
            if (this.nb(profile.getPosition())) {
                score = score.add(this.val("position"));
            }
            if (this.nb(profile.getDepartment())) {
                score = score.add(this.val("department"));
            }
            if (this.nb(profile.getSchool())) {
                score = score.add(this.val("school"));
            }
            if (this.nb(profile.getRoom())) {
                score = score.add(this.val("room"));
            }
            if (this.nb(profile.getCourse())) {
                score = score.add(this.val("course"));
            }
            if (this.nb(profile.getSubjects())) {
                score = score.add(this.val("subjects"));
            }
            if (this.nb(profile.getFavouriteBooks())) {
                score = score.add(this.val("favouriteBooks"));
            }
            if (this.nb(profile.getFavouriteTvShows())) {
                score = score.add(this.val("favouriteTvShows"));
            }
            if (this.nb(profile.getFavouriteMovies())) {
                score = score.add(this.val("favouriteMovies"));
            }
            if (this.nb(profile.getFavouriteQuotes())) {
                score = score.add(this.val("favouriteQuotes"));
            }
            if (this.nb(profile.getPersonalSummary())) {
                score = score.add(this.val("personalSummary"));
            }
        }
        if ((privacy = person.getPrivacy()) != null) {
            switch (privacy.getProfileImage()) {
                case 1: {
                    score = score.add(this.val("profileImageShared"));
                    break;
                }
                case 0: {
                    score = score.add(this.val("profileImageShared"));
                    score = score.add(this.val("profileImageBonus"));
                }
            }
            switch (privacy.getBasicInfo()) {
                case 1: {
                    score = score.add(this.val("basicInfoShared"));
                    break;
                }
                case 0: {
                    score = score.add(this.val("basicInfoShared"));
                    score = score.add(this.val("basicInfoBonus"));
                }
            }
            switch (privacy.getContactInfo()) {
                case 1: {
                    score = score.add(this.val("contactInfoShared"));
                    break;
                }
                case 0: {
                    score = score.add(this.val("contactInfoShared"));
                    score = score.add(this.val("contactInfoBonus"));
                }
            }
            switch (privacy.getPersonalInfo()) {
                case 1: {
                    score = score.add(this.val("personalInfoShared"));
                    break;
                }
                case 0: {
                    score = score.add(this.val("personalInfoShared"));
                    score = score.add(this.val("personalInfoBonus"));
                }
            }
            switch (privacy.getStaffInfo()) {
                case 1: {
                    score = score.add(this.val("staffInfoShared"));
                    break;
                }
                case 0: {
                    score = score.add(this.val("staffInfoShared"));
                    score = score.add(this.val("staffInfoBonus"));
                }
            }
            switch (privacy.getStudentInfo()) {
                case 1: {
                    score = score.add(this.val("studentInfoShared"));
                    break;
                }
                case 0: {
                    score = score.add(this.val("studentInfoShared"));
                    score = score.add(this.val("studentInfoBonus"));
                }
            }
            switch (privacy.getMyFriends()) {
                case 1: {
                    score = score.add(this.val("viewConnectionsShared"));
                    break;
                }
                case 0: {
                    score = score.add(this.val("viewConnectionsShared"));
                    score = score.add(this.val("viewConnectionsBonus"));
                }
            }
            switch (privacy.getMyStatus()) {
                case 1: {
                    score = score.add(this.val("viewStatusShared"));
                    break;
                }
                case 0: {
                    score = score.add(this.val("viewStatusShared"));
                    score = score.add(this.val("viewStatusBonus"));
                }
            }
            if (this.sakaiProxy.isProfileGalleryEnabledGlobally()) {
                switch (privacy.getMyPictures()) {
                    case 1: {
                        score = score.add(this.val("viewPicturesShared"));
                        break;
                    }
                    case 0: {
                        score = score.add(this.val("viewPicturesShared"));
                        score = score.add(this.val("viewPicturesBonus"));
                    }
                }
            } else {
                score = score.add(this.val("viewPicturesShared"));
                score = score.add(this.val("viewPicturesBonus"));
            }
            if (privacy.isShowBirthYear()) {
                score = score.add(this.val("showBirthYear"));
            }
        }
        if ((image = this.imageLogic.getProfileImage(person, 1)) != null) {
            if (image.getBinary() != null) {
                score = score.add(this.val("hasImage"));
            }
            if (!StringUtils.equals((String)image.getUrl(), (String)this.imageLogic.getUnavailableImageURL())) {
                score = score.add(this.val("hasImage"));
            }
        }
        if ((numConnections = this.connectionsLogic.getConnectionsForUserCount(person.getUuid())) >= 1) {
            score = score.add(this.val("hasOneConnection"));
        }
        if (numConnections > 10) {
            score = score.add(this.val("hasMoreThanTenConnections"));
        }
        if ((numSentMessages = this.messagingLogic.getSentMessagesCount(person.getUuid())) >= 1) {
            score = score.add(this.val("hasOneSentMessage"));
        }
        if (numSentMessages > 10) {
            score = score.add(this.val("hasMoreThanTenSentMessages"));
        }
        if ((numStatusUpdates = this.statusLogic.getStatusUpdatesCount(person.getUuid())) >= 1) {
            score = score.add(this.val("hasOneStatusUpdate"));
        }
        if ((externalIntegrationInfo = this.externalIntegrationLogic.getExternalIntegrationInfo(person.getUuid())) != null && externalIntegrationInfo.isTwitterAlreadyConfigured()) {
            score = score.add(this.val("twitterEnabled"));
        }
        if (this.sakaiProxy.isProfileGalleryEnabledGlobally()) {
            int numGalleryPictures = this.imageLogic.getGalleryImagesCount(person.getUuid());
            if (numGalleryPictures >= 1) {
                score = score.add(this.val("hasOneGalleryPicture"));
            }
            if (numGalleryPictures > 10) {
                score = score.add(this.val("hasMoreThanTenGalleryPictures"));
            }
        }
        return score;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            if (this.isJobCurrentlyRunning(context)) {
                String beanId = context.getJobDetail().getJobDataMap().getString("org.sakaiproject.profile2.job.KudosJob");
                log.warn("Another instance of " + beanId + " is currently running - Execution aborted.");
                return;
            }
        }
        catch (SchedulerException e) {
            log.error("Aborting job execution due to " + e.toString(), (Throwable)e);
            return;
        }
        log.info("KudosJob run");
        Session session = this.sessionManager.startSession();
        this.sessionManager.setCurrentSession(session);
        session.setUserEid("admin");
        session.setUserId("admin");
        BigDecimal total = this.getTotal();
        log.info("Total score possible: " + total.setScale(2, RoundingMode.HALF_UP));
        List profileUuids = this.profileLogic.getAllSakaiPersonIds();
        for (String userUuid : profileUuids) {
            Person person = this.profileLogic.getPerson(userUuid);
            if (person == null) continue;
            log.info("Processing user: " + userUuid + " (" + person.getDisplayName() + ")");
            BigDecimal score = this.getScore(person);
            BigDecimal percentage = this.getScoreAsPercentage(score, total);
            int adjustedScore = KudosJob.getScoreOutOfTen(score, total);
            if (!this.kudosLogic.updateKudos(userUuid, adjustedScore, percentage)) continue;
            log.info("Kudos updated for user: " + userUuid + ", score: " + score.setScale(2, RoundingMode.HALF_UP) + ", percentage: " + percentage + ", adjustedScore: " + adjustedScore);
        }
        session.setUserId(null);
        session.setUserEid(null);
        log.info("KudosJob finished");
    }

    private boolean isJobCurrentlyRunning(JobExecutionContext context) throws SchedulerException {
        String beanId = context.getJobDetail().getJobDataMap().getString("org.sakaiproject.profile2.job.KudosJob");
        List jobsRunning = context.getScheduler().getCurrentlyExecutingJobs();
        int jobsCount = 0;
        for (JobExecutionContext j : jobsRunning) {
            if (!StringUtils.equals((String)beanId, (String)j.getJobDetail().getJobDataMap().getString("org.sakaiproject.profile2.job.KudosJob"))) continue;
            ++jobsCount;
        }
        return jobsCount > 1;
    }

    private boolean nb(String s1) {
        return StringUtils.isNotBlank((String)s1);
    }

    private BigDecimal val(String key) {
        return this.RULES.get(key);
    }

    private BigDecimal getTotal() {
        BigDecimal total = new BigDecimal("0");
        if (this.RULES != null) {
            for (Map.Entry<String, BigDecimal> entry : this.RULES.entrySet()) {
                total = total.add(entry.getValue());
            }
        }
        return total;
    }

    private BigDecimal getScoreAsPercentage(BigDecimal score, BigDecimal total) {
        return score.divide(total, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).stripTrailingZeros();
    }

    private static int getScoreOutOfTen(BigDecimal score, BigDecimal total) {
        return score.divide(total, 1, RoundingMode.HALF_UP).multiply(new BigDecimal("10")).intValue();
    }

    public void init() {
        log.info("KudosJob.init()");
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setProfileLogic(ProfileLogic profileLogic) {
        this.profileLogic = profileLogic;
    }

    public void setKudosLogic(ProfileKudosLogic kudosLogic) {
        this.kudosLogic = kudosLogic;
    }

    public void setImageLogic(ProfileImageLogic imageLogic) {
        this.imageLogic = imageLogic;
    }

    public void setConnectionsLogic(ProfileConnectionsLogic connectionsLogic) {
        this.connectionsLogic = connectionsLogic;
    }

    public void setMessagingLogic(ProfileMessagingLogic messagingLogic) {
        this.messagingLogic = messagingLogic;
    }

    public void setStatusLogic(ProfileStatusLogic statusLogic) {
        this.statusLogic = statusLogic;
    }

    public void setExternalIntegrationLogic(ProfileExternalIntegrationLogic externalIntegrationLogic) {
        this.externalIntegrationLogic = externalIntegrationLogic;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }
}

