/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.logic;

import java.math.BigDecimal;
import java.util.Date;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.profile2.cache.CacheManager;
import org.sakaiproject.profile2.dao.ProfileDao;
import org.sakaiproject.profile2.hbm.model.ProfileKudos;
import org.sakaiproject.profile2.logic.ProfileKudosLogic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileKudosLogicImpl
implements ProfileKudosLogic {
    private static final Logger log = LoggerFactory.getLogger(ProfileKudosLogicImpl.class);
    private Cache cache;
    private final String CACHE_NAME = "org.sakaiproject.profile2.cache.kudos";
    private ProfileDao dao;
    private CacheManager cacheManager;

    public int getKudos(String userUuid) {
        ProfileKudos k = null;
        if (this.cache.containsKey((Object)userUuid)) {
            log.debug("Fetching kudos from cache for: " + userUuid);
            k = (ProfileKudos)this.cache.get((Object)userUuid);
            if (k == null) {
                log.debug("Kudos cache appears to have expired for " + userUuid);
                this.cacheManager.evictFromCache(this.cache, userUuid);
            }
        }
        if (k == null && (k = this.dao.getKudos(userUuid)) != null) {
            log.debug("Adding kudos to cache for: " + userUuid);
            this.cache.put((Object)userUuid, (Object)k);
        }
        if (k == null) {
            return 0;
        }
        return k.getScore();
    }

    public BigDecimal getRawKudos(String userUuid) {
        ProfileKudos k = this.dao.getKudos(userUuid);
        if (k == null) {
            return null;
        }
        return k.getPercentage();
    }

    public boolean updateKudos(String userUuid, int score, BigDecimal percentage) {
        ProfileKudos k = new ProfileKudos();
        k.setUserUuid(userUuid);
        k.setScore(score);
        k.setPercentage(percentage);
        k.setDateAdded(new Date());
        if (this.dao.updateKudos(k)) {
            log.debug("Adding kudos to cache for: " + userUuid);
            this.cache.put((Object)userUuid, (Object)k);
            return true;
        }
        return false;
    }

    public void init() {
        this.cache = this.cacheManager.createCache("org.sakaiproject.profile2.cache.kudos");
    }

    public void setDao(ProfileDao dao) {
        this.dao = dao;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }
}

