/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.components;

import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.Resource;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.image.resource.LocalizedImageResource;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.model.ProfileImage;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.tool.components.ProfileImageRenderer;

public class ProfileImageRenderer
extends Image
implements IResourceListener {
    private static final long serialVersionUID = 1L;
    private String userUuid;
    private boolean cache;
    private int size;
    private ProfilePreferences prefs;
    private ProfilePrivacy privacy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileImageLogic")
    private ProfileImageLogic imageLogic;
    private final LocalizedImageResource localizedImageResource = new LocalizedImageResource((Component)this);

    public ProfileImageRenderer(String id, String userUuid) {
        super(id);
        this.userUuid = userUuid;
        this.prefs = null;
        this.privacy = null;
        this.size = this.getDefaultSize();
        this.cache = this.getDefaultCache();
    }

    public ProfileImageRenderer(String id, String userUuid, ProfilePreferences prefs) {
        super(id);
        this.userUuid = userUuid;
        this.prefs = prefs;
        this.privacy = null;
        this.size = this.getDefaultSize();
        this.cache = this.getDefaultCache();
    }

    public ProfileImageRenderer(String id, String userUuid, ProfilePreferences prefs, int size, boolean cache) {
        super(id);
        this.userUuid = userUuid;
        this.prefs = prefs;
        this.size = size;
        this.cache = cache;
        this.privacy = null;
    }

    public ProfileImageRenderer(String id, String userUuid, ProfilePreferences prefs, ProfilePrivacy privacy) {
        super(id);
        this.userUuid = userUuid;
        this.privacy = privacy;
        this.prefs = prefs;
        this.size = this.getDefaultSize();
        this.cache = this.getDefaultCache();
    }

    public ProfileImageRenderer(String id, String userUuid, ProfilePreferences prefs, ProfilePrivacy privacy, int size, boolean cache) {
        super(id);
        this.userUuid = userUuid;
        this.privacy = privacy;
        this.prefs = prefs;
        this.size = size;
        this.cache = cache;
    }

    public ProfileImageRenderer(String id, Person person) {
        super(id);
        this.userUuid = person.getUuid();
        this.prefs = person.getPreferences();
        this.privacy = person.getPrivacy();
        this.size = this.getDefaultSize();
        this.cache = this.getDefaultCache();
    }

    public ProfileImageRenderer(String id, Person person, int size, boolean cache) {
        super(id);
        this.userUuid = person.getUuid();
        this.prefs = person.getPreferences();
        this.privacy = person.getPrivacy();
        this.size = size;
        this.cache = cache;
    }

    public void onResourceRequested() {
        this.localizedImageResource.onResourceRequested();
    }

    public void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        ProfileImage image = this.imageLogic.getProfileImage(this.userUuid, this.prefs, this.privacy, this.size);
        byte[] bytes = image.getBinary();
        if (bytes != null && bytes.length > 0) {
            1 photoResource = new /* Unavailable Anonymous Inner Class!! */;
            this.localizedImageResource.setResource((Resource)photoResource);
            this.localizedImageResource.setSrcAttribute(tag);
            if (!this.cache) {
                this.addNoCacheNoise(tag);
            }
            tag.put("alt", (CharSequence)image.getAltText());
            return;
        }
        String url = image.getUrl();
        if (StringUtils.isNotBlank((String)url)) {
            tag.put("src", (CharSequence)url);
            tag.put("alt", (CharSequence)image.getAltText());
            return;
        }
        tag.put("src", (CharSequence)this.getDefaultImage(this.size));
        tag.put("alt", (CharSequence)image.getAltText());
    }

    private String getDefaultImage(int size) {
        if (2 == size) {
            return this.getRequest().getRelativePathPrefixToContextRoot() + "/profile2-tool/images/no_image_thumbnail.gif";
        }
        return this.getRequest().getRelativePathPrefixToContextRoot() + "images/no_image.gif";
    }

    private int getDefaultSize() {
        return 1;
    }

    private boolean getDefaultCache() {
        return true;
    }

    private void addNoCacheNoise(ComponentTag tag) {
        StringBuilder url = new StringBuilder();
        String tagSrc = tag.getAttributes().getString("src");
        url.append(tagSrc);
        url.append(tagSrc.indexOf(63) >= 0 ? "&" : "?");
        url.append("wicket:antiCache=" + System.currentTimeMillis());
        tag.put("src", (CharSequence)url);
    }
}

