/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.CompanyProfile;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.pages.panels.MyBusinessDisplay;
import org.sakaiproject.profile2.tool.pages.panels.MyInfoDisplay;
import org.sakaiproject.profile2.util.ProfileUtils;

public class MyBusinessDisplay
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyInfoDisplay.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;

    public MyBusinessDisplay(String id, UserProfile userProfile) {
        super(id);
        log.debug((Object)"MyBusinessDisplay()");
        this.setDefaultModel((IModel)new Model((Serializable)((Object)"businessDisplayModel")));
        int visibleFieldCount = 0;
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.business"))});
        visibleFieldCount = this.addBusinessBiography(userProfile, visibleFieldCount);
        visibleFieldCount = this.addCompanyProfiles(userProfile, visibleFieldCount);
        this.addEditButton(id, userProfile);
        Label noFieldsMessage = new Label("noFieldsMessage", (IModel)new ResourceModel("text.no.fields"));
        this.add(new Component[]{noFieldsMessage});
        if (visibleFieldCount > 0) {
            noFieldsMessage.setVisible(false);
        }
    }

    private int addBusinessBiography(UserProfile userProfile, int visibleFieldCount) {
        WebMarkupContainer businessBiographyContainer = new WebMarkupContainer("businessBiographyContainer");
        businessBiographyContainer.add(new Component[]{new Label("businessBiographyLabel", (IModel)new ResourceModel("profile.business.bio"))});
        businessBiographyContainer.add(new Component[]{new Label("businessBiography", ProfileUtils.processHtml((String)userProfile.getBusinessBiography())).setEscapeModelStrings(false)});
        this.add(new Component[]{businessBiographyContainer});
        if (StringUtils.isBlank((String)userProfile.getBusinessBiography())) {
            businessBiographyContainer.setVisible(false);
        } else {
            ++visibleFieldCount;
        }
        return visibleFieldCount;
    }

    private int addCompanyProfiles(UserProfile userProfile, int visibleFieldCount) {
        WebMarkupContainer companyProfilesContainer = new WebMarkupContainer("companyProfilesContainer");
        companyProfilesContainer.add(new Component[]{new Label("companyProfilesLabel", (IModel)new ResourceModel("profile.business.company.profiles"))});
        ArrayList<1> tabs = new ArrayList<1>();
        if (null != userProfile.getCompanyProfiles()) {
            for (CompanyProfile companyProfile : userProfile.getCompanyProfiles()) {
                tabs.add(new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        companyProfilesContainer.add(new Component[]{new AjaxTabbedPanel("companyProfiles", tabs)});
        this.add(new Component[]{companyProfilesContainer});
        if (0 == tabs.size()) {
            companyProfilesContainer.setVisible(false);
        } else {
            ++visibleFieldCount;
        }
        return visibleFieldCount;
    }

    private void addEditButton(String id, UserProfile userProfile) {
        2 editButton = new /* Unavailable Anonymous Inner Class!! */;
        editButton.add(new Component[]{new Label("editButtonLabel", (IModel)new ResourceModel("button.edit"))});
        editButton.setOutputMarkupId(true);
        if (userProfile.isLocked() && !this.sakaiProxy.isSuperUser()) {
            editButton.setVisible(false);
        }
        this.add(new Component[]{editButton});
    }
}

