/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.components.IconWithClueTip;
import org.sakaiproject.profile2.tool.components.TextareaTinyMceSettings;
import org.sakaiproject.profile2.tool.pages.panels.MyInfoEdit;
import org.sakaiproject.profile2.util.ProfileUtils;
import wicket.contrib.tinymce.TinyMceBehavior;
import wicket.contrib.tinymce.ajax.TinyMceAjaxSubmitModifier;
import wicket.contrib.tinymce.settings.TinyMCESettings;

public class MyInfoEdit
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyInfoEdit.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    private ProfileLogic profileLogic;

    public MyInfoEdit(String id, UserProfile userProfile) {
        super(id);
        log.debug((Object)"MyInfoEdit()");
        MyInfoEdit thisPanel = this;
        String userId = userProfile.getUserUuid();
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.basic.edit"))});
        Form form = new Form("form", (IModel)new Model((Serializable)userProfile));
        form.setOutputMarkupId(true);
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        Label editWarning = new Label("editWarning");
        editWarning.setVisible(false);
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userId)) {
            editWarning.setDefaultModel((IModel)new StringResourceModel("text.edit.other.warning", null, new Object[]{userProfile.getDisplayName()}));
            editWarning.setEscapeModelStrings(false);
            editWarning.setVisible(true);
        }
        form.add(new Component[]{editWarning});
        WebMarkupContainer nicknameContainer = new WebMarkupContainer("nicknameContainer");
        nicknameContainer.add(new Component[]{new Label("nicknameLabel", (IModel)new ResourceModel("profile.nickname"))});
        TextField nickname = new TextField("nickname", (IModel)new PropertyModel((Object)userProfile, "nickname"));
        nicknameContainer.add(new Component[]{nickname});
        form.add(new Component[]{nicknameContainer});
        WebMarkupContainer birthdayContainer = new WebMarkupContainer("birthdayContainer");
        birthdayContainer.add(new Component[]{new Label("birthdayLabel", (IModel)new ResourceModel("profile.birthday"))});
        TextField birthday = new TextField("birthday", (IModel)new PropertyModel((Object)userProfile, "birthday"));
        birthdayContainer.add(new Component[]{birthday});
        birthdayContainer.add(new Component[]{new IconWithClueTip("birthdayToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.profile.birthyear.tooltip"))});
        form.add(new Component[]{birthdayContainer});
        WebMarkupContainer personalSummaryContainer = new WebMarkupContainer("personalSummaryContainer");
        personalSummaryContainer.add(new Component[]{new Label("personalSummaryLabel", (IModel)new ResourceModel("profile.summary"))});
        TextArea personalSummary = new TextArea("personalSummary", (IModel)new PropertyModel((Object)userProfile, "personalSummary"));
        personalSummary.add(new IBehavior[]{new TinyMceBehavior((TinyMCESettings)new TextareaTinyMceSettings())});
        personalSummaryContainer.add(new Component[]{personalSummary});
        form.add(new Component[]{personalSummaryContainer});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.setModel((IModel)new ResourceModel("button.save.changes"));
        submitButton.add(new IBehavior[]{new TinyMceAjaxSubmitModifier()});
        form.add(new Component[]{submitButton});
        2 cancelButton = new /* Unavailable Anonymous Inner Class!! */;
        cancelButton.setDefaultFormProcessing(false);
        form.add(new Component[]{cancelButton});
        this.add(new Component[]{form});
    }

    private boolean save(Form form) {
        UserProfile userProfile = (UserProfile)form.getModelObject();
        String userId = userProfile.getUserUuid();
        SakaiPerson sakaiPerson = this.sakaiProxy.getSakaiPerson(userId);
        String tNickname = ProfileUtils.truncate((String)userProfile.getNickname(), (int)255, (boolean)false);
        userProfile.setNickname(tNickname);
        sakaiPerson.setNickname(tNickname);
        if (StringUtils.isNotBlank((String)userProfile.getBirthday())) {
            Date convertedDate = ProfileUtils.convertStringToDate((String)userProfile.getBirthday(), (String)"dd MMMM yyyy");
            userProfile.setDateOfBirth(convertedDate);
            sakaiPerson.setDateOfBirth(convertedDate);
        } else {
            userProfile.setDateOfBirth(null);
            sakaiPerson.setDateOfBirth(null);
        }
        sakaiPerson.setNotes(userProfile.getPersonalSummary());
        if (this.profileLogic.saveUserProfile(sakaiPerson)) {
            log.info((Object)("Saved SakaiPerson for: " + userId));
            return true;
        }
        log.info((Object)("Couldn't save SakaiPerson for: " + userId));
        return false;
    }

    static /* synthetic */ boolean access$000(MyInfoEdit x0, Form x1) {
        return x0.save(x1);
    }

    static /* synthetic */ SakaiProxy access$100(MyInfoEdit x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$200(MyInfoEdit x0) {
        return x0.wallLogic;
    }
}

