/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.dataproviders;

import java.util.Iterator;
import org.apache.wicket.injection.web.InjectorHolder;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.model.GalleryImage;
import org.sakaiproject.profile2.tool.models.DetachableGalleryImageModel;

public class GalleryImageDataProvider
implements IDataProvider<GalleryImage> {
    private static final long serialVersionUID = 1L;
    protected String userUuid;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileImageLogic")
    protected ProfileImageLogic imageLogic;

    public GalleryImageDataProvider(String userUuid) {
        InjectorHolder.getInjector().inject((Object)this);
        this.userUuid = userUuid;
    }

    public Iterator<GalleryImage> iterator(int first, int count) {
        return this.imageLogic.getGalleryImages(this.userUuid).subList(first, first + count).iterator();
    }

    public IModel<GalleryImage> model(GalleryImage object) {
        return new DetachableGalleryImageModel(object);
    }

    public int size() {
        return this.imageLogic.getGalleryImagesCount(this.userUuid);
    }

    public void detach() {
    }
}

