/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages;

import java.io.Serializable;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import org.apache.log4j.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.tool.components.OnlinePresenceIndicator;
import org.sakaiproject.profile2.tool.components.ProfileImageRenderer;
import org.sakaiproject.profile2.tool.components.ProfileStatusRenderer;
import org.sakaiproject.profile2.tool.models.FriendAction;
import org.sakaiproject.profile2.tool.pages.BasePage;
import org.sakaiproject.profile2.tool.pages.MyProfile;
import org.sakaiproject.profile2.tool.pages.ViewProfile;
import org.sakaiproject.profile2.tool.pages.windows.AddFriend;
import org.sakaiproject.profile2.types.PrivacyType;
import org.sakaiproject.user.api.User;

public class ViewProfile
extends BasePage {
    private static final Logger log = Logger.getLogger(ViewProfile.class);

    public ViewProfile(String userUuid, String tab) {
        log.debug((Object)"ViewProfile()");
        FriendAction friendActionModel = new FriendAction();
        User currentUser = this.sakaiProxy.getUserQuietly(this.sakaiProxy.getCurrentUserId());
        String currentUserId = currentUser.getId();
        String currentUserType = currentUser.getType();
        if (userUuid.equals(currentUserId)) {
            log.warn((Object)("ViewProfile: user " + userUuid + " accessed ViewProfile for self. Redirecting..."));
            throw new RestartResponseException((Page)new MyProfile());
        }
        if (this.sakaiProxy.isSuperUser()) {
            log.warn((Object)("ViewProfile: superUser " + currentUserId + " accessed ViewProfile for " + userUuid + ". Redirecting to allow edit."));
            throw new RestartResponseException((Page)new MyProfile(userUuid));
        }
        this.sakaiProxy.postEvent("profile.view.other", "/profile/" + userUuid, false);
        User user = this.sakaiProxy.getUserQuietly(userUuid);
        String userDisplayName = user.getDisplayName();
        String userType = user.getType();
        boolean friendRequestToThisPerson = false;
        boolean friendRequestFromThisPerson = false;
        boolean friend = this.connectionsLogic.isUserXFriendOfUserY(userUuid, currentUserId);
        if (!friend) {
            friendRequestToThisPerson = this.connectionsLogic.isFriendRequestPending(currentUserId, userUuid);
        }
        if (!friend && !friendRequestToThisPerson) {
            friendRequestFromThisPerson = this.connectionsLogic.isFriendRequestPending(userUuid, currentUserId);
        }
        ProfilePrivacy privacy = this.privacyLogic.getPrivacyRecordForUser(userUuid);
        boolean isFriendsListVisible = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_MYFRIENDS);
        boolean isKudosVisible = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_MYKUDOS);
        boolean isGalleryVisible = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_MYPICTURES);
        boolean isConnectionAllowed = this.sakaiProxy.isConnectionAllowedBetweenUserTypes(currentUserType, userType);
        boolean isOnlineStatusVisible = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_ONLINESTATUS);
        ProfilePreferences prefs = this.preferencesLogic.getPreferencesRecordForUser(userUuid);
        this.add(new Component[]{new ProfileImageRenderer("photo", userUuid, prefs, privacy, 1, true)});
        Label profileName = new Label("profileName", userDisplayName);
        this.add(new Component[]{profileName});
        if (prefs.isShowOnlineStatus() && isOnlineStatusVisible) {
            this.add(new Component[]{new OnlinePresenceIndicator("online", userUuid)});
        } else {
            this.add(new Component[]{new EmptyPanel("online")});
        }
        ProfileStatusRenderer status = new ProfileStatusRenderer("status", userUuid, privacy, null, "tiny");
        status.setOutputMarkupId(true);
        this.add(new Component[]{status});
        ArrayList<Object> tabs = new ArrayList<Object>();
        1 tabbedPanel = new /* Unavailable Anonymous Inner Class!! */;
        Cookie tabCookie = this.getWebRequestCycle().getWebRequest().getCookie("profile2-tab");
        tabs.add(new /* Unavailable Anonymous Inner Class!! */);
        if (this.sakaiProxy.isWallEnabledGlobally()) {
            tabs.add(new /* Unavailable Anonymous Inner Class!! */);
            if (this.sakaiProxy.isWallDefaultProfilePage() && null == tabCookie) {
                tabbedPanel.setSelectedTab(1);
            }
        }
        if (null != tab) {
            tabbedPanel.setSelectedTab(Integer.parseInt(tab));
        } else if (null != tabCookie) {
            tabbedPanel.setSelectedTab(Integer.parseInt(tabCookie.getValue()));
        }
        this.add(new Component[]{tabbedPanel});
        WebMarkupContainer sideLinks = new WebMarkupContainer("sideLinks");
        int visibleSideLinksCount = 0;
        WebMarkupContainer addFriendContainer = new WebMarkupContainer("addFriendContainer");
        ModalWindow addFriendWindow = new ModalWindow("addFriendWindow");
        4 addFriendLink = new /* Unavailable Anonymous Inner Class!! */;
        Label addFriendLabel = new Label("addFriendLabel");
        addFriendLink.add(new Component[]{addFriendLabel});
        addFriendContainer.add(new Component[]{addFriendLink});
        if (friend) {
            addFriendLabel.setDefaultModel((IModel)new ResourceModel("text.friend.confirmed"));
            addFriendLink.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"instruction icon connection-confirmed")))});
            addFriendLink.setEnabled(false);
        } else if (friendRequestToThisPerson) {
            addFriendLabel.setDefaultModel((IModel)new ResourceModel("text.friend.requested"));
            addFriendLink.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"instruction icon connection-request")))});
            addFriendLink.setEnabled(false);
        } else if (friendRequestFromThisPerson) {
            addFriendLabel.setDefaultModel((IModel)new ResourceModel("text.friend.pending"));
            addFriendLink.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"instruction icon connection-request")))});
            addFriendLink.setEnabled(false);
        } else {
            addFriendLabel.setDefaultModel((IModel)new StringResourceModel("link.friend.add.name", null, new Object[]{user.getFirstName()}));
            addFriendWindow.setContent((Component)new AddFriend(addFriendWindow.getContentId(), addFriendWindow, friendActionModel, currentUserId, userUuid));
        }
        sideLinks.add(new Component[]{addFriendContainer});
        addFriendWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.add(new Component[]{addFriendWindow});
        if (!isConnectionAllowed) {
            addFriendContainer.setVisible(false);
        } else {
            ++visibleSideLinksCount;
        }
        if (visibleSideLinksCount == 0) {
            sideLinks.setVisible(false);
        }
        this.add(new Component[]{sideLinks});
        if (isKudosVisible) {
            this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        } else {
            this.add(new Component[]{new EmptyPanel("myKudos").setVisible(false)});
        }
        if (isFriendsListVisible) {
            this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        } else {
            this.add(new Component[]{new EmptyPanel("friendsFeed").setVisible(false)});
        }
        if (this.sakaiProxy.isProfileGalleryEnabledGlobally() && isGalleryVisible && prefs.isShowGalleryFeed()) {
            this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        } else {
            this.add(new Component[]{new EmptyPanel("galleryFeed").setVisible(false)});
        }
    }

    public ViewProfile(PageParameters parameters) {
        this(parameters.getString("id"), parameters.getString("tab"));
    }

    public ViewProfile(String userUuid) {
        this(userUuid, null);
    }
}

