/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileWorksiteLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.tool.components.ErrorLevelsFeedbackMessageFilter;
import org.sakaiproject.profile2.tool.components.IconWithClueTip;
import org.sakaiproject.profile2.tool.pages.panels.CreateWorksitePanel;

public class CreateWorksitePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWorksiteLogic")
    private ProfileWorksiteLogic worksiteLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;

    public CreateWorksitePanel(String id, List<Person> persons) {
        super(id);
        Collections.sort(persons);
        Form form = new Form("form");
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        FeedbackPanel feedback = new FeedbackPanel("feedback");
        feedback.setOutputMarkupId(true);
        form.add(new Component[]{feedback});
        int[] filteredErrorLevels = new int[]{400};
        feedback.setFilter((IFeedbackMessageFilter)new ErrorLevelsFeedbackMessageFilter(filteredErrorLevels));
        ChoiceRenderer renderer = new ChoiceRenderer("displayName", "uuid");
        Palette palette = new Palette("palette", (IModel)new ListModel(new ArrayList()), (IModel)new CollectionModel(persons), (IChoiceRenderer)renderer, 10, true);
        palette.setOutputMarkupId(true);
        form.add(new Component[]{palette});
        Label siteNameLabel = new Label("siteNameLabel", (IModel)new ResourceModel("worksite.name"));
        form.add(new Component[]{siteNameLabel});
        TextField siteNameField = new TextField("siteNameField", (IModel)new Model());
        siteNameField.setOutputMarkupId(true);
        form.add(new Component[]{siteNameField});
        1 cancelButton = new /* Unavailable Anonymous Inner Class!! */;
        cancelButton.setModel((IModel)new ResourceModel("button.worksite.cancel"));
        form.add(new Component[]{cancelButton});
        2 createButton = new /* Unavailable Anonymous Inner Class!! */;
        createButton.setModel((IModel)new ResourceModel("button.worksite.create"));
        form.add(new Component[]{createButton});
        form.add(new Component[]{new IconWithClueTip("createWorksiteToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.worksite.create"))});
        Label refreshLabel = new Label("refreshLabel", (IModel)new ResourceModel("text.worksite.refresh"));
        form.add(new Component[]{refreshLabel});
    }

    private void resetPanel(AjaxRequestTarget target, TextField<String> siteNameField, Palette<Person> palette, Label formFeedback) {
        siteNameField.setModelObject((Object)"");
        ArrayList<Person> remove = new ArrayList<Person>();
        for (Person person : palette.getModelCollection()) {
            remove.add(person);
        }
        palette.getModelCollection().removeAll(remove);
        formFeedback.setVisible(false);
        target.addComponent(siteNameField);
        target.appendJavascript("$('#" + this.getMarkupId() + "').slideUp();");
        target.appendJavascript("fixWindowVertical();");
    }

    static /* synthetic */ void access$000(CreateWorksitePanel x0, AjaxRequestTarget x1, TextField x2, Palette x3, Label x4) {
        x0.resetPanel(x1, x2, x3, x4);
    }

    static /* synthetic */ SakaiProxy access$100(CreateWorksitePanel x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWorksiteLogic access$200(CreateWorksitePanel x0) {
        return x0.worksiteLogic;
    }
}

