/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.tool.dataproviders.FriendsFeedDataProvider;
import org.sakaiproject.profile2.tool.pages.panels.FriendsFeed;

public class FriendsFeed
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(FriendsFeed.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileConnectionsLogic")
    protected ProfileConnectionsLogic connectionsLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePreferencesLogic")
    protected ProfilePreferencesLogic preferencesLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePrivacyLogic")
    protected ProfilePrivacyLogic privacyLogic;

    public FriendsFeed(String id, String ownerUserId, String viewingUserId) {
        super(id);
        log.debug((Object)"FriendsFeed()");
        Label heading = new Label("heading");
        if (viewingUserId.equals(ownerUserId)) {
            heading.setDefaultModel((IModel)new ResourceModel("heading.widget.my.friends"));
        } else {
            String displayName = this.sakaiProxy.getUserDisplayName(ownerUserId);
            heading.setDefaultModel((IModel)new StringResourceModel("heading.widget.view.friends", null, new Object[]{displayName}));
        }
        this.add(new Component[]{heading});
        FriendsFeedDataProvider provider = new FriendsFeedDataProvider(ownerUserId);
        1 dataView = new /* Unavailable Anonymous Inner Class!! */;
        dataView.setColumns(3);
        this.add(new Component[]{dataView});
        int numFriends = this.connectionsLogic.getConnectionsForUserCount(ownerUserId);
        Label numFriendsLabel = new Label("numFriendsLabel");
        this.add(new Component[]{numFriendsLabel});
        2 viewFriendsLink = new /* Unavailable Anonymous Inner Class!! */;
        Label viewFriendsLabel = new Label("viewFriendsLabel");
        viewFriendsLink.add(new Component[]{viewFriendsLabel});
        this.add(new Component[]{viewFriendsLink});
        if (numFriends == 0) {
            numFriendsLabel.setDefaultModel((IModel)new ResourceModel("text.friend.feed.num.none"));
            if (viewingUserId.equals(ownerUserId)) {
                viewFriendsLabel.setDefaultModel((IModel)new ResourceModel("link.friend.feed.search"));
            } else {
                viewFriendsLink.setVisible(false);
            }
        } else if (numFriends == 1) {
            numFriendsLabel.setDefaultModel((IModel)new ResourceModel("text.friend.feed.num.one"));
            viewFriendsLink.setVisible(false);
        } else {
            numFriendsLabel.setDefaultModel((IModel)new StringResourceModel("text.friend.feed.num.many", null, new Object[]{numFriends}));
            viewFriendsLabel.setDefaultModel((IModel)new ResourceModel("link.friend.feed.view"));
        }
    }

    static /* synthetic */ SakaiProxy access$000(FriendsFeed x0) {
        return x0.sakaiProxy;
    }
}

