/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.ContextImage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.SakaiProxy;

public class KudosPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(KudosPanel.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;

    public KudosPanel(String id, String ownerUserId, String viewingUserId, int score) {
        super(id);
        log.debug((Object)"KudosPanel()");
        Label heading = new Label("heading");
        if (viewingUserId.equals(ownerUserId)) {
            heading.setDefaultModel((IModel)new ResourceModel("heading.widget.my.kudos"));
        } else {
            String displayName = this.sakaiProxy.getUserDisplayName(ownerUserId);
            heading.setDefaultModel((IModel)new StringResourceModel("heading.widget.view.kudos", null, new Object[]{displayName}));
        }
        this.add(new Component[]{heading});
        this.add(new Component[]{new Label("kudosRating", String.valueOf(score))});
        String img = this.getImage(score);
        this.add(new Component[]{new ContextImage("kudosImgLeft", img)});
        this.add(new Component[]{new ContextImage("kudosImgRight", img)});
    }

    private String getImage(int score) {
        if (score >= 8) {
            return "/library/image/silk/award_star_gold_3.png";
        }
        if (score == 7) {
            return "/library/image/silk/award_star_silver_3.png";
        }
        if (score >= 5) {
            return "/library/image/silk/award_star_bronze_3.png";
        }
        return "/library/image/silk/medal_silver_1.png";
    }
}

