/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.pages.panels.MyInterestsDisplay;

public class MyInterestsDisplay
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyInterestsDisplay.class);
    private int visibleFieldCount = 0;
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;

    public MyInterestsDisplay(String id, UserProfile userProfile) {
        super(id);
        MyInterestsDisplay thisPanel = this;
        String favouriteBooks = userProfile.getFavouriteBooks();
        String favouriteTvShows = userProfile.getFavouriteTvShows();
        String favouriteMovies = userProfile.getFavouriteMovies();
        String favouriteQuotes = userProfile.getFavouriteQuotes();
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.interests"))});
        WebMarkupContainer booksContainer = new WebMarkupContainer("booksContainer");
        booksContainer.add(new Component[]{new Label("booksLabel", (IModel)new ResourceModel("profile.favourite.books"))});
        booksContainer.add(new Component[]{new Label("favouriteBooks", favouriteBooks)});
        this.add(new Component[]{booksContainer});
        if (StringUtils.isBlank((String)favouriteBooks)) {
            booksContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer tvContainer = new WebMarkupContainer("tvContainer");
        tvContainer.add(new Component[]{new Label("tvLabel", (IModel)new ResourceModel("profile.favourite.tv"))});
        tvContainer.add(new Component[]{new Label("favouriteTvShows", favouriteTvShows)});
        this.add(new Component[]{tvContainer});
        if (StringUtils.isBlank((String)favouriteTvShows)) {
            tvContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer moviesContainer = new WebMarkupContainer("moviesContainer");
        moviesContainer.add(new Component[]{new Label("moviesLabel", (IModel)new ResourceModel("profile.favourite.movies"))});
        moviesContainer.add(new Component[]{new Label("favouriteMovies", favouriteMovies)});
        this.add(new Component[]{moviesContainer});
        if (StringUtils.isBlank((String)favouriteMovies)) {
            moviesContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer quotesContainer = new WebMarkupContainer("quotesContainer");
        quotesContainer.add(new Component[]{new Label("quotesLabel", (IModel)new ResourceModel("profile.favourite.quotes"))});
        quotesContainer.add(new Component[]{new Label("favouriteQuotes", favouriteQuotes)});
        this.add(new Component[]{quotesContainer});
        if (StringUtils.isBlank((String)favouriteQuotes)) {
            quotesContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        1 editButton = new /* Unavailable Anonymous Inner Class!! */;
        editButton.add(new Component[]{new Label("editButtonLabel", (IModel)new ResourceModel("button.edit"))});
        editButton.setOutputMarkupId(true);
        if (userProfile.isLocked() && !this.sakaiProxy.isSuperUser()) {
            editButton.setVisible(false);
        }
        this.add(new Component[]{editButton});
        Label noFieldsMessage = new Label("noFieldsMessage", (IModel)new ResourceModel("text.no.fields"));
        this.add(new Component[]{noFieldsMessage});
        if (this.visibleFieldCount > 0) {
            noFieldsMessage.setVisible(false);
        }
    }
}

