/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.ContextImage;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileExternalIntegrationLogic;
import org.sakaiproject.profile2.model.ExternalIntegrationInfo;
import org.sakaiproject.profile2.tool.models.StringModel;
import org.sakaiproject.profile2.tool.pages.panels.TwitterPrefsPane;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.http.AccessToken;
import twitter4j.http.RequestToken;

public class TwitterPrefsPane
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(TwitterPrefsPane.class);
    private transient ExternalIntegrationInfo externalIntegrationInfo;
    private transient RequestToken requestToken;
    private Fragment currentFragment;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileExternalIntegrationLogic")
    protected ProfileExternalIntegrationLogic externalIntegrationLogic;

    public TwitterPrefsPane(String id, String userUuid) {
        super(id);
        this.externalIntegrationInfo = this.externalIntegrationLogic.getExternalIntegrationInfo(userUuid);
        this.setTwitterRequestToken();
        this.currentFragment = this.externalIntegrationInfo.isTwitterAlreadyConfigured() ? this.linkedFragment() : this.unlinkedFragment();
        this.add(new Component[]{this.currentFragment});
    }

    private Fragment unlinkedFragment() {
        Fragment frag = new Fragment("fragmentContainer", "unlinked", (MarkupContainer)this);
        StringModel twitterModel = new StringModel();
        Form twitterForm = new Form("twitterForm", (IModel)new Model((Serializable)twitterModel));
        TextField twitterAuthCode = new TextField("twitterAuthCode", (IModel)new PropertyModel((Object)twitterModel, "string"));
        twitterAuthCode.setOutputMarkupId(true);
        twitterAuthCode.setEnabled(false);
        twitterForm.add(new Component[]{twitterAuthCode});
        1 twitterSubmit = new /* Unavailable Anonymous Inner Class!! */;
        twitterSubmit.setEnabled(false);
        twitterSubmit.setModel((IModel)new ResourceModel("button.link"));
        twitterForm.add(new Component[]{twitterSubmit});
        frag.add(new Component[]{twitterForm});
        2 twitterAuthLink = new /* Unavailable Anonymous Inner Class!! */;
        Label twitterAuthLabel = new Label("twitterAuthLabel", (IModel)new ResourceModel("twitter.auth.do"));
        twitterAuthLink.add(new Component[]{twitterAuthLabel});
        frag.add(new Component[]{twitterAuthLink});
        frag.setOutputMarkupId(true);
        return frag;
    }

    private Fragment linkedFragment() {
        Fragment frag = new Fragment("fragmentContainer", "linked", (MarkupContainer)this);
        frag.add(new Component[]{new Label("twitterAuthLabel", (IModel)new ResourceModel("twitter.auth.linked"))});
        String twitterName = this.externalIntegrationLogic.getTwitterName(this.externalIntegrationInfo);
        Label twitterAuthName = new Label("twitterAuthName", (IModel)new Model((Serializable)((Object)twitterName)));
        if (StringUtils.isBlank((String)twitterName)) {
            twitterAuthName.setDefaultModel((IModel)new ResourceModel("error.twitter.details.invalid"));
        }
        frag.add(new Component[]{twitterAuthName});
        3 twitterAuthRemoveLink = new /* Unavailable Anonymous Inner Class!! */;
        ContextImage twitterAuthRemoveIcon = new ContextImage("twitterAuthRemoveIcon", (IModel)new Model((Serializable)((Object)"/library/image/silk/cross.png")));
        twitterAuthRemoveLink.add(new Component[]{twitterAuthRemoveIcon});
        twitterAuthRemoveLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.title.unlinktwitter"))});
        frag.add(new Component[]{twitterAuthRemoveLink});
        frag.setOutputMarkupId(true);
        return frag;
    }

    private void switchContentFragments(Fragment replacement, AjaxRequestTarget target) {
        replacement.setOutputMarkupId(true);
        this.currentFragment.replaceWith((Component)replacement);
        if (target != null) {
            target.addComponent((Component)replacement);
            target.appendJavascript("setMainFrameHeight(window.name);");
        }
        this.currentFragment = replacement;
    }

    private void setTwitterRequestToken() {
        Map config = this.externalIntegrationLogic.getTwitterOAuthConsumerDetails();
        Twitter twitter = new TwitterFactory().getInstance();
        twitter.setOAuthConsumer((String)config.get("key"), (String)config.get("secret"));
        try {
            this.requestToken = twitter.getOAuthRequestToken();
        }
        catch (TwitterException e) {
            e.printStackTrace();
        }
    }

    private AccessToken getOAuthAccessToken(String accessCode) {
        Map config = this.externalIntegrationLogic.getTwitterOAuthConsumerDetails();
        Twitter twitter = new TwitterFactory().getInstance();
        twitter.setOAuthConsumer((String)config.get("key"), (String)config.get("secret"));
        try {
            return twitter.getOAuthAccessToken(this.requestToken, accessCode);
        }
        catch (TwitterException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getTwitterAuthorisationUrl() {
        if (this.requestToken == null) {
            return null;
        }
        return this.requestToken.getAuthenticationURL();
    }

    static /* synthetic */ AccessToken access$000(TwitterPrefsPane x0, String x1) {
        return x0.getOAuthAccessToken(x1);
    }

    static /* synthetic */ ExternalIntegrationInfo access$100(TwitterPrefsPane x0) {
        return x0.externalIntegrationInfo;
    }

    static /* synthetic */ Fragment access$200(TwitterPrefsPane x0) {
        return x0.linkedFragment();
    }

    static /* synthetic */ void access$300(TwitterPrefsPane x0, Fragment x1, AjaxRequestTarget x2) {
        x0.switchContentFragments(x1, x2);
    }

    static /* synthetic */ Fragment access$400(TwitterPrefsPane x0) {
        return x0.unlinkedFragment();
    }
}

