/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.dataproviders;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.injection.web.InjectorHolder;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.tool.models.DetachablePersonModel;

public class RequestedFriendsDataProvider
implements IDataProvider<Person>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String userUuid;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileConnectionsLogic")
    private ProfileConnectionsLogic connectionsLogic;

    public RequestedFriendsDataProvider(String userUuid) {
        InjectorHolder.getInjector().inject((Object)this);
        this.userUuid = userUuid;
    }

    public Iterator<Person> iterator(int first, int count) {
        try {
            List requests = this.connectionsLogic.getConnectionRequestsForUser(this.userUuid);
            Collections.sort(requests);
            List slice = requests.subList(first, first + count);
            return slice.iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST.iterator();
        }
    }

    public int size() {
        return this.connectionsLogic.getConnectionRequestsForUserCount(this.userUuid);
    }

    public IModel<Person> model(Person object) {
        return new DetachablePersonModel(object);
    }

    public void detach() {
    }
}

