/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.entityprovider;

import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.profile2.logic.ProfileMessagingLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;

public class ProfileMessagingEntityProvider
extends AbstractEntityProvider
implements EntityProvider,
AutoRegisterEntityProvider,
Outputable,
Describeable,
ActionsExecutable {
    public static final String ENTITY_PREFIX = "profile-message";
    private SakaiProxy sakaiProxy;
    private ProfileMessagingLogic messagingLogic;

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    @EntityCustomAction(action="unread-count", viewKey="list")
    public Object getUnreadMessageCount(EntityView view) {
        String uuid = this.sakaiProxy.getCurrentUserId();
        int count = this.messagingLogic.getAllUnreadMessagesCount(uuid);
        return new ActionReturn((Object)count);
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setMessagingLogic(ProfileMessagingLogic messagingLogic) {
        this.messagingLogic = messagingLogic;
    }
}

