/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.GalleryImage;
import org.sakaiproject.profile2.tool.components.FocusOnLoadBehaviour;
import org.sakaiproject.profile2.tool.components.GalleryImageRenderer;
import org.sakaiproject.profile2.tool.pages.panels.GalleryImageEdit;

public class GalleryImageEdit
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(GalleryImageEdit.class);
    private final WebMarkupContainer imageOptionsContainer;
    private final WebMarkupContainer removeConfirmContainer;
    private final WebMarkupContainer setProfileImageConfirmContainer;
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileImageLogic")
    private ProfileImageLogic imageLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePreferencesLogic")
    private ProfilePreferencesLogic preferencesLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;

    public GalleryImageEdit(String id, String userId, GalleryImage image, int galleryPageIndex) {
        super(id);
        log.debug((Object)"GalleryImageEdit()");
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{formFeedback});
        Form imageEditForm = new Form("galleryImageEditForm");
        imageEditForm.setOutputMarkupId(true);
        this.add(new Component[]{imageEditForm});
        this.imageOptionsContainer = new WebMarkupContainer("galleryImageOptionsContainer");
        this.imageOptionsContainer.setOutputMarkupId(true);
        this.imageOptionsContainer.setOutputMarkupPlaceholderTag(true);
        this.imageOptionsContainer.add(new Component[]{new Label("removePictureLabel", (IModel)new ResourceModel("pictures.removepicture"))});
        AjaxFallbackButton removePictureButton = this.createRemovePictureButton(imageEditForm);
        this.imageOptionsContainer.add(new Component[]{removePictureButton});
        Label setProfileImageLabel = new Label("setProfileImageLabel", (IModel)new ResourceModel("pictures.setprofileimage"));
        this.imageOptionsContainer.add(new Component[]{setProfileImageLabel});
        AjaxFallbackButton setProfileImageButton = this.createSetProfileImageButton(imageEditForm);
        if (this.sakaiProxy.isOfficialImageEnabledGlobally() && !this.sakaiProxy.isUsingOfficialImageButAlternateSelectionEnabled() || this.preferencesLogic.getPreferencesRecordForUser(userId).isUseOfficialImage()) {
            setProfileImageLabel.setVisible(false);
            setProfileImageButton.setVisible(false);
        }
        this.imageOptionsContainer.add(new Component[]{setProfileImageButton});
        imageEditForm.add(new Component[]{this.imageOptionsContainer});
        this.removeConfirmContainer = new WebMarkupContainer("galleryRemoveImageConfirmContainer");
        this.removeConfirmContainer.setOutputMarkupId(true);
        this.removeConfirmContainer.setOutputMarkupPlaceholderTag(true);
        Label removeConfirmLabel = new Label("removePictureConfirmLabel", (IModel)new ResourceModel("pictures.removepicture.confirm"));
        this.removeConfirmContainer.add(new Component[]{removeConfirmLabel});
        AjaxFallbackButton removeConfirmButton = this.createRemoveConfirmButton(userId, image, galleryPageIndex, formFeedback, imageEditForm);
        removeConfirmButton.add(new IBehavior[]{new FocusOnLoadBehaviour()});
        this.removeConfirmContainer.add(new Component[]{removeConfirmButton});
        AjaxFallbackButton removeCancelButton = this.createRemoveCancelButton(imageEditForm);
        this.removeConfirmContainer.add(new Component[]{removeCancelButton});
        this.removeConfirmContainer.setVisible(false);
        imageEditForm.add(new Component[]{this.removeConfirmContainer});
        this.setProfileImageConfirmContainer = new WebMarkupContainer("gallerySetProfileImageConfirmContainer");
        this.setProfileImageConfirmContainer.setOutputMarkupId(true);
        this.setProfileImageConfirmContainer.setOutputMarkupPlaceholderTag(true);
        Label setProfileImageConfirmLabel = new Label("setProfileImageConfirmLabel", (IModel)new ResourceModel("pictures.setprofileimage.confirm"));
        this.setProfileImageConfirmContainer.add(new Component[]{setProfileImageConfirmLabel});
        AjaxFallbackButton setProfileImageConfirmButton = this.createSetProfileImageConfirmButton(userId, image, galleryPageIndex, formFeedback, imageEditForm);
        setProfileImageConfirmButton.add(new IBehavior[]{new FocusOnLoadBehaviour()});
        this.setProfileImageConfirmContainer.add(new Component[]{setProfileImageConfirmButton});
        AjaxFallbackButton setProfileImageCancelButton = this.createSetProfileImageCancelButton(imageEditForm);
        this.setProfileImageConfirmContainer.add(new Component[]{setProfileImageCancelButton});
        this.setProfileImageConfirmContainer.setVisible(false);
        imageEditForm.add(new Component[]{this.setProfileImageConfirmContainer});
        this.add(new Component[]{new GalleryImageRenderer("galleryImageMainRenderer", image.getMainResource())});
    }

    private AjaxFallbackButton createRemoveCancelButton(Form imageEditForm) {
        1 removeCancelButton = new /* Unavailable Anonymous Inner Class!! */;
        return removeCancelButton;
    }

    private AjaxFallbackButton createRemoveConfirmButton(String userId, GalleryImage image, int galleryPageIndex, Label formFeedback, Form imageEditForm) {
        2 removeConfirmButton = new /* Unavailable Anonymous Inner Class!! */;
        return removeConfirmButton;
    }

    private AjaxFallbackButton createRemovePictureButton(Form imageEditForm) {
        3 removePictureButton = new /* Unavailable Anonymous Inner Class!! */;
        return removePictureButton;
    }

    private AjaxFallbackButton createSetProfileImageCancelButton(Form imageEditForm) {
        4 removeCancelButton = new /* Unavailable Anonymous Inner Class!! */;
        return removeCancelButton;
    }

    private AjaxFallbackButton createSetProfileImageButton(Form imageEditForm) {
        5 setProfileImageButton = new /* Unavailable Anonymous Inner Class!! */;
        return setProfileImageButton;
    }

    private AjaxFallbackButton createSetProfileImageConfirmButton(String userId, GalleryImage image, int galleryPageIndex, Label formFeedback, Form imageEditForm) {
        6 setProfileImageButton = new /* Unavailable Anonymous Inner Class!! */;
        return setProfileImageButton;
    }

    static /* synthetic */ WebMarkupContainer access$000(GalleryImageEdit x0) {
        return x0.removeConfirmContainer;
    }

    static /* synthetic */ WebMarkupContainer access$100(GalleryImageEdit x0) {
        return x0.imageOptionsContainer;
    }

    static /* synthetic */ ProfileImageLogic access$200(GalleryImageEdit x0) {
        return x0.imageLogic;
    }

    static /* synthetic */ WebMarkupContainer access$300(GalleryImageEdit x0) {
        return x0.setProfileImageConfirmContainer;
    }

    static /* synthetic */ SakaiProxy access$400(GalleryImageEdit x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$500(GalleryImageEdit x0) {
        return x0.wallLogic;
    }
}

