/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileMessagingLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.Message;
import org.sakaiproject.profile2.model.MessageThread;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.tool.components.ProfileImageRenderer;
import org.sakaiproject.profile2.tool.dataproviders.MessagesDataProvider;
import org.sakaiproject.profile2.tool.models.StringModel;
import org.sakaiproject.profile2.tool.pages.MyMessages;
import org.sakaiproject.profile2.tool.pages.panels.ConfirmedFriends;
import org.sakaiproject.profile2.tool.pages.panels.MessageView;
import org.sakaiproject.profile2.util.ProfileUtils;

public class MessageView
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ConfirmedFriends.class);
    private DataView<Message> messageList = null;
    private WebMarkupContainer messageListContainer = null;
    private boolean lastUnreadSet = false;
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    protected SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePreferencesLogic")
    protected ProfilePreferencesLogic preferencesLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileMessagingLogic")
    protected ProfileMessagingLogic messagingLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePrivacyLogic")
    protected ProfilePrivacyLogic privacyLogic;

    public MessageView(String id, PageParameters parameters) {
        super(id);
        log.debug((Object)("MyMessageView(" + parameters.toString() + ")"));
        MessageThread thread = this.messagingLogic.getMessageThread(parameters.getString("thread"));
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (!this.messagingLogic.isThreadParticipant(thread.getId(), currentUserUuid)) {
            log.error((Object)("MyMessageView: user " + currentUserUuid + " attempted to access restricted thread: " + thread.getId()));
            throw new RestartResponseException((Page)new MyMessages());
        }
        this.renderMyMessagesView(this.sakaiProxy.getCurrentUserId(), thread.getId(), thread.getSubject());
    }

    public MessageView(String id, String currentUserUuid, String threadId) {
        super(id);
        log.debug((Object)("MyMessageView(" + currentUserUuid + ", " + threadId + ")"));
        String threadSubject = this.messagingLogic.getThreadSubject(threadId);
        this.renderMyMessagesView(currentUserUuid, threadId, threadSubject);
    }

    public MessageView(String id, String currentUserUuid, String threadId, String threadSubject) {
        super(id);
        log.debug((Object)("MyMessageView(" + currentUserUuid + ", " + threadId + ", " + threadSubject + ")"));
        this.renderMyMessagesView(currentUserUuid, threadId, threadSubject);
    }

    private void renderMyMessagesView(String currentUserUuid, String threadId, String threadSubject) {
        WebMarkupContainer messageDetailsContainer = new WebMarkupContainer("messageDetailsContainer");
        messageDetailsContainer.setOutputMarkupId(true);
        Label threadSubjectLabel = new Label("threadSubject", (IModel)new Model((Serializable)((Object)threadSubject)));
        messageDetailsContainer.add(new Component[]{threadSubjectLabel});
        this.add(new Component[]{messageDetailsContainer});
        this.messageListContainer = new WebMarkupContainer("messageListContainer");
        this.messageListContainer.setOutputMarkupId(true);
        MessagesDataProvider provider = new MessagesDataProvider(threadId);
        this.messageList = new /* Unavailable Anonymous Inner Class!! */;
        this.messageList.setOutputMarkupId(true);
        this.messageListContainer.add(new Component[]{this.messageList});
        this.add(new Component[]{this.messageListContainer});
        StringModel stringModel = new StringModel();
        Form replyForm = new Form("replyForm", (IModel)new Model((Serializable)stringModel));
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{formFeedback});
        replyForm.add(new Component[]{new Label("replyLabel", (IModel)new ResourceModel("message.reply"))});
        TextArea replyField = new TextArea("replyField", (IModel)new PropertyModel((Object)stringModel, "string"));
        replyField.setRequired(true);
        replyField.setOutputMarkupId(true);
        replyForm.add(new Component[]{replyField});
        2 replyButton = new /* Unavailable Anonymous Inner Class!! */;
        replyForm.add(new Component[]{replyButton});
        replyButton.setModel((IModel)new ResourceModel("button.message.send"));
        this.add(new Component[]{replyForm});
    }

    private Component buildItem(Message message) {
        WebMarkupContainer item = new WebMarkupContainer(this.messageList.newChildId());
        item.setOutputMarkupId(true);
        this.messageList.add(new Component[]{item});
        ProfilePreferences prefs = this.preferencesLogic.getPreferencesRecordForUser(message.getFrom());
        item.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */.add(new Component[]{new ProfileImageRenderer("messagePhoto", message.getFrom(), prefs, 2, false)})});
        item.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */.add(new Component[]{new Label("messageFromName", (IModel)new Model((Serializable)((Object)this.sakaiProxy.getUserDisplayName(message.getFrom()))))})});
        item.add(new Component[]{new Label("messageDate", ProfileUtils.convertDateToString((Date)message.getDatePosted(), (String)"dd MMMM 'at' HH:mm"))});
        item.add(new Component[]{new Label("messageBody", (IModel)new Model((Serializable)((Object)message.getMessage())))});
        return item;
    }

    static /* synthetic */ boolean access$000(MessageView x0) {
        return x0.lastUnreadSet;
    }

    static /* synthetic */ boolean access$002(MessageView x0, boolean x1) {
        x0.lastUnreadSet = x1;
        return x0.lastUnreadSet;
    }

    static /* synthetic */ Component access$100(MessageView x0, Message x1) {
        return x0.buildItem(x1);
    }

    static /* synthetic */ WebMarkupContainer access$200(MessageView x0) {
        return x0.messageListContainer;
    }
}

