/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.model.CompanyProfile;
import org.sakaiproject.profile2.tool.pages.panels.ViewBusiness;

public class ViewBusiness
extends Panel {
    private static final long serialVersionUID = 1L;
    private int visibleFieldCount_business = 0;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    private ProfileLogic profileLogic;

    public ViewBusiness(String id, String userUuid, SakaiPerson sakaiPerson, boolean isBusinessInfoAllowed) {
        super(id);
        WebMarkupContainer businessInfoContainer = new WebMarkupContainer("mainSectionContainer_business");
        businessInfoContainer.setOutputMarkupId(true);
        businessInfoContainer.add(new Component[]{new Label("mainSectionHeading_business", (IModel)new ResourceModel("heading.business"))});
        this.add(new Component[]{businessInfoContainer});
        WebMarkupContainer businessBiographyContainer = new WebMarkupContainer("businessBiographyContainer");
        businessBiographyContainer.add(new Component[]{new Label("businessBiographyLabel", (IModel)new ResourceModel("profile.business.bio"))});
        businessBiographyContainer.add(new Component[]{new Label("businessBiography", sakaiPerson.getBusinessBiography())});
        businessInfoContainer.add(new Component[]{businessBiographyContainer});
        if (StringUtils.isBlank((String)sakaiPerson.getBusinessBiography())) {
            businessBiographyContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount_business;
        }
        WebMarkupContainer companyProfilesContainer = new WebMarkupContainer("companyProfilesContainer");
        companyProfilesContainer.add(new Component[]{new Label("companyProfilesLabel", (IModel)new ResourceModel("profile.business.company.profiles"))});
        List companyProfiles = this.profileLogic.getCompanyProfiles(userUuid);
        ArrayList<1> tabs = new ArrayList<1>();
        if (null != companyProfiles) {
            for (CompanyProfile companyProfile : companyProfiles) {
                ++this.visibleFieldCount_business;
                tabs.add(new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        companyProfilesContainer.add(new Component[]{new AjaxTabbedPanel("companyProfiles", tabs)});
        businessInfoContainer.add(new Component[]{companyProfilesContainer});
        if (0 == tabs.size()) {
            companyProfilesContainer.setVisible(false);
        }
        if (this.visibleFieldCount_business == 0 || !isBusinessInfoAllowed) {
            businessInfoContainer.setVisible(false);
        }
    }

    public int getVisibleFieldCount() {
        return this.visibleFieldCount_business;
    }
}

