/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.exception.ProfilePrototypeNotDefinedException;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.model.SocialNetworkingInfo;
import org.sakaiproject.profile2.tool.pages.panels.ViewBusiness;
import org.sakaiproject.profile2.types.PrivacyType;
import org.sakaiproject.profile2.util.ProfileUtils;

public class ViewProfilePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ViewProfilePanel.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    protected SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    protected ProfileLogic profileLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePrivacyLogic")
    protected ProfilePrivacyLogic privacyLogic;

    public ViewProfilePanel(String id, String userUuid, String currentUserId, ProfilePrivacy privacy, boolean friend) {
        super(id);
        EmptyPanel businessPanel;
        SakaiPerson sakaiPerson;
        if (this.sakaiProxy.getSakaiPerson(userUuid) == null) {
            log.info((Object)("No SakaiPerson for " + userUuid));
            sakaiPerson = this.sakaiProxy.getSakaiPersonPrototype();
            if (sakaiPerson == null) {
                throw new ProfilePrototypeNotDefinedException("Couldn't create a SakaiPerson prototype for " + userUuid);
            }
        } else {
            sakaiPerson = this.sakaiProxy.getSakaiPerson(userUuid);
        }
        int visibleContainerCount = 0;
        boolean isBasicInfoAllowed = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_BASICINFO);
        boolean isContactInfoAllowed = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_CONTACTINFO);
        boolean isBusinessInfoAllowed = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_BUSINESSINFO);
        boolean isPersonalInfoAllowed = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_PERSONALINFO);
        boolean isStaffInfoAllowed = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_STAFFINFO);
        boolean isStudentInfoAllowed = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_STUDENTINFO);
        boolean isSocialNetworkingInfoAllowed = this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_SOCIALINFO);
        WebMarkupContainer basicInfoContainer = new WebMarkupContainer("mainSectionContainer_basic");
        basicInfoContainer.setOutputMarkupId(true);
        String nickname = sakaiPerson.getNickname();
        String personalSummary = sakaiPerson.getNotes();
        Date dateOfBirth = sakaiPerson.getDateOfBirth();
        String birthday = "";
        int visibleFieldCount_basic = 0;
        if (dateOfBirth != null) {
            birthday = this.privacyLogic.isBirthYearVisible(userUuid) ? ProfileUtils.convertDateToString((Date)dateOfBirth, (String)"dd MMMM yyyy") : ProfileUtils.convertDateToString((Date)dateOfBirth, (String)"dd MMMM");
        }
        basicInfoContainer.add(new Component[]{new Label("mainSectionHeading_basic", (IModel)new ResourceModel("heading.basic"))});
        WebMarkupContainer nicknameContainer = new WebMarkupContainer("nicknameContainer");
        nicknameContainer.add(new Component[]{new Label("nicknameLabel", (IModel)new ResourceModel("profile.nickname"))});
        nicknameContainer.add(new Component[]{new Label("nickname", nickname)});
        basicInfoContainer.add(new Component[]{nicknameContainer});
        if (StringUtils.isBlank((String)nickname)) {
            nickname = "";
            nicknameContainer.setVisible(false);
        } else {
            ++visibleFieldCount_basic;
        }
        WebMarkupContainer birthdayContainer = new WebMarkupContainer("birthdayContainer");
        birthdayContainer.add(new Component[]{new Label("birthdayLabel", (IModel)new ResourceModel("profile.birthday"))});
        birthdayContainer.add(new Component[]{new Label("birthday", birthday)});
        basicInfoContainer.add(new Component[]{birthdayContainer});
        if (StringUtils.isBlank((String)birthday)) {
            birthdayContainer.setVisible(false);
        } else {
            ++visibleFieldCount_basic;
        }
        WebMarkupContainer personalSummaryContainer = new WebMarkupContainer("personalSummaryContainer");
        personalSummaryContainer.add(new Component[]{new Label("personalSummaryLabel", (IModel)new ResourceModel("profile.summary"))});
        personalSummaryContainer.add(new Component[]{new Label("personalSummary", ProfileUtils.processHtml((String)personalSummary)).setEscapeModelStrings(false)});
        basicInfoContainer.add(new Component[]{personalSummaryContainer});
        if (StringUtils.isBlank((String)personalSummary)) {
            personalSummaryContainer.setVisible(false);
        } else {
            ++visibleFieldCount_basic;
        }
        this.add(new Component[]{basicInfoContainer});
        if (visibleFieldCount_basic == 0 || !isBasicInfoAllowed) {
            basicInfoContainer.setVisible(false);
        } else {
            ++visibleContainerCount;
        }
        WebMarkupContainer contactInfoContainer = new WebMarkupContainer("mainSectionContainer_contact");
        contactInfoContainer.setOutputMarkupId(true);
        String email = this.sakaiProxy.getUserEmail(userUuid);
        String homepage = sakaiPerson.getLabeledURI();
        String workphone = sakaiPerson.getTelephoneNumber();
        String homephone = sakaiPerson.getHomePhone();
        String mobilephone = sakaiPerson.getMobile();
        String facsimile = sakaiPerson.getFacsimileTelephoneNumber();
        int visibleFieldCount_contact = 0;
        contactInfoContainer.add(new Component[]{new Label("mainSectionHeading_contact", (IModel)new ResourceModel("heading.contact"))});
        WebMarkupContainer emailContainer = new WebMarkupContainer("emailContainer");
        emailContainer.add(new Component[]{new Label("emailLabel", (IModel)new ResourceModel("profile.email"))});
        emailContainer.add(new Component[]{new Label("email", email)});
        contactInfoContainer.add(new Component[]{emailContainer});
        if (StringUtils.isBlank((String)email)) {
            emailContainer.setVisible(false);
        } else {
            ++visibleFieldCount_contact;
        }
        WebMarkupContainer homepageContainer = new WebMarkupContainer("homepageContainer");
        homepageContainer.add(new Component[]{new Label("homepageLabel", (IModel)new ResourceModel("profile.homepage"))});
        homepageContainer.add(new Component[]{new ExternalLink("homepage", homepage, homepage)});
        contactInfoContainer.add(new Component[]{homepageContainer});
        if (StringUtils.isBlank((String)homepage)) {
            homepageContainer.setVisible(false);
        } else {
            ++visibleFieldCount_contact;
        }
        WebMarkupContainer workphoneContainer = new WebMarkupContainer("workphoneContainer");
        workphoneContainer.add(new Component[]{new Label("workphoneLabel", (IModel)new ResourceModel("profile.phone.work"))});
        workphoneContainer.add(new Component[]{new Label("workphone", workphone)});
        contactInfoContainer.add(new Component[]{workphoneContainer});
        if (StringUtils.isBlank((String)workphone)) {
            workphoneContainer.setVisible(false);
        } else {
            ++visibleFieldCount_contact;
        }
        WebMarkupContainer homephoneContainer = new WebMarkupContainer("homephoneContainer");
        homephoneContainer.add(new Component[]{new Label("homephoneLabel", (IModel)new ResourceModel("profile.phone.home"))});
        homephoneContainer.add(new Component[]{new Label("homephone", homephone)});
        contactInfoContainer.add(new Component[]{homephoneContainer});
        if (StringUtils.isBlank((String)homephone)) {
            homephoneContainer.setVisible(false);
        } else {
            ++visibleFieldCount_contact;
        }
        WebMarkupContainer mobilephoneContainer = new WebMarkupContainer("mobilephoneContainer");
        mobilephoneContainer.add(new Component[]{new Label("mobilephoneLabel", (IModel)new ResourceModel("profile.phone.mobile"))});
        mobilephoneContainer.add(new Component[]{new Label("mobilephone", mobilephone)});
        contactInfoContainer.add(new Component[]{mobilephoneContainer});
        if (StringUtils.isBlank((String)mobilephone)) {
            mobilephoneContainer.setVisible(false);
        } else {
            ++visibleFieldCount_contact;
        }
        WebMarkupContainer facsimileContainer = new WebMarkupContainer("facsimileContainer");
        facsimileContainer.add(new Component[]{new Label("facsimileLabel", (IModel)new ResourceModel("profile.phone.facsimile"))});
        facsimileContainer.add(new Component[]{new Label("facsimile", facsimile)});
        contactInfoContainer.add(new Component[]{facsimileContainer});
        if (StringUtils.isBlank((String)facsimile)) {
            facsimileContainer.setVisible(false);
        } else {
            ++visibleFieldCount_contact;
        }
        this.add(new Component[]{contactInfoContainer});
        if (visibleFieldCount_contact == 0 || !isContactInfoAllowed) {
            contactInfoContainer.setVisible(false);
        } else {
            ++visibleContainerCount;
        }
        WebMarkupContainer staffInfoContainer = new WebMarkupContainer("mainSectionContainer_staff");
        staffInfoContainer.setOutputMarkupId(true);
        String department = sakaiPerson.getOrganizationalUnit();
        String position = sakaiPerson.getTitle();
        String school = sakaiPerson.getCampus();
        String room = sakaiPerson.getRoomNumber();
        String staffProfile = sakaiPerson.getStaffProfile();
        String universityProfileUrl = sakaiPerson.getUniversityProfileUrl();
        String academicProfileUrl = sakaiPerson.getAcademicProfileUrl();
        String publications = sakaiPerson.getPublications();
        int visibleFieldCount_staff = 0;
        staffInfoContainer.add(new Component[]{new Label("mainSectionHeading_staff", (IModel)new ResourceModel("heading.staff"))});
        WebMarkupContainer departmentContainer = new WebMarkupContainer("departmentContainer");
        departmentContainer.add(new Component[]{new Label("departmentLabel", (IModel)new ResourceModel("profile.department"))});
        departmentContainer.add(new Component[]{new Label("department", department)});
        staffInfoContainer.add(new Component[]{departmentContainer});
        if (StringUtils.isBlank((String)department)) {
            departmentContainer.setVisible(false);
        } else {
            ++visibleFieldCount_staff;
        }
        WebMarkupContainer positionContainer = new WebMarkupContainer("positionContainer");
        positionContainer.add(new Component[]{new Label("positionLabel", (IModel)new ResourceModel("profile.position"))});
        positionContainer.add(new Component[]{new Label("position", position)});
        staffInfoContainer.add(new Component[]{positionContainer});
        if (StringUtils.isBlank((String)position)) {
            positionContainer.setVisible(false);
        } else {
            ++visibleFieldCount_staff;
        }
        WebMarkupContainer schoolContainer = new WebMarkupContainer("schoolContainer");
        schoolContainer.add(new Component[]{new Label("schoolLabel", (IModel)new ResourceModel("profile.school"))});
        schoolContainer.add(new Component[]{new Label("school", school)});
        staffInfoContainer.add(new Component[]{schoolContainer});
        if (StringUtils.isBlank((String)school)) {
            schoolContainer.setVisible(false);
        } else {
            ++visibleFieldCount_staff;
        }
        WebMarkupContainer roomContainer = new WebMarkupContainer("roomContainer");
        roomContainer.add(new Component[]{new Label("roomLabel", (IModel)new ResourceModel("profile.room"))});
        roomContainer.add(new Component[]{new Label("room", room)});
        staffInfoContainer.add(new Component[]{roomContainer});
        if (StringUtils.isBlank((String)room)) {
            roomContainer.setVisible(false);
        } else {
            ++visibleFieldCount_staff;
        }
        WebMarkupContainer staffProfileContainer = new WebMarkupContainer("staffProfileContainer");
        staffProfileContainer.add(new Component[]{new Label("staffProfileLabel", (IModel)new ResourceModel("profile.staffprofile"))});
        staffProfileContainer.add(new Component[]{new Label("staffProfile", staffProfile)});
        staffInfoContainer.add(new Component[]{staffProfileContainer});
        if (StringUtils.isBlank((String)staffProfile)) {
            staffProfileContainer.setVisible(false);
        } else {
            ++visibleFieldCount_staff;
        }
        WebMarkupContainer universityProfileUrlContainer = new WebMarkupContainer("universityProfileUrlContainer");
        universityProfileUrlContainer.add(new Component[]{new Label("universityProfileUrlLabel", (IModel)new ResourceModel("profile.universityprofileurl"))});
        universityProfileUrlContainer.add(new Component[]{new ExternalLink("universityProfileUrl", universityProfileUrl, universityProfileUrl)});
        staffInfoContainer.add(new Component[]{universityProfileUrlContainer});
        if (StringUtils.isBlank((String)universityProfileUrl)) {
            universityProfileUrlContainer.setVisible(false);
        } else {
            ++visibleFieldCount_contact;
        }
        WebMarkupContainer academicProfileUrlContainer = new WebMarkupContainer("academicProfileUrlContainer");
        academicProfileUrlContainer.add(new Component[]{new Label("academicProfileUrlLabel", (IModel)new ResourceModel("profile.academicprofileurl"))});
        academicProfileUrlContainer.add(new Component[]{new ExternalLink("academicProfileUrl", academicProfileUrl, academicProfileUrl)});
        staffInfoContainer.add(new Component[]{academicProfileUrlContainer});
        if (StringUtils.isBlank((String)academicProfileUrl)) {
            academicProfileUrlContainer.setVisible(false);
        } else {
            ++visibleFieldCount_contact;
        }
        WebMarkupContainer publicationsContainer = new WebMarkupContainer("publicationsContainer");
        publicationsContainer.add(new Component[]{new Label("publicationsLabel", (IModel)new ResourceModel("profile.publications"))});
        publicationsContainer.add(new Component[]{new Label("publications", ProfileUtils.processHtml((String)publications)).setEscapeModelStrings(false)});
        staffInfoContainer.add(new Component[]{publicationsContainer});
        if (StringUtils.isBlank((String)publications)) {
            publicationsContainer.setVisible(false);
        } else {
            ++visibleFieldCount_staff;
        }
        this.add(new Component[]{staffInfoContainer});
        if (visibleFieldCount_staff == 0 || !isStaffInfoAllowed) {
            staffInfoContainer.setVisible(false);
        } else {
            ++visibleContainerCount;
        }
        if (this.sakaiProxy.isBusinessProfileEnabled()) {
            businessPanel = new ViewBusiness("viewBusiness", userUuid, sakaiPerson, isBusinessInfoAllowed);
            if (0 == businessPanel.getVisibleFieldCount() || !isBusinessInfoAllowed) {
                businessPanel.setVisible(false);
            } else {
                ++visibleContainerCount;
            }
            this.add(new Component[]{businessPanel});
        } else {
            businessPanel = new EmptyPanel("viewBusiness");
            this.add(new Component[]{businessPanel});
        }
        WebMarkupContainer studentInfoContainer = new WebMarkupContainer("mainSectionContainer_student");
        studentInfoContainer.setOutputMarkupId(true);
        String course = sakaiPerson.getEducationCourse();
        String subjects = sakaiPerson.getEducationSubjects();
        int visibleFieldCount_student = 0;
        studentInfoContainer.add(new Component[]{new Label("mainSectionHeading_student", (IModel)new ResourceModel("heading.student"))});
        WebMarkupContainer courseContainer = new WebMarkupContainer("courseContainer");
        courseContainer.add(new Component[]{new Label("courseLabel", (IModel)new ResourceModel("profile.course"))});
        courseContainer.add(new Component[]{new Label("course", course)});
        studentInfoContainer.add(new Component[]{courseContainer});
        if (StringUtils.isBlank((String)course)) {
            courseContainer.setVisible(false);
        } else {
            ++visibleFieldCount_student;
        }
        WebMarkupContainer subjectsContainer = new WebMarkupContainer("subjectsContainer");
        subjectsContainer.add(new Component[]{new Label("subjectsLabel", (IModel)new ResourceModel("profile.subjects"))});
        subjectsContainer.add(new Component[]{new Label("subjects", subjects)});
        studentInfoContainer.add(new Component[]{subjectsContainer});
        if (StringUtils.isBlank((String)subjects)) {
            subjectsContainer.setVisible(false);
        } else {
            ++visibleFieldCount_student;
        }
        this.add(new Component[]{studentInfoContainer});
        if (visibleFieldCount_student == 0 || !isStudentInfoAllowed) {
            studentInfoContainer.setVisible(false);
        } else {
            ++visibleContainerCount;
        }
        WebMarkupContainer socialNetworkingInfoContainer = new WebMarkupContainer("mainSectionContainer_socialNetworking");
        socialNetworkingInfoContainer.setOutputMarkupId(true);
        socialNetworkingInfoContainer.add(new Component[]{new Label("mainSectionHeading_socialNetworking", (IModel)new ResourceModel("heading.social"))});
        SocialNetworkingInfo socialNetworkingInfo = this.profileLogic.getSocialNetworkingInfo(userUuid);
        if (null == socialNetworkingInfo) {
            socialNetworkingInfo = this.profileLogic.getSocialNetworkingInfo(userUuid);
        }
        String facebookUsername = socialNetworkingInfo.getFacebookUrl();
        String linkedinUsername = socialNetworkingInfo.getLinkedinUrl();
        String myspaceUsername = socialNetworkingInfo.getMyspaceUrl();
        String skypeUsername = socialNetworkingInfo.getSkypeUsername();
        String twitterUsername = socialNetworkingInfo.getTwitterUrl();
        int visibleFieldCount_socialNetworking = 0;
        WebMarkupContainer facebookContainer = new WebMarkupContainer("facebookContainer");
        facebookContainer.add(new Component[]{new Label("facebookLabel", (IModel)new ResourceModel("profile.socialnetworking.facebook"))});
        facebookContainer.add(new Component[]{new ExternalLink("facebookLink", facebookUsername, facebookUsername)});
        socialNetworkingInfoContainer.add(new Component[]{facebookContainer});
        if (StringUtils.isBlank((String)facebookUsername)) {
            facebookContainer.setVisible(false);
        } else {
            ++visibleFieldCount_socialNetworking;
        }
        WebMarkupContainer linkedinContainer = new WebMarkupContainer("linkedinContainer");
        linkedinContainer.add(new Component[]{new Label("linkedinLabel", (IModel)new ResourceModel("profile.socialnetworking.linkedin"))});
        linkedinContainer.add(new Component[]{new ExternalLink("linkedinLink", linkedinUsername, linkedinUsername)});
        socialNetworkingInfoContainer.add(new Component[]{linkedinContainer});
        if (StringUtils.isBlank((String)linkedinUsername)) {
            linkedinContainer.setVisible(false);
        } else {
            ++visibleFieldCount_socialNetworking;
        }
        WebMarkupContainer myspaceContainer = new WebMarkupContainer("myspaceContainer");
        myspaceContainer.add(new Component[]{new Label("myspaceLabel", (IModel)new ResourceModel("profile.socialnetworking.myspace"))});
        myspaceContainer.add(new Component[]{new ExternalLink("myspaceLink", myspaceUsername, myspaceUsername)});
        socialNetworkingInfoContainer.add(new Component[]{myspaceContainer});
        if (StringUtils.isBlank((String)myspaceUsername)) {
            myspaceContainer.setVisible(false);
        } else {
            ++visibleFieldCount_socialNetworking;
        }
        WebMarkupContainer twitterContainer = new WebMarkupContainer("twitterContainer");
        twitterContainer.add(new Component[]{new Label("twitterLabel", (IModel)new ResourceModel("profile.socialnetworking.twitter"))});
        twitterContainer.add(new Component[]{new ExternalLink("twitterLink", twitterUsername, twitterUsername)});
        socialNetworkingInfoContainer.add(new Component[]{twitterContainer});
        if (StringUtils.isBlank((String)twitterUsername)) {
            twitterContainer.setVisible(false);
        } else {
            ++visibleFieldCount_socialNetworking;
        }
        WebMarkupContainer skypeContainer = new WebMarkupContainer("skypeContainer");
        skypeContainer.add(new Component[]{new Label("skypeLabel", (IModel)new ResourceModel("profile.socialnetworking.skype"))});
        skypeContainer.add(new Component[]{new ExternalLink("skypeLink", ProfileUtils.getSkypeMeURL((String)skypeUsername), new ResourceModel("profile.socialnetworking.skype.link").getObject())});
        socialNetworkingInfoContainer.add(new Component[]{skypeContainer});
        if (StringUtils.isBlank((String)skypeUsername)) {
            skypeContainer.setVisible(false);
        } else {
            ++visibleFieldCount_socialNetworking;
        }
        this.add(new Component[]{socialNetworkingInfoContainer});
        if (visibleFieldCount_socialNetworking == 0 || !isSocialNetworkingInfoAllowed) {
            socialNetworkingInfoContainer.setVisible(false);
        } else {
            ++visibleContainerCount;
        }
        WebMarkupContainer personalInfoContainer = new WebMarkupContainer("mainSectionContainer_personal");
        personalInfoContainer.setOutputMarkupId(true);
        String favouriteBooks = sakaiPerson.getFavouriteBooks();
        String favouriteTvShows = sakaiPerson.getFavouriteTvShows();
        String favouriteMovies = sakaiPerson.getFavouriteMovies();
        String favouriteQuotes = sakaiPerson.getFavouriteQuotes();
        int visibleFieldCount_personal = 0;
        personalInfoContainer.add(new Component[]{new Label("mainSectionHeading_personal", (IModel)new ResourceModel("heading.interests"))});
        WebMarkupContainer booksContainer = new WebMarkupContainer("booksContainer");
        booksContainer.add(new Component[]{new Label("booksLabel", (IModel)new ResourceModel("profile.favourite.books"))});
        booksContainer.add(new Component[]{new Label("favouriteBooks", favouriteBooks)});
        personalInfoContainer.add(new Component[]{booksContainer});
        if (StringUtils.isBlank((String)favouriteBooks)) {
            booksContainer.setVisible(false);
        } else {
            ++visibleFieldCount_personal;
        }
        WebMarkupContainer tvContainer = new WebMarkupContainer("tvContainer");
        tvContainer.add(new Component[]{new Label("tvLabel", (IModel)new ResourceModel("profile.favourite.tv"))});
        tvContainer.add(new Component[]{new Label("favouriteTvShows", favouriteTvShows)});
        personalInfoContainer.add(new Component[]{tvContainer});
        if (StringUtils.isBlank((String)favouriteTvShows)) {
            tvContainer.setVisible(false);
        } else {
            ++visibleFieldCount_personal;
        }
        WebMarkupContainer moviesContainer = new WebMarkupContainer("moviesContainer");
        moviesContainer.add(new Component[]{new Label("moviesLabel", (IModel)new ResourceModel("profile.favourite.movies"))});
        moviesContainer.add(new Component[]{new Label("favouriteMovies", favouriteMovies)});
        personalInfoContainer.add(new Component[]{moviesContainer});
        if (StringUtils.isBlank((String)favouriteMovies)) {
            moviesContainer.setVisible(false);
        } else {
            ++visibleFieldCount_personal;
        }
        WebMarkupContainer quotesContainer = new WebMarkupContainer("quotesContainer");
        quotesContainer.add(new Component[]{new Label("quotesLabel", (IModel)new ResourceModel("profile.favourite.quotes"))});
        quotesContainer.add(new Component[]{new Label("favouriteQuotes", favouriteQuotes)});
        personalInfoContainer.add(new Component[]{quotesContainer});
        if (StringUtils.isBlank((String)favouriteQuotes)) {
            quotesContainer.setVisible(false);
        } else {
            ++visibleFieldCount_personal;
        }
        this.add(new Component[]{personalInfoContainer});
        if (visibleFieldCount_personal == 0 || !isPersonalInfoAllowed) {
            personalInfoContainer.setVisible(false);
        } else {
            ++visibleContainerCount;
        }
        Label noContainersVisible = new Label("noContainersVisible", (IModel)new ResourceModel("text.view.profile.nothing"));
        noContainersVisible.setOutputMarkupId(true);
        this.add(new Component[]{noContainersVisible});
        if (visibleContainerCount > 0) {
            noContainersVisible.setVisible(false);
        }
    }
}

