/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.components;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.ContextImage;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.tool.components.OnlinePresenceIndicator;

public class OnlinePresenceIndicator
extends Panel {
    private static final long serialVersionUID = 1L;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileConnectionsLogic")
    private ProfileConnectionsLogic connectionsLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;

    public OnlinePresenceIndicator(String id, String userUuid) {
        super(id);
        String firstname = this.sakaiProxy.getUserFirstName(userUuid);
        if (StringUtils.isBlank((String)firstname)) {
            firstname = new StringResourceModel("profile.name.first.none", null).getString();
        }
        int status = this.connectionsLogic.getOnlineStatus(userUuid);
        Map m = this.mapStatus(status);
        Label text = new Label("text", (IModel)new StringResourceModel((String)m.get("text"), null, new Object[]{firstname}));
        text.setOutputMarkupId(true);
        this.add(new Component[]{text});
        StringBuilder textId = new StringBuilder();
        textId.append("#");
        textId.append(text.getMarkupId());
        1 link = new /* Unavailable Anonymous Inner Class!! */;
        link.add(new IBehavior[]{new AttributeModifier("rel", true, (IModel)new Model((Serializable)textId))});
        link.add(new IBehavior[]{new AttributeModifier("href", true, (IModel)new Model((Serializable)textId))});
        ContextImage image = new ContextImage("icon", (IModel)new Model((Serializable)m.get("url")));
        link.add(new Component[]{image});
        this.add(new Component[]{link});
    }

    private Map<String, String> mapStatus(int status) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (status == 0) {
            m.put("url", "/library/image/silk/bullet_black.png");
            m.put("text", "text.profile.presence.offline");
        } else if (status == 1) {
            m.put("url", "/library/image/silk/bullet_green.png");
            m.put("text", "text.profile.presence.online");
        } else if (status == 2) {
            m.put("url", "/library/image/silk/bullet_yellow.png");
            m.put("text", "text.profile.presence.away");
        }
        return m;
    }
}

