/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.sakaiproject.profile2.exception.ProfilePreferencesNotDefinedException;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.tool.components.IconWithClueTip;
import org.sakaiproject.profile2.tool.pages.BasePage;
import org.sakaiproject.profile2.tool.pages.MyPreferences;

public class MyPreferences
extends BasePage {
    private static final Logger log = Logger.getLogger(MyPreferences.class);
    private transient ProfilePreferences profilePreferences;
    private CheckBox officialImage;
    private CheckBox gravatarImage;

    public MyPreferences() {
        log.debug((Object)"MyPreferences()");
        this.disableLink(this.preferencesLink);
        String userUuid = this.sakaiProxy.getCurrentUserId();
        this.profilePreferences = this.preferencesLogic.getPreferencesRecordForUser(userUuid, false);
        if (this.profilePreferences == null) {
            throw new ProfilePreferencesNotDefinedException("Couldn't retrieve preferences record for " + userUuid);
        }
        String emailAddress = this.sakaiProxy.getUserEmail(userUuid);
        if (emailAddress == null || emailAddress.length() == 0) {
            emailAddress = new ResourceModel("preferences.email.none").getObject();
        }
        Label heading = new Label("heading", (IModel)new ResourceModel("heading.preferences"));
        this.add(new Component[]{heading});
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        String formFeedbackId = formFeedback.getMarkupId();
        this.add(new Component[]{formFeedback});
        CompoundPropertyModel preferencesModel = new CompoundPropertyModel((Object)this.profilePreferences);
        Form form = new Form("form", (IModel)preferencesModel);
        form.setOutputMarkupId(true);
        form.add(new Component[]{new Label("emailSectionHeading", (IModel)new ResourceModel("heading.section.email"))});
        form.add(new Component[]{new Label("emailSectionText", (IModel)new StringResourceModel("preferences.email.message", null, new Object[]{emailAddress})).setEscapeModelStrings(false)});
        form.add(new Component[]{new Label("prefOn", (IModel)new ResourceModel("preference.option.on"))});
        form.add(new Component[]{new Label("prefOff", (IModel)new ResourceModel("preference.option.off"))});
        RadioGroup emailRequests = new RadioGroup("requestEmailEnabled", (IModel)new PropertyModel((Object)preferencesModel, "requestEmailEnabled"));
        emailRequests.add(new Component[]{new Radio("requestsOn", (IModel)new Model((Serializable)Boolean.valueOf(true)))});
        emailRequests.add(new Component[]{new Radio("requestsOff", (IModel)new Model((Serializable)Boolean.valueOf(false)))});
        emailRequests.add(new Component[]{new Label("requestsLabel", (IModel)new ResourceModel("preferences.email.requests"))});
        form.add(new Component[]{emailRequests});
        emailRequests.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        RadioGroup emailConfirms = new RadioGroup("confirmEmailEnabled", (IModel)new PropertyModel((Object)preferencesModel, "confirmEmailEnabled"));
        emailConfirms.add(new Component[]{new Radio("confirmsOn", (IModel)new Model((Serializable)Boolean.valueOf(true)))});
        emailConfirms.add(new Component[]{new Radio("confirmsOff", (IModel)new Model((Serializable)Boolean.valueOf(false)))});
        emailConfirms.add(new Component[]{new Label("confirmsLabel", (IModel)new ResourceModel("preferences.email.confirms"))});
        form.add(new Component[]{emailConfirms});
        emailConfirms.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        RadioGroup emailNewMessage = new RadioGroup("messageNewEmailEnabled", (IModel)new PropertyModel((Object)preferencesModel, "messageNewEmailEnabled"));
        emailNewMessage.add(new Component[]{new Radio("messageNewOn", (IModel)new Model((Serializable)Boolean.valueOf(true)))});
        emailNewMessage.add(new Component[]{new Radio("messageNewOff", (IModel)new Model((Serializable)Boolean.valueOf(false)))});
        emailNewMessage.add(new Component[]{new Label("messageNewLabel", (IModel)new ResourceModel("preferences.email.message.new"))});
        form.add(new Component[]{emailNewMessage});
        emailNewMessage.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        RadioGroup emailReplyMessage = new RadioGroup("messageReplyEmailEnabled", (IModel)new PropertyModel((Object)preferencesModel, "messageReplyEmailEnabled"));
        emailReplyMessage.add(new Component[]{new Radio("messageReplyOn", (IModel)new Model((Serializable)Boolean.valueOf(true)))});
        emailReplyMessage.add(new Component[]{new Radio("messageReplyOff", (IModel)new Model((Serializable)Boolean.valueOf(false)))});
        emailReplyMessage.add(new Component[]{new Label("messageReplyLabel", (IModel)new ResourceModel("preferences.email.message.reply"))});
        form.add(new Component[]{emailReplyMessage});
        emailReplyMessage.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        RadioGroup wallItemNew = new RadioGroup("wallItemNewEmailEnabled", (IModel)new PropertyModel((Object)preferencesModel, "wallItemNewEmailEnabled"));
        wallItemNew.add(new Component[]{new Radio("wallItemNewOn", (IModel)new Model((Serializable)Boolean.valueOf(true)))});
        wallItemNew.add(new Component[]{new Radio("wallItemNewOff", (IModel)new Model((Serializable)Boolean.valueOf(false)))});
        wallItemNew.add(new Component[]{new Label("wallItemNewLabel", (IModel)new ResourceModel("preferences.email.wall.new"))});
        form.add(new Component[]{wallItemNew});
        wallItemNew.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        RadioGroup worksiteNew = new RadioGroup("worksiteNewEmailEnabled", (IModel)new PropertyModel((Object)preferencesModel, "worksiteNewEmailEnabled"));
        worksiteNew.add(new Component[]{new Radio("worksiteNewOn", (IModel)new Model((Serializable)Boolean.valueOf(true)))});
        worksiteNew.add(new Component[]{new Radio("worksiteNewOff", (IModel)new Model((Serializable)Boolean.valueOf(false)))});
        worksiteNew.add(new Component[]{new Label("worksiteNewLabel", (IModel)new ResourceModel("preferences.email.worksite.new"))});
        form.add(new Component[]{worksiteNew});
        worksiteNew.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer twitterSectionHeadingContainer = new WebMarkupContainer("twitterSectionHeadingContainer");
        twitterSectionHeadingContainer.add(new Component[]{new Label("twitterSectionHeading", (IModel)new ResourceModel("heading.section.twitter"))});
        twitterSectionHeadingContainer.add(new Component[]{new Label("twitterSectionText", (IModel)new ResourceModel("preferences.twitter.message"))});
        form.add(new Component[]{twitterSectionHeadingContainer});
        if (this.sakaiProxy.isTwitterIntegrationEnabledGlobally()) {
            form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        } else {
            form.add(new Component[]{new EmptyPanel("twitterPanel")});
            twitterSectionHeadingContainer.setVisible(false);
        }
        WebMarkupContainer is = new WebMarkupContainer("imageSettingsContainer");
        is.setOutputMarkupId(true);
        is.add(new Component[]{new Label("imageSettingsHeading", (IModel)new ResourceModel("heading.section.image"))});
        is.add(new Component[]{new Label("imageSettingsText", (IModel)new ResourceModel("preferences.image.message"))});
        WebMarkupContainer officialImageContainer = new WebMarkupContainer("officialImageContainer");
        officialImageContainer.add(new Component[]{new Label("officialImageLabel", (IModel)new ResourceModel("preferences.image.official"))});
        this.officialImage = new CheckBox("officialImage", (IModel)new PropertyModel((Object)preferencesModel, "useOfficialImage"));
        this.officialImage.setOutputMarkupId(true);
        officialImageContainer.add(new Component[]{this.officialImage});
        this.officialImage.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        is.add(new Component[]{officialImageContainer});
        boolean officialImageEnabled = this.sakaiProxy.isUsingOfficialImageButAlternateSelectionEnabled();
        if (!officialImageEnabled) {
            this.profilePreferences.setUseOfficialImage(false);
            officialImageContainer.setVisible(false);
        }
        WebMarkupContainer gravatarContainer = new WebMarkupContainer("gravatarContainer");
        gravatarContainer.add(new Component[]{new Label("gravatarLabel", (IModel)new ResourceModel("preferences.image.gravatar"))});
        this.gravatarImage = new CheckBox("gravatarImage", (IModel)new PropertyModel((Object)preferencesModel, "useGravatar"));
        gravatarContainer.add(new Component[]{this.gravatarImage});
        this.gravatarImage.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        is.add(new Component[]{gravatarContainer});
        boolean gravatarEnabled = this.sakaiProxy.isGravatarImageEnabledGlobally();
        if (!gravatarEnabled) {
            this.profilePreferences.setUseGravatar(false);
            gravatarContainer.setVisible(false);
        }
        if (!officialImageEnabled && !gravatarEnabled) {
            is.setVisible(false);
        }
        form.add(new Component[]{is});
        WebMarkupContainer ws = new WebMarkupContainer("widgetSettingsContainer");
        ws.setOutputMarkupId(true);
        ws.add(new Component[]{new Label("widgetSettingsHeading", (IModel)new ResourceModel("heading.section.widget"))});
        ws.add(new Component[]{new Label("widgetSettingsText", (IModel)new ResourceModel("preferences.widget.message"))});
        WebMarkupContainer kudosContainer = new WebMarkupContainer("kudosContainer");
        kudosContainer.add(new Component[]{new Label("kudosLabel", (IModel)new ResourceModel("preferences.widget.kudos"))});
        CheckBox kudosSetting = new CheckBox("kudosSetting", (IModel)new PropertyModel((Object)preferencesModel, "showKudos"));
        kudosContainer.add(new Component[]{kudosSetting});
        kudosContainer.add(new Component[]{new IconWithClueTip("kudosToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("preferences.widget.kudos.tooltip"))});
        kudosSetting.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        ws.add(new Component[]{kudosContainer});
        WebMarkupContainer galleryFeedContainer = new WebMarkupContainer("galleryFeedContainer");
        galleryFeedContainer.add(new Component[]{new Label("galleryFeedLabel", (IModel)new ResourceModel("preferences.widget.gallery"))});
        CheckBox galleryFeedSetting = new CheckBox("galleryFeedSetting", (IModel)new PropertyModel((Object)preferencesModel, "showGalleryFeed"));
        galleryFeedContainer.add(new Component[]{galleryFeedSetting});
        galleryFeedContainer.add(new Component[]{new IconWithClueTip("galleryFeedToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("preferences.widget.gallery.tooltip"))});
        galleryFeedSetting.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        ws.add(new Component[]{galleryFeedContainer});
        galleryFeedContainer.setVisible(this.sakaiProxy.isProfileGalleryEnabledGlobally());
        WebMarkupContainer onlineStatusContainer = new WebMarkupContainer("onlineStatusContainer");
        onlineStatusContainer.add(new Component[]{new Label("onlineStatusLabel", (IModel)new ResourceModel("preferences.widget.onlinestatus"))});
        CheckBox onlineStatusSetting = new CheckBox("onlineStatusSetting", (IModel)new PropertyModel((Object)preferencesModel, "showOnlineStatus"));
        onlineStatusContainer.add(new Component[]{onlineStatusSetting});
        onlineStatusContainer.add(new Component[]{new IconWithClueTip("onlineStatusToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("preferences.widget.onlinestatus.tooltip"))});
        onlineStatusSetting.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        ws.add(new Component[]{onlineStatusContainer});
        form.add(new Component[]{ws});
        13 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.setModel((IModel)new ResourceModel("button.save.settings"));
        submitButton.setDefaultFormProcessing(false);
        form.add(new Component[]{submitButton});
        this.add(new Component[]{form});
    }

    static /* synthetic */ CheckBox access$000(MyPreferences x0) {
        return x0.gravatarImage;
    }

    static /* synthetic */ CheckBox access$100(MyPreferences x0) {
        return x0.officialImage;
    }
}

