/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.tabs.AjaxTabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.CompanyProfile;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.components.TextareaTinyMceSettings;
import org.sakaiproject.profile2.tool.pages.panels.MyBusinessEdit;
import org.sakaiproject.profile2.tool.pages.panels.MyInterestsEdit;
import wicket.contrib.tinymce.TinyMceBehavior;
import wicket.contrib.tinymce.ajax.TinyMceAjaxSubmitModifier;
import wicket.contrib.tinymce.settings.TinyMCESettings;

public class MyBusinessEdit
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyInterestsEdit.class);
    private AjaxTabbedPanel companyProfileTabs;
    private List<CompanyProfile> companyProfilesToAdd = null;
    private List<CompanyProfile> companyProfilesToRemove = null;
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    private ProfileLogic profileLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;

    public MyBusinessEdit(String id, UserProfile userProfile) {
        this(id, userProfile, new ArrayList(), new ArrayList(), TabDisplay.START);
    }

    public MyBusinessEdit(String id, UserProfile userProfile, List<CompanyProfile> companyProfilesToAdd, List<CompanyProfile> companyProfilesToRemove, TabDisplay tabDisplay) {
        super(id);
        log.debug((Object)"MyBusinessEdit()");
        this.companyProfilesToAdd = companyProfilesToAdd;
        this.companyProfilesToRemove = companyProfilesToRemove;
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.business.edit"))});
        Form form = new Form("form", (IModel)new Model((Serializable)userProfile));
        form.setOutputMarkupId(true);
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        Label editWarning = new Label("editWarning");
        editWarning.setVisible(false);
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userProfile.getUserUuid())) {
            editWarning.setDefaultModel((IModel)new StringResourceModel("text.edit.other.warning", null, new Object[]{userProfile.getDisplayName()}));
            editWarning.setEscapeModelStrings(false);
            editWarning.setVisible(true);
        }
        form.add(new Component[]{editWarning});
        WebMarkupContainer businessBiographyContainer = new WebMarkupContainer("businessBiographyContainer");
        businessBiographyContainer.add(new Component[]{new Label("businessBiographyLabel", (IModel)new ResourceModel("profile.business.bio"))});
        TextArea businessBiography = new TextArea("businessBiography", (IModel)new PropertyModel((Object)userProfile, "businessBiography"));
        businessBiography.add(new IBehavior[]{new TinyMceBehavior((TinyMCESettings)new TextareaTinyMceSettings())});
        businessBiographyContainer.add(new Component[]{businessBiography});
        form.add(new Component[]{businessBiographyContainer});
        WebMarkupContainer companyProfileEditsContainer = this.createCompanyProfileEditsContainer(userProfile, tabDisplay);
        form.add(new Component[]{companyProfileEditsContainer});
        AjaxFallbackButton addCompanyProfileButton = this.createAddCompanyProfileButton(id, userProfile, form, formFeedback);
        form.add(new Component[]{addCompanyProfileButton});
        AjaxFallbackButton removeCompanyProfileButton = this.createRemoveCompanyProfileButton(id, userProfile, form);
        form.add(new Component[]{removeCompanyProfileButton});
        AjaxFallbackButton submitButton = this.createSaveChangesButton(id, userProfile, form, formFeedback);
        submitButton.add(new IBehavior[]{new TinyMceAjaxSubmitModifier()});
        form.add(new Component[]{submitButton});
        AjaxFallbackButton cancelButton = this.createCancelChangesButton(id, userProfile, form);
        form.add(new Component[]{cancelButton});
        this.add(new Component[]{form});
    }

    private AjaxFallbackButton createCancelChangesButton(String id, UserProfile userProfile, Form form) {
        1 cancelButton = new /* Unavailable Anonymous Inner Class!! */;
        cancelButton.setDefaultFormProcessing(false);
        return cancelButton;
    }

    private AjaxFallbackButton createSaveChangesButton(String id, UserProfile userProfile, Form form, Label formFeedback) {
        2 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        return submitButton;
    }

    private AjaxFallbackButton createRemoveCompanyProfileButton(String id, UserProfile userProfile, Form form) {
        3 removeCompanyProfileButton = new /* Unavailable Anonymous Inner Class!! */;
        return removeCompanyProfileButton;
    }

    private AjaxFallbackButton createAddCompanyProfileButton(String id, UserProfile userProfile, Form form, Label formFeedback) {
        4 addCompanyProfileButton = new /* Unavailable Anonymous Inner Class!! */;
        return addCompanyProfileButton;
    }

    private WebMarkupContainer createCompanyProfileEditsContainer(UserProfile userProfile, TabDisplay tabDisplay) {
        WebMarkupContainer companyProfilesContainer = new WebMarkupContainer("companyProfilesContainer");
        companyProfilesContainer.add(new Component[]{new Label("companyProfilesLabel", (IModel)new ResourceModel("profile.business.company.profiles"))});
        ArrayList<5> tabs = new ArrayList<5>();
        if (null != userProfile.getCompanyProfiles()) {
            for (CompanyProfile companyProfile : userProfile.getCompanyProfiles()) {
                tabs.add(new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        this.companyProfileTabs = new AjaxTabbedPanel("companyProfiles", tabs);
        companyProfilesContainer.add(new Component[]{this.companyProfileTabs});
        if (tabs.size() > 0) {
            switch (6.$SwitchMap$org$sakaiproject$profile2$tool$pages$panels$MyBusinessEdit$TabDisplay[tabDisplay.ordinal()]) {
                case 1: {
                    this.companyProfileTabs.setSelectedTab(0);
                    break;
                }
                case 2: {
                    this.companyProfileTabs.setSelectedTab(tabs.size() - 1);
                }
            }
        } else {
            companyProfilesContainer.setVisible(false);
        }
        return companyProfilesContainer;
    }

    private boolean save(Form form) {
        UserProfile userProfile = (UserProfile)form.getModelObject();
        String userId = userProfile.getUserUuid();
        SakaiPerson sakaiPerson = this.sakaiProxy.getSakaiPerson(userId);
        sakaiPerson.setBusinessBiography(userProfile.getBusinessBiography());
        for (CompanyProfile companyProfile : this.companyProfilesToAdd) {
            if (this.profileLogic.addNewCompanyProfile(companyProfile)) continue;
            log.info((Object)("Couldn't add CompanyProfile for: " + userId));
            return false;
        }
        for (CompanyProfile companyProfile : userProfile.getCompanyProfiles()) {
            if (this.profileLogic.updateCompanyProfile(companyProfile)) continue;
            log.info((Object)("Couldn't save CompanyProfile for: " + userId));
            return false;
        }
        for (CompanyProfile companyProfile : this.companyProfilesToRemove) {
            if (this.profileLogic.removeCompanyProfile(userId, companyProfile.getId())) continue;
            log.info((Object)("Couldn't delete CompanyProfile for: " + userId));
            return false;
        }
        if (this.profileLogic.saveUserProfile(sakaiPerson)) {
            log.info((Object)("Saved SakaiPerson for: " + userId));
            return true;
        }
        log.info((Object)("Couldn't save SakaiPerson for: " + userId));
        return false;
    }

    static /* synthetic */ List access$000(MyBusinessEdit x0) {
        return x0.companyProfilesToAdd;
    }

    static /* synthetic */ List access$100(MyBusinessEdit x0) {
        return x0.companyProfilesToRemove;
    }

    static /* synthetic */ boolean access$200(MyBusinessEdit x0, Form x1) {
        return x0.save(x1);
    }

    static /* synthetic */ SakaiProxy access$300(MyBusinessEdit x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$400(MyBusinessEdit x0) {
        return x0.wallLogic;
    }

    static /* synthetic */ AjaxTabbedPanel access$500(MyBusinessEdit x0) {
        return x0.companyProfileTabs;
    }
}

