/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.pages.panels.MySocialNetworkingDisplay;

public class MySocialNetworkingDisplay
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MySocialNetworkingDisplay.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;

    public MySocialNetworkingDisplay(String id, UserProfile userProfile) {
        super(id);
        log.debug((Object)"MySocialNetworkingDisplay()");
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.social"))});
        String facebookUrl = userProfile.getSocialInfo().getFacebookUrl();
        String linkedinUrl = userProfile.getSocialInfo().getLinkedinUrl();
        String myspaceUrl = userProfile.getSocialInfo().getMyspaceUrl();
        String skypeUsername = userProfile.getSocialInfo().getSkypeUsername();
        String twitterUrl = userProfile.getSocialInfo().getTwitterUrl();
        int visibleFieldCount = 0;
        WebMarkupContainer facebookContainer = new WebMarkupContainer("facebookContainer");
        facebookContainer.add(new Component[]{new Label("facebookLabel", (IModel)new ResourceModel("profile.socialnetworking.facebook"))});
        facebookContainer.add(new Component[]{new ExternalLink("facebookLink", facebookUrl, facebookUrl)});
        this.add(new Component[]{facebookContainer});
        if (StringUtils.isBlank((String)facebookUrl)) {
            facebookContainer.setVisible(false);
        } else {
            ++visibleFieldCount;
        }
        WebMarkupContainer linkedinContainer = new WebMarkupContainer("linkedinContainer");
        linkedinContainer.add(new Component[]{new Label("linkedinLabel", (IModel)new ResourceModel("profile.socialnetworking.linkedin"))});
        linkedinContainer.add(new Component[]{new ExternalLink("linkedinLink", linkedinUrl, linkedinUrl)});
        this.add(new Component[]{linkedinContainer});
        if (StringUtils.isBlank((String)linkedinUrl)) {
            linkedinContainer.setVisible(false);
        } else {
            ++visibleFieldCount;
        }
        WebMarkupContainer myspaceContainer = new WebMarkupContainer("myspaceContainer");
        myspaceContainer.add(new Component[]{new Label("myspaceLabel", (IModel)new ResourceModel("profile.socialnetworking.myspace"))});
        myspaceContainer.add(new Component[]{new ExternalLink("myspaceLink", myspaceUrl, myspaceUrl)});
        this.add(new Component[]{myspaceContainer});
        if (StringUtils.isBlank((String)myspaceUrl)) {
            myspaceContainer.setVisible(false);
        } else {
            ++visibleFieldCount;
        }
        WebMarkupContainer twitterContainer = new WebMarkupContainer("twitterContainer");
        twitterContainer.add(new Component[]{new Label("twitterLabel", (IModel)new ResourceModel("profile.socialnetworking.twitter"))});
        twitterContainer.add(new Component[]{new ExternalLink("twitterLink", twitterUrl, twitterUrl)});
        this.add(new Component[]{twitterContainer});
        if (StringUtils.isBlank((String)twitterUrl)) {
            twitterContainer.setVisible(false);
        } else {
            ++visibleFieldCount;
        }
        WebMarkupContainer skypeContainer = new WebMarkupContainer("skypeContainer");
        skypeContainer.add(new Component[]{new Label("skypeLabel", (IModel)new ResourceModel("profile.socialnetworking.skype"))});
        skypeContainer.add(new Component[]{new Label("skypeLink", skypeUsername)});
        this.add(new Component[]{skypeContainer});
        if (StringUtils.isBlank((String)skypeUsername)) {
            skypeContainer.setVisible(false);
        } else {
            ++visibleFieldCount;
        }
        1 editButton = new /* Unavailable Anonymous Inner Class!! */;
        editButton.add(new Component[]{new Label("editButtonLabel", (IModel)new ResourceModel("button.edit"))});
        editButton.setOutputMarkupId(true);
        if (userProfile.isLocked() && !this.sakaiProxy.isSuperUser()) {
            editButton.setVisible(false);
        }
        this.add(new Component[]{editButton});
        Label noFieldsMessage = new Label("noFieldsMessage", (IModel)new ResourceModel("text.no.fields"));
        this.add(new Component[]{noFieldsMessage});
        if (visibleFieldCount > 0) {
            noFieldsMessage.setVisible(false);
        }
    }
}

