/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.pages.panels.MyInterestsEdit;
import wicket.contrib.tinymce.ajax.TinyMceAjaxSubmitModifier;

public class MyInterestsEdit
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyInterestsEdit.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    private ProfileLogic profileLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;

    public MyInterestsEdit(String id, UserProfile userProfile) {
        super(id);
        log.debug((Object)"MyInterestsEdit()");
        MyInterestsEdit thisPanel = this;
        String userId = userProfile.getUserUuid();
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.interests.edit"))});
        Form form = new Form("form", (IModel)new Model((Serializable)userProfile));
        form.setOutputMarkupId(true);
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        Label editWarning = new Label("editWarning");
        editWarning.setVisible(false);
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userId)) {
            editWarning.setDefaultModel((IModel)new StringResourceModel("text.edit.other.warning", null, new Object[]{userProfile.getDisplayName()}));
            editWarning.setEscapeModelStrings(false);
            editWarning.setVisible(true);
        }
        form.add(new Component[]{editWarning});
        WebMarkupContainer booksContainer = new WebMarkupContainer("booksContainer");
        booksContainer.add(new Component[]{new Label("booksLabel", (IModel)new ResourceModel("profile.favourite.books"))});
        TextArea favouriteBooks = new TextArea("favouriteBooks", (IModel)new PropertyModel((Object)userProfile, "favouriteBooks"));
        booksContainer.add(new Component[]{favouriteBooks});
        form.add(new Component[]{booksContainer});
        WebMarkupContainer tvContainer = new WebMarkupContainer("tvContainer");
        tvContainer.add(new Component[]{new Label("tvLabel", (IModel)new ResourceModel("profile.favourite.tv"))});
        TextArea favouriteTvShows = new TextArea("favouriteTvShows", (IModel)new PropertyModel((Object)userProfile, "favouriteTvShows"));
        tvContainer.add(new Component[]{favouriteTvShows});
        form.add(new Component[]{tvContainer});
        WebMarkupContainer moviesContainer = new WebMarkupContainer("moviesContainer");
        moviesContainer.add(new Component[]{new Label("moviesLabel", (IModel)new ResourceModel("profile.favourite.movies"))});
        TextArea favouriteMovies = new TextArea("favouriteMovies", (IModel)new PropertyModel((Object)userProfile, "favouriteMovies"));
        moviesContainer.add(new Component[]{favouriteMovies});
        form.add(new Component[]{moviesContainer});
        WebMarkupContainer quotesContainer = new WebMarkupContainer("quotesContainer");
        quotesContainer.add(new Component[]{new Label("quotesLabel", (IModel)new ResourceModel("profile.favourite.quotes"))});
        TextArea favouriteQuotes = new TextArea("favouriteQuotes", (IModel)new PropertyModel((Object)userProfile, "favouriteQuotes"));
        quotesContainer.add(new Component[]{favouriteQuotes});
        form.add(new Component[]{quotesContainer});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.add(new IBehavior[]{new TinyMceAjaxSubmitModifier()});
        form.add(new Component[]{submitButton});
        2 cancelButton = new /* Unavailable Anonymous Inner Class!! */;
        cancelButton.setDefaultFormProcessing(false);
        form.add(new Component[]{cancelButton});
        this.add(new Component[]{form});
    }

    private boolean save(Form form) {
        UserProfile userProfile = (UserProfile)form.getModelObject();
        String userId = userProfile.getUserUuid();
        SakaiPerson sakaiPerson = this.sakaiProxy.getSakaiPerson(userId);
        sakaiPerson.setFavouriteBooks(userProfile.getFavouriteBooks());
        sakaiPerson.setFavouriteTvShows(userProfile.getFavouriteTvShows());
        sakaiPerson.setFavouriteMovies(userProfile.getFavouriteMovies());
        sakaiPerson.setFavouriteQuotes(userProfile.getFavouriteQuotes());
        if (this.profileLogic.saveUserProfile(sakaiPerson)) {
            log.info((Object)("Saved SakaiPerson for: " + userId));
            return true;
        }
        log.info((Object)("Couldn't save SakaiPerson for: " + userId));
        return false;
    }

    static /* synthetic */ boolean access$000(MyInterestsEdit x0, Form x1) {
        return x0.save(x1);
    }

    static /* synthetic */ SakaiProxy access$100(MyInterestsEdit x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$200(MyInterestsEdit x0) {
        return x0.wallLogic;
    }
}

