/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.WallItem;
import org.sakaiproject.profile2.tool.components.ErrorLevelsFeedbackMessageFilter;
import org.sakaiproject.profile2.tool.components.TextareaTinyMceSettings;
import org.sakaiproject.profile2.tool.dataproviders.WallItemDataProvider;
import org.sakaiproject.profile2.tool.pages.MyProfile;
import org.sakaiproject.profile2.tool.pages.panels.MyWallPanel;
import wicket.contrib.tinymce.TinyMceBehavior;
import wicket.contrib.tinymce.ajax.TinyMceAjaxSubmitModifier;
import wicket.contrib.tinymce.settings.TinyMCESettings;

public class MyWallPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyWallPanel.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;

    public MyWallPanel(String panelId, String userUuid) {
        super(panelId);
        if (!this.sakaiProxy.isSuperUser()) {
            log.error((Object)("MyWallPanel: user " + this.sakaiProxy.getCurrentUserId() + " attempted to access MyWallPanel for " + userUuid + ". Redirecting..."));
            throw new RestartResponseException((Page)new MyProfile());
        }
        this.renderWallPanel(userUuid);
    }

    public MyWallPanel(String panelId) {
        super(panelId);
        this.renderWallPanel(this.sakaiProxy.getCurrentUserId());
    }

    private void renderWallPanel(String userUuid) {
        this.setOutputMarkupId(true);
        WebMarkupContainer wallItemsContainer = new WebMarkupContainer("wallItemsContainer");
        wallItemsContainer.setOutputMarkupId(true);
        this.add(new Component[]{wallItemsContainer});
        WallItem wallItem = new WallItem();
        wallItem.setUserUuid(userUuid);
        wallItem.setCreatorUuid(this.sakaiProxy.getCurrentUserId());
        wallItem.setType(2);
        Form form = new Form("myWallPostForm", (IModel)new Model((Serializable)wallItem));
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        FeedbackPanel feedback = new FeedbackPanel("feedback");
        feedback.setOutputMarkupId(true);
        form.add(new Component[]{feedback});
        int[] filteredErrorLevels = new int[]{400};
        feedback.setFilter((IFeedbackMessageFilter)new ErrorLevelsFeedbackMessageFilter(filteredErrorLevels));
        WebMarkupContainer myWallPostContainer = new WebMarkupContainer("myWallPostContainer");
        TextArea myWallPost = new TextArea("myWallPost", (IModel)new PropertyModel((Object)wallItem, "text"));
        myWallPost.add(new IBehavior[]{new TinyMceBehavior((TinyMCESettings)new TextareaTinyMceSettings(TinyMCESettings.Align.left))});
        myWallPostContainer.add(new Component[]{myWallPost});
        form.add(new Component[]{myWallPostContainer});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.setModel((IModel)new ResourceModel("button.wall.post"));
        submitButton.add(new IBehavior[]{new TinyMceAjaxSubmitModifier()});
        myWallPostContainer.add(new Component[]{submitButton});
        WallItemDataProvider provider = new WallItemDataProvider(userUuid);
        if (0 == provider.size()) {
            this.add(new Component[]{new Label("wallInformationMessage", (IModel)new ResourceModel("text.wall.no.items"))});
        } else {
            this.add(new Component[]{new Label("wallInformationMessage")});
        }
        2 wallItemsDataView = new /* Unavailable Anonymous Inner Class!! */;
        wallItemsDataView.setOutputMarkupId(true);
        if (provider.size() <= 10) {
            wallItemsContainer.add(new Component[]{new AjaxPagingNavigator("navigator", (IPageable)wallItemsDataView).setVisible(false)});
        } else {
            wallItemsContainer.add(new Component[]{new AjaxPagingNavigator("navigator", (IPageable)wallItemsDataView)});
        }
        wallItemsDataView.setItemsPerPage(10);
        wallItemsContainer.add(new Component[]{wallItemsDataView});
    }

    private boolean save(Form form, String userUuid) {
        WallItem wallItem = (WallItem)form.getModelObject();
        wallItem.setDate(new Date());
        return this.wallLogic.postWallItemToWall(userUuid, wallItem);
    }

    protected void replaceSelf(AjaxRequestTarget target, String userUuid) {
        MyWallPanel newPanel = true == this.sakaiProxy.isSuperUser() ? new MyWallPanel(this.getId(), userUuid) : new MyWallPanel(this.getId());
        newPanel.setOutputMarkupId(true);
        this.replaceWith((Component)newPanel);
        if (null != target) {
            target.addComponent((Component)newPanel);
            target.appendJavascript("setMainFrameHeight(window.name);");
        }
    }

    static /* synthetic */ boolean access$000(MyWallPanel x0, Form x1, String x2) {
        return x0.save(x1, x2);
    }
}

