/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages;

import java.io.Serializable;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileExternalIntegrationLogic;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfileKudosLogic;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileMessagingLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.ProfileSearchLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.tool.components.LocaleAwareHtmlTag;
import org.sakaiproject.profile2.util.ProfileUtils;
import wicket.contrib.tinymce.settings.TinyMCESettings;

public class BasePage
extends WebPage
implements IHeaderContributor {
    private static final Logger log = Logger.getLogger(BasePage.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    protected SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    protected ProfileLogic profileLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePreferencesLogic")
    protected ProfilePreferencesLogic preferencesLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePrivacyLogic")
    protected ProfilePrivacyLogic privacyLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileConnectionsLogic")
    protected ProfileConnectionsLogic connectionsLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileMessagingLogic")
    protected ProfileMessagingLogic messagingLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileImageLogic")
    protected ProfileImageLogic imageLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileKudosLogic")
    protected ProfileKudosLogic kudosLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileExternalIntegrationLogic")
    protected ProfileExternalIntegrationLogic externalIntegrationLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    protected ProfileWallLogic wallLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileSearchLogic")
    protected ProfileSearchLogic searchLogic;
    Link<Void> myPicturesLink;
    Link<Void> myProfileLink;
    Link<Void> myFriendsLink;
    Link<Void> myMessagesLink;
    Link<Void> myPrivacyLink;
    Link<Void> searchLink;
    Link<Void> preferencesLink;

    public BasePage() {
        log.debug((Object)"BasePage()");
        this.setUserPreferredLocale();
        this.add(new Component[]{new LocaleAwareHtmlTag("html")});
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        this.myProfileLink = new /* Unavailable Anonymous Inner Class!! */;
        this.myProfileLink.add(new Component[]{new Label("myProfileLabel", (IModel)new ResourceModel("link.my.profile"))});
        this.myProfileLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.my.profile.tooltip"))});
        this.add(new Component[]{this.myProfileLink});
        this.myPicturesLink = new /* Unavailable Anonymous Inner Class!! */;
        this.myPicturesLink.add(new Component[]{new Label("myPicturesLabel", (IModel)new ResourceModel("link.my.pictures"))});
        this.myPicturesLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.my.pictures.tooltip"))});
        if (!this.sakaiProxy.isProfileGalleryEnabledGlobally()) {
            this.myPicturesLink.setVisible(false);
        }
        this.add(new Component[]{this.myPicturesLink});
        this.myFriendsLink = new /* Unavailable Anonymous Inner Class!! */;
        this.myFriendsLink.add(new Component[]{new Label("myFriendsLabel", (IModel)new ResourceModel("link.my.friends"))});
        this.myFriendsLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.my.friends.tooltip"))});
        int newRequestsCount = this.connectionsLogic.getConnectionRequestsForUserCount(currentUserUuid);
        Label newRequestsLabel = new Label("newRequestsLabel", (IModel)new Model((Serializable)Integer.valueOf(newRequestsCount)));
        this.myFriendsLink.add(new Component[]{newRequestsLabel});
        if (newRequestsCount == 0) {
            newRequestsLabel.setVisible(false);
        }
        this.add(new Component[]{this.myFriendsLink});
        this.myMessagesLink = new /* Unavailable Anonymous Inner Class!! */;
        this.myMessagesLink.add(new Component[]{new Label("myMessagesLabel", (IModel)new ResourceModel("link.my.messages"))});
        this.myMessagesLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.my.messages.tooltip"))});
        int newMessagesCount = this.messagingLogic.getThreadsWithUnreadMessagesCount(currentUserUuid);
        Label newMessagesLabel = new Label("newMessagesLabel", (IModel)new Model((Serializable)Integer.valueOf(newMessagesCount)));
        this.myMessagesLink.add(new Component[]{newMessagesLabel});
        if (newMessagesCount == 0) {
            newMessagesLabel.setVisible(false);
        }
        this.add(new Component[]{this.myMessagesLink});
        this.myPrivacyLink = new /* Unavailable Anonymous Inner Class!! */;
        this.myPrivacyLink.add(new Component[]{new Label("myPrivacyLabel", (IModel)new ResourceModel("link.my.privacy"))});
        this.myPrivacyLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.my.privacy.tooltip"))});
        this.add(new Component[]{this.myPrivacyLink});
        this.searchLink = new /* Unavailable Anonymous Inner Class!! */;
        this.searchLink.add(new Component[]{new Label("searchLabel", (IModel)new ResourceModel("link.my.search"))});
        this.searchLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.my.search.tooltip"))});
        this.add(new Component[]{this.searchLink});
        this.preferencesLink = new /* Unavailable Anonymous Inner Class!! */;
        this.preferencesLink.add(new Component[]{new Label("preferencesLabel", (IModel)new ResourceModel("link.my.preferences"))});
        this.preferencesLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.my.preferences.tooltip"))});
        this.add(new Component[]{this.preferencesLink});
    }

    public void renderHead(IHeaderResponse response) {
        HttpServletRequest request = this.getWebRequestCycle().getWebRequest().getHttpServletRequest();
        response.renderString((CharSequence)((String)request.getAttribute("sakai.html.head")));
        response.renderOnLoadJavascript("setMainFrameHeight( window.name )");
        response.renderJavascriptReference("javascript/jquery-1.4.4.min.js");
        response.renderCSSReference("css/flora.datepicker.css");
        response.renderJavascriptReference("javascript/jquery.ui.core-1.5.2.min.js");
        response.renderJavascriptReference("javascript/jquery.datepicker-1.5.2.min.js");
        response.renderCSSReference("css/jquery.cluetip.css");
        response.renderJavascriptReference("javascript/jquery.dimensions.js");
        response.renderJavascriptReference("javascript/jquery.hoverIntent.min.js");
        response.renderJavascriptReference("javascript/jquery.cluetip.js");
        response.renderJavascriptReference(TinyMCESettings.javaScriptReference());
        response.renderJavascriptReference("javascript/jquery.i18n.properties-min.js");
        response.renderJavascriptReference("javascript/jquery.apTextCounter.min.js");
        response.renderString((CharSequence)"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        response.renderCSSReference("css/profile2.css");
        response.renderJavascriptReference("javascript/profile2.js");
    }

    public void setUserPreferredLocale() {
        Locale locale = ProfileUtils.getUserPreferredLocale();
        log.debug((Object)("User preferred locale: " + locale));
        this.getSession().setLocale(locale);
    }

    protected void disableLink(Link<Void> l) {
        l.add(new IBehavior[]{new AttributeAppender("class", (IModel)new Model((Serializable)((Object)"current")), " ")});
        l.setEnabled(false);
    }

    protected void setTabCookie(int tabIndex) {
        Cookie tabCookie = new Cookie("profile2-tab", "" + tabIndex);
        tabCookie.setMaxAge(-1);
        this.getWebRequestCycle().getWebResponse().addCookie(tabCookie);
    }
}

