/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages;

import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.data.GridView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.sakaiproject.profile2.tool.components.ErrorLevelsFeedbackMessageFilter;
import org.sakaiproject.profile2.tool.dataproviders.GalleryImageDataProvider;
import org.sakaiproject.profile2.tool.pages.BasePage;
import org.sakaiproject.profile2.tool.pages.ViewPictures;

public class ViewPictures
extends BasePage {
    private static final Logger log = Logger.getLogger(ViewPictures.class);
    private GridView gridView;

    public ViewPictures(String userUuid) {
        log.debug((Object)"ViewPictures()");
        this.configureFeedback();
        this.createGalleryForm(userUuid);
    }

    private void createGalleryForm(String userUuid) {
        Label galleryHeading = new Label("galleryHeading", (IModel)new StringResourceModel("heading.pictures.view.pictures", null, new Object[]{this.sakaiProxy.getUserDisplayName(userUuid)}));
        this.add(new Component[]{galleryHeading});
        1 galleryForm = new /* Unavailable Anonymous Inner Class!! */;
        galleryForm.setOutputMarkupId(true);
        this.populateGallery((Form)galleryForm, userUuid);
        this.add(new Component[]{galleryForm});
    }

    private void populateGallery(Form galleryForm, String userUuid) {
        GalleryImageDataProvider dataProvider = new GalleryImageDataProvider(userUuid);
        int numImages = dataProvider.size();
        this.gridView = new /* Unavailable Anonymous Inner Class!! */;
        this.gridView.setRows(3);
        this.gridView.setColumns(4);
        galleryForm.add(new Component[]{this.gridView});
        if (numImages == 0) {
            galleryForm.add(new Component[]{new PagingNavigator("navigator", (IPageable)this.gridView).setVisible(false)});
        } else if (numImages <= 12) {
            galleryForm.add(new Component[]{new PagingNavigator("navigator", (IPageable)this.gridView).setVisible(false)});
        } else {
            galleryForm.add(new Component[]{new PagingNavigator("navigator", (IPageable)this.gridView)});
        }
    }

    private void configureFeedback() {
        FeedbackPanel feedback = new FeedbackPanel("feedback");
        feedback.setOutputMarkupId(true);
        this.add(new Component[]{feedback});
        int[] filteredErrorLevels = new int[]{400};
        feedback.setFilter((IFeedbackMessageFilter)new ErrorLevelsFeedbackMessageFilter(filteredErrorLevels));
    }
}

