/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.MultiFileUploadField;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.repeater.data.GridView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.file.Folder;
import org.sakaiproject.profile2.tool.components.IconWithClueTip;
import org.sakaiproject.profile2.tool.dataproviders.GalleryImageDataProvider;
import org.sakaiproject.profile2.tool.pages.BasePage;
import org.sakaiproject.profile2.tool.pages.MyPictures;

public class MyPictures
extends BasePage {
    private static final Logger log = Logger.getLogger(MyPictures.class);
    private List<File> addPictureFiles = new ArrayList();
    private FileListView addPictureListView;
    private Folder addPictureUploadFolder;
    private GridView gridView;

    public MyPictures() {
        this.renderMyPictures(0, this.sakaiProxy.getCurrentUserId());
    }

    public MyPictures(int pageToDisplay) {
        this.renderMyPictures(pageToDisplay, this.sakaiProxy.getCurrentUserId());
    }

    private void renderMyPictures(int pageToDisplay, String userUuid) {
        log.debug((Object)"MyPictures()");
        this.disableLink(this.myPicturesLink);
        this.createGalleryForm(userUuid, pageToDisplay);
        this.createAddPictureForm(userUuid);
    }

    private void createAddPictureForm(String userUuid) {
        this.addPictureUploadFolder = new Folder(System.getProperty("java.io.tmpdir"), "addPicturesUploadFolder");
        this.addPictureUploadFolder.mkdirs();
        FeedbackPanel fileFeedback = new FeedbackPanel("fileFeedback");
        fileFeedback.setOutputMarkupId(true);
        FileUploadForm addPictureForm = new FileUploadForm(this, "form", userUuid, fileFeedback);
        addPictureForm.add(new Component[]{fileFeedback});
        addPictureForm.setOutputMarkupId(true);
        this.add(new Component[]{addPictureForm});
        Label invalidFileTypeMessageLabel = new Label("invalidFileTypeMessage", (IModel)new ResourceModel("pictures.filetypewarning"));
        invalidFileTypeMessageLabel.setMarkupId("invalidFileTypeMessage");
        invalidFileTypeMessageLabel.setOutputMarkupId(true);
        addPictureForm.add(new Component[]{invalidFileTypeMessageLabel});
        WebMarkupContainer addPictureContainer = new WebMarkupContainer("addPictureContainer");
        addPictureContainer.add(new Component[]{new Label("addPictureLabel", (IModel)new ResourceModel("pictures.addpicture"))});
        addPictureContainer.add(new Component[]{new MultiFileUploadField("choosePicture", (IModel)new PropertyModel((Object)addPictureForm, "uploads"), 10)});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        addPictureContainer.add(new Component[]{submitButton});
        addPictureContainer.add(new Component[]{new IconWithClueTip("galleryImageUploadToolTip", "/library/image/silk/information.png", (IModel)new StringResourceModel("text.gallery.upload.tooltip", null, new Object[]{this.sakaiProxy.getMaxProfilePictureSize() * 10}))});
        addPictureForm.add(new Component[]{addPictureContainer});
        this.addPictureFiles.addAll(Arrays.asList(this.addPictureUploadFolder.listFiles()));
        this.addPictureListView = new FileListView(this, "fileList", this.addPictureFiles);
        addPictureForm.add(new Component[]{this.addPictureListView});
    }

    private void createGalleryForm(String userUuid, int pageToDisplay) {
        Label galleryHeading = new Label("galleryHeading", (IModel)new ResourceModel("heading.pictures.my.pictures"));
        this.add(new Component[]{galleryHeading});
        Form galleryForm = new Form("galleryForm");
        galleryForm.setOutputMarkupId(true);
        this.populateGallery(galleryForm, userUuid, pageToDisplay);
        this.add(new Component[]{galleryForm});
        Label addPictureHeading = new Label("addPictureHeading", (IModel)new ResourceModel("heading.pictures.addpicture"));
        this.add(new Component[]{addPictureHeading});
    }

    private void populateGallery(Form galleryForm, String userUuid, int pageToDisplay) {
        Label noPicturesLabel;
        GalleryImageDataProvider dataProvider = new GalleryImageDataProvider(userUuid);
        int numImages = dataProvider.size();
        this.gridView = new /* Unavailable Anonymous Inner Class!! */;
        this.gridView.setRows(3);
        this.gridView.setColumns(4);
        galleryForm.add(new Component[]{this.gridView});
        if (numImages == 0) {
            galleryForm.add(new Component[]{new PagingNavigator("navigator", (IPageable)this.gridView).setVisible(false)});
            noPicturesLabel = new Label("noPicturesLabel", (IModel)new ResourceModel("text.gallery.pictures.num.none"));
        } else if (numImages <= 12) {
            galleryForm.add(new Component[]{new PagingNavigator("navigator", (IPageable)this.gridView).setVisible(false)});
            noPicturesLabel = new Label("noPicturesLabel");
        } else {
            galleryForm.add(new Component[]{new PagingNavigator("navigator", (IPageable)this.gridView)});
            noPicturesLabel = new Label("noPicturesLabel");
        }
        galleryForm.add(new Component[]{noPicturesLabel});
        if (pageToDisplay > 0) {
            if (pageToDisplay < this.gridView.getPageCount()) {
                this.gridView.setCurrentPage(pageToDisplay);
            } else {
                this.gridView.setCurrentPage(this.gridView.getPageCount() - 1);
            }
        } else {
            this.gridView.setCurrentPage(0);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ GridView access$100(MyPictures x0) {
        return x0.gridView;
    }
}

