/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfilePreferencesLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ProfileImage;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.tool.components.CloseButton;
import org.sakaiproject.profile2.tool.models.StringModel;
import org.sakaiproject.profile2.tool.pages.MyProfile;
import org.sakaiproject.profile2.tool.pages.panels.ChangeProfilePictureUrl;

public class ChangeProfilePictureUrl
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ChangeProfilePictureUrl.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    private ProfileLogic profileLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileImageLogic")
    private ProfileImageLogic imageLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePreferencesLogic")
    protected ProfilePreferencesLogic preferencesLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePrivacyLogic")
    protected ProfilePrivacyLogic privacyLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;

    public ChangeProfilePictureUrl(String id) {
        super(id);
        log.debug((Object)"ChangeProfilePictureUpload()");
        String userUuid = this.sakaiProxy.getCurrentUserId();
        this.renderChangeProfilePictureUrl(userUuid);
    }

    public ChangeProfilePictureUrl(String id, String userUuid) {
        super(id);
        log.debug((Object)("ChangeProfilePictureUpload(" + userUuid + ")"));
        if (!this.sakaiProxy.isSuperUser()) {
            log.error((Object)("ChangeProfilePictureUrl: user " + this.sakaiProxy.getCurrentUserId() + " attempted to access ChangeProfilePictureUrl for " + userUuid + ". Redirecting..."));
            throw new RestartResponseException((Page)new MyProfile());
        }
        this.renderChangeProfilePictureUrl(userUuid);
    }

    private void renderChangeProfilePictureUrl(String userUuid) {
        ProfilePrivacy privacy;
        StringModel stringModel = new StringModel();
        ProfilePreferences prefs = this.preferencesLogic.getPreferencesRecordForUser(userUuid);
        ProfileImage profileImage = this.imageLogic.getProfileImage(userUuid, prefs, privacy = this.privacyLogic.getPrivacyRecordForUser(userUuid), 1);
        String externalUrl = profileImage.getExternalImageUrl();
        if (StringUtils.isNotBlank((String)externalUrl) && !StringUtils.equals((String)externalUrl, (String)this.imageLogic.getUnavailableImageURL())) {
            stringModel.setString(profileImage.getExternalImageUrl());
        }
        Form form = new Form("form", (IModel)new Model((Serializable)stringModel));
        form.setOutputMarkupId(true);
        Label editWarning = new Label("editWarning");
        editWarning.setVisible(false);
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userUuid)) {
            editWarning.setDefaultModel((IModel)new StringResourceModel("text.edit.other.warning", null, new Object[]{this.sakaiProxy.getUserDisplayName(userUuid)}));
            editWarning.setEscapeModelStrings(false);
            editWarning.setVisible(true);
        }
        form.add(new Component[]{editWarning});
        CloseButton closeButton = new CloseButton("closeButton", (Component)this);
        closeButton.setOutputMarkupId(true);
        form.add(new Component[]{closeButton});
        Label textEnterUrl = new Label("textEnterUrl", (IModel)new ResourceModel("text.image.url"));
        form.add(new Component[]{textEnterUrl});
        TextField urlField = new TextField("urlField", (IModel)new PropertyModel((Object)stringModel, "string"));
        urlField.setMarkupId("pictureurl");
        urlField.setOutputMarkupId(true);
        urlField.setRequired(true);
        urlField.add((IValidator)new UrlValidator(new String[]{"http", "https"}, 2));
        form.add(new Component[]{urlField});
        FeedbackPanel feedback = new FeedbackPanel("feedback");
        feedback.setOutputMarkupId(true);
        form.add(new Component[]{feedback});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.setModel((IModel)new ResourceModel("button.url.add"));
        form.add(new Component[]{submitButton});
        this.add(new Component[]{form});
    }

    static /* synthetic */ ProfileImageLogic access$000(ChangeProfilePictureUrl x0) {
        return x0.imageLogic;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ SakaiProxy access$200(ChangeProfilePictureUrl x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$300(ChangeProfilePictureUrl x0) {
        return x0.wallLogic;
    }
}

