/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.components.ComponentVisualErrorBehaviour;
import org.sakaiproject.profile2.tool.components.ErrorLevelsFeedbackMessageFilter;
import org.sakaiproject.profile2.tool.components.FeedbackLabel;
import org.sakaiproject.profile2.tool.components.PhoneNumberValidator;
import org.sakaiproject.profile2.tool.pages.panels.MyContactEdit;
import org.sakaiproject.profile2.tool.pages.panels.MyInfoEdit;

public class MyContactEdit
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyInfoEdit.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    private ProfileLogic profileLogic;

    public MyContactEdit(String id, UserProfile userProfile) {
        super(id);
        log.debug((Object)"MyContactEdit()");
        MyContactEdit thisPanel = this;
        String userId = userProfile.getUserUuid();
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.contact.edit"))});
        Form form = new Form("form", (IModel)new Model((Serializable)userProfile));
        form.setOutputMarkupId(true);
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        Label editWarning = new Label("editWarning");
        editWarning.setVisible(false);
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userId)) {
            editWarning.setDefaultModel((IModel)new StringResourceModel("text.edit.other.warning", null, new Object[]{userProfile.getDisplayName()}));
            editWarning.setEscapeModelStrings(false);
            editWarning.setVisible(true);
        }
        form.add(new Component[]{editWarning});
        FeedbackPanel feedback = new FeedbackPanel("feedback");
        feedback.setOutputMarkupId(true);
        form.add(new Component[]{feedback});
        int[] filteredErrorLevels = new int[]{400};
        feedback.setFilter((IFeedbackMessageFilter)new ErrorLevelsFeedbackMessageFilter(filteredErrorLevels));
        WebMarkupContainer emailContainer = new WebMarkupContainer("emailContainer");
        emailContainer.add(new Component[]{new Label("emailLabel", (IModel)new ResourceModel("profile.email"))});
        TextField email = new TextField("email", (IModel)new PropertyModel((Object)userProfile, "email"));
        email.setOutputMarkupId(true);
        email.setMarkupId("emailinput");
        email.add((IValidator)EmailAddressValidator.getInstance());
        Label emailReadOnly = new Label("emailReadOnly", (IModel)new PropertyModel((Object)userProfile, "email"));
        if (this.sakaiProxy.isAccountUpdateAllowed(userId)) {
            emailReadOnly.setVisible(false);
        } else {
            email.setVisible(false);
        }
        emailContainer.add(new Component[]{email});
        emailContainer.add(new Component[]{emailReadOnly});
        FeedbackLabel emailFeedback = new FeedbackLabel("emailFeedback", (Component)email);
        emailFeedback.setMarkupId("emailFeedback");
        emailFeedback.setOutputMarkupId(true);
        emailContainer.add(new Component[]{emailFeedback});
        email.add(new IBehavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)emailFeedback)});
        form.add(new Component[]{emailContainer});
        WebMarkupContainer homepageContainer = new WebMarkupContainer("homepageContainer");
        homepageContainer.add(new Component[]{new Label("homepageLabel", (IModel)new ResourceModel("profile.homepage"))});
        1 homepage = new /* Unavailable Anonymous Inner Class!! */;
        homepage.setMarkupId("homepageinput");
        homepage.setOutputMarkupId(true);
        homepage.add((IValidator)new UrlValidator());
        homepageContainer.add(new Component[]{homepage});
        FeedbackLabel homepageFeedback = new FeedbackLabel("homepageFeedback", (Component)homepage);
        homepageFeedback.setMarkupId("homepageFeedback");
        homepageFeedback.setOutputMarkupId(true);
        homepageContainer.add(new Component[]{homepageFeedback});
        homepage.add(new IBehavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)homepageFeedback)});
        form.add(new Component[]{homepageContainer});
        WebMarkupContainer workphoneContainer = new WebMarkupContainer("workphoneContainer");
        workphoneContainer.add(new Component[]{new Label("workphoneLabel", (IModel)new ResourceModel("profile.phone.work"))});
        TextField workphone = new TextField("workphone", (IModel)new PropertyModel((Object)userProfile, "workphone"));
        workphone.setMarkupId("workphoneinput");
        workphone.setOutputMarkupId(true);
        workphone.add((IValidator)new PhoneNumberValidator());
        workphoneContainer.add(new Component[]{workphone});
        FeedbackLabel workphoneFeedback = new FeedbackLabel("workphoneFeedback", (Component)workphone);
        workphoneFeedback.setMarkupId("workphoneFeedback");
        workphoneFeedback.setOutputMarkupId(true);
        workphoneContainer.add(new Component[]{workphoneFeedback});
        workphone.add(new IBehavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)workphoneFeedback)});
        form.add(new Component[]{workphoneContainer});
        WebMarkupContainer homephoneContainer = new WebMarkupContainer("homephoneContainer");
        homephoneContainer.add(new Component[]{new Label("homephoneLabel", (IModel)new ResourceModel("profile.phone.home"))});
        TextField homephone = new TextField("homephone", (IModel)new PropertyModel((Object)userProfile, "homephone"));
        homephone.setMarkupId("homephoneinput");
        homephone.setOutputMarkupId(true);
        homephone.add((IValidator)new PhoneNumberValidator());
        homephoneContainer.add(new Component[]{homephone});
        FeedbackLabel homephoneFeedback = new FeedbackLabel("homephoneFeedback", (Component)homephone);
        homephoneFeedback.setMarkupId("homephoneFeedback");
        homephoneFeedback.setOutputMarkupId(true);
        homephoneContainer.add(new Component[]{homephoneFeedback});
        homephone.add(new IBehavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)homephoneFeedback)});
        form.add(new Component[]{homephoneContainer});
        WebMarkupContainer mobilephoneContainer = new WebMarkupContainer("mobilephoneContainer");
        mobilephoneContainer.add(new Component[]{new Label("mobilephoneLabel", (IModel)new ResourceModel("profile.phone.mobile"))});
        TextField mobilephone = new TextField("mobilephone", (IModel)new PropertyModel((Object)userProfile, "mobilephone"));
        mobilephone.setMarkupId("mobilephoneinput");
        mobilephone.setOutputMarkupId(true);
        mobilephone.add((IValidator)new PhoneNumberValidator());
        mobilephoneContainer.add(new Component[]{mobilephone});
        FeedbackLabel mobilephoneFeedback = new FeedbackLabel("mobilephoneFeedback", (Component)mobilephone);
        mobilephoneFeedback.setMarkupId("mobilephoneFeedback");
        mobilephoneFeedback.setOutputMarkupId(true);
        mobilephoneContainer.add(new Component[]{mobilephoneFeedback});
        mobilephone.add(new IBehavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)mobilephoneFeedback)});
        form.add(new Component[]{mobilephoneContainer});
        WebMarkupContainer facsimileContainer = new WebMarkupContainer("facsimileContainer");
        facsimileContainer.add(new Component[]{new Label("facsimileLabel", (IModel)new ResourceModel("profile.phone.facsimile"))});
        TextField facsimile = new TextField("facsimile", (IModel)new PropertyModel((Object)userProfile, "facsimile"));
        facsimile.setMarkupId("facsimileinput");
        facsimile.setOutputMarkupId(true);
        facsimile.add((IValidator)new PhoneNumberValidator());
        facsimileContainer.add(new Component[]{facsimile});
        FeedbackLabel facsimileFeedback = new FeedbackLabel("facsimileFeedback", (Component)facsimile);
        facsimileFeedback.setMarkupId("facsimileFeedback");
        facsimileFeedback.setOutputMarkupId(true);
        facsimileContainer.add(new Component[]{facsimileFeedback});
        facsimile.add(new IBehavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)facsimileFeedback)});
        form.add(new Component[]{facsimileContainer});
        2 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{submitButton});
        3 cancelButton = new /* Unavailable Anonymous Inner Class!! */;
        cancelButton.setDefaultFormProcessing(false);
        form.add(new Component[]{cancelButton});
        this.add(new Component[]{form});
    }

    private boolean save(Form form) {
        UserProfile userProfile = (UserProfile)form.getModelObject();
        String userId = userProfile.getUserUuid();
        SakaiPerson sakaiPerson = this.sakaiProxy.getSakaiPerson(userId);
        sakaiPerson.setLabeledURI(userProfile.getHomepage());
        sakaiPerson.setTelephoneNumber(userProfile.getWorkphone());
        sakaiPerson.setHomePhone(userProfile.getHomephone());
        sakaiPerson.setMobile(userProfile.getMobilephone());
        sakaiPerson.setFacsimileTelephoneNumber(userProfile.getFacsimile());
        if (this.profileLogic.saveUserProfile(sakaiPerson)) {
            log.info((Object)("Saved SakaiPerson for: " + userId));
            if (this.sakaiProxy.isAccountUpdateAllowed(userId)) {
                this.sakaiProxy.updateEmailForUser(userId, userProfile.getEmail());
            }
            return true;
        }
        log.info((Object)("Couldn't save SakaiPerson for: " + userId));
        return false;
    }

    static /* synthetic */ boolean access$000(MyContactEdit x0, Form x1) {
        return x0.save(x1);
    }

    static /* synthetic */ SakaiProxy access$100(MyContactEdit x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$200(MyContactEdit x0) {
        return x0.wallLogic;
    }
}

