/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.components;

import java.util.Map;
import org.apache.wicket.ajax.calldecorator.AjaxCallDecorator;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.sakaiproject.profile2.tool.components.CKEditorTextArea;

public class CKEditorTextArea
extends TextArea<String> {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_SEPARATOR = ":";
    private static final String CKEDITOR_JS = "resources/ckeditor.js";
    private static final String CKEDITOR_JQUERY_ADAPTER = "resources/adapters/jquery.js";
    public static final String DECORATOR_FUNCTION_UPDATE_ALL = "$.each(CKEDITOR.instances, function(index, value) {if ($('#'+index).length > 0) {value.updateElement(); value.postAjaxWicket();}});";
    private String editorConfig = "{}";
    private String callbackFunction = "function() {}";
    private final boolean shouldCkInstanceRemoveInstance;
    private final CustomAjaxFormComponentUpdatingBehavior behavior;
    private static final String RIGHT_CURLY_BRACKET_STRING = "}";
    private static final String NEW_LINE_STRING = "\n";
    private static final String LEFT_CURLY_BRACKET_STRING = "{";
    private static final String COMMA_STRING = ",";
    public static final String CONFIG_HEIGHT = "'height'";
    public static final String CONFIG_WIDTH = "'width'";
    public static final String CONFIG_TOOLBAR = "'toolbar'";
    public static final String TOOLBAR_FULL = "'toolbar_Full'";
    public static final String CONFIG_ALIGN = "'align'";
    public static final String HTML_ENCODE_OUTPUT = "'htmlEncodeOutput'";
    public static final String ENTITIES = "'entities'";
    public static final String BASIC_ENTITIES = "'basicEntities'";
    public static final String SKIN = "'skin'";
    public static final String SKIN_V2 = "'v2'";
    public static final String EXTRA_PLUGINS = "'extraPlugins'";
    public static final String REMOVE_PLUGINS = "'removePlugins'";
    public static final String ELEMENTS_PATH = "'elementspath'";
    public static final String RESIZE_ENABLED = "'resize_enabled'";
    public static final String REMOVE_FORMAT_TAGS = "'removeFormatTags'";
    public static final String SHIFT_ENTER_MODE = "'shiftEnterMode'";
    public static final String ENTER_MODE = "'enterMode'";
    public static final String CKEDITOR_ENTER_BR = "CKEDITOR.ENTER_BR";
    public static final String LANGUAGE_CONFIG = "language";
    public static final String BLOCKED_KEYSTROKES = "blockedKeystrokes";
    public static final String BLOCKED_KEYSTROKES_VALUES = "[CKEDITOR.CTRL + 66 /*B*/, CKEDITOR.CTRL + 73 /*I*/, CKEDITOR.CTRL + 85 /*U*/ ]";
    public static final String ACTIVE_KEYSTROKES = "keystrokes";
    public static final String ACTIVE_KEYSTROKES_VALUES = "[[ CKEDITOR.ALT + 121 /*F10*/, 'toolbarFocus' ],[ CKEDITOR.ALT + 122 /*F11*/, 'elementsPathFocus' ],[ CKEDITOR.SHIFT + 121 /*F10*/, 'contextMenu' ],[ CKEDITOR.CTRL + 90 /*Z*/, 'undo' ],[ CKEDITOR.CTRL + 89 /*Y*/, 'redo' ],[ CKEDITOR.CTRL + CKEDITOR.SHIFT + 90 /*Z*/, 'redo' ],[ CKEDITOR.CTRL + 76 /*L*/, 'link' ],[ CKEDITOR.CTRL + 66 /*B*/, 'bold' ],[ CKEDITOR.CTRL + 73 /*I*/, 'italic' ],[ CKEDITOR.CTRL + 83 /*S*/, 'save' ],[ CKEDITOR.ALT + 109 /*-*/, 'toolbarCollapse' ]]";

    public CKEditorTextArea(String id) {
        this(id, (IModel)new Model());
    }

    public CKEditorTextArea(String id, boolean shouldCkInstanceRemoveInstance) {
        this(id, (IModel)new Model(), shouldCkInstanceRemoveInstance);
    }

    public CKEditorTextArea(String id, IModel<String> model, boolean shouldCkInstanceRemoveInstance) {
        super(id, model);
        this.shouldCkInstanceRemoveInstance = shouldCkInstanceRemoveInstance;
        this.add(new IBehavior[]{new CKEditorBehavior(this)});
        this.behavior = new CustomAjaxFormComponentUpdatingBehavior(this, "onblur");
        this.add(new IBehavior[]{this.behavior});
        this.setOutputMarkupId(true);
    }

    public CKEditorTextArea(String id, IModel<String> model) {
        this(id, model, false);
    }

    protected void onRemove() {
        super.onRemove();
        if (this.shouldCkInstanceRemoveInstance) {
            String jsStr = this.createDestroyMethod();
            this.getResponse().write((CharSequence)jsStr);
        }
    }

    protected String createDestroyMethod() {
        StringBuilder js = new StringBuilder("<script type=\"text/javascript\"><!--/*--><![CDATA[/*><!--*/\n");
        js.append("if(CKEDITOR && CKEDITOR.instances && CKEDITOR.instances.").append(this.getMarkupId()).append(") {CKEDITOR.instances.").append(this.getMarkupId()).append(".destroy(true);}");
        js.append("/*-->]]>*/</script>");
        String jsStr = js.toString();
        return jsStr;
    }

    public String getInputName() {
        return this.getMarkupId();
    }

    public void setEditorConfig(Map<String, String> config) {
        StringBuilder configBuilder = new StringBuilder();
        configBuilder.append(LEFT_CURLY_BRACKET_STRING);
        configBuilder.append(NEW_LINE_STRING);
        for (String key : config.keySet()) {
            configBuilder.append(key).append(PROPERTY_SEPARATOR).append(config.get(key)).append(COMMA_STRING);
            configBuilder.append(NEW_LINE_STRING);
        }
        int lastCommaIndex = configBuilder.lastIndexOf(COMMA_STRING);
        configBuilder.replace(lastCommaIndex, lastCommaIndex + 1, "");
        configBuilder.append(NEW_LINE_STRING);
        configBuilder.append(RIGHT_CURLY_BRACKET_STRING);
        this.editorConfig = configBuilder.toString();
    }

    public void setCallbackFunction(String callbackFunctionParam) {
        StringBuilder callbackFunctionBuilder = new StringBuilder();
        callbackFunctionBuilder.append("function() {");
        callbackFunctionBuilder.append(NEW_LINE_STRING);
        callbackFunctionBuilder.append(callbackFunctionParam);
        callbackFunctionBuilder.append(NEW_LINE_STRING);
        callbackFunctionBuilder.append(RIGHT_CURLY_BRACKET_STRING);
        this.callbackFunction = callbackFunctionBuilder.toString();
    }

    public static final AjaxCallDecorator getAjaxCallDecoratedToUpdateElementForAllEditorsOnPage() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public AjaxCallDecorator getAjaxCallDecoratedToUpdateElement() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ CustomAjaxFormComponentUpdatingBehavior access$000(CKEditorTextArea x0) {
        return x0.behavior;
    }

    static /* synthetic */ String access$100(CKEditorTextArea x0) {
        return x0.editorConfig;
    }
}

