/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.entityprovider;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityURLRedirect;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Redirectable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RequestAware;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Resolvable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Sampleable;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.entitybroker.entityprovider.extension.RequestGetter;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfileLinkLogic;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ProfileImage;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.util.Messages;
import org.sakaiproject.profile2.util.ProfileUtils;

public class ProfileEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
AutoRegisterEntityProvider,
Outputable,
Resolvable,
Sampleable,
Describeable,
Redirectable,
ActionsExecutable,
RequestAware {
    private static final Log log = LogFactory.getLog(ProfileEntityProvider.class);
    public static final String ENTITY_PREFIX = "profile";
    private RequestGetter requestGetter;
    private SakaiProxy sakaiProxy;
    private ProfileLogic profileLogic;
    private ProfileConnectionsLogic connectionsLogic;
    private ProfileImageLogic imageLogic;
    private ProfileLinkLogic linkLogic;

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public boolean entityExists(String eid) {
        return true;
    }

    public Object getSampleEntity() {
        return new UserProfile();
    }

    public Object getEntity(EntityReference ref) {
        String uuid = this.sakaiProxy.ensureUuid(ref.getId());
        if (StringUtils.isBlank((String)uuid)) {
            throw new EntityNotFoundException("Invalid user.", ref.getId());
        }
        String siteId = this.requestGetter.getRequest().getParameter("siteId");
        UserProfile userProfile = this.profileLogic.getUserProfile(uuid, siteId);
        if (userProfile == null) {
            throw new EntityNotFoundException("Profile could not be retrieved for " + ref.getId(), ref.getReference());
        }
        return userProfile;
    }

    @EntityCustomAction(action="image", viewKey="show")
    public Object getProfileImage(OutputStream out, EntityView view, Map<String, Object> params, EntityReference ref) {
        String siteId;
        boolean wantsOfficial;
        String id = ref.getId();
        boolean wantsBlank = id.equals("blank");
        String uuid = "";
        if (!wantsBlank && StringUtils.isBlank((String)(uuid = this.sakaiProxy.ensureUuid(ref.getId())))) {
            throw new EntityNotFoundException("Invalid user.", ref.getId());
        }
        ProfileImage image = null;
        boolean wantsThumbnail = StringUtils.equals((String)"thumb", (String)view.getPathSegment(3));
        boolean wantsAvatar = false;
        if (!wantsThumbnail) {
            wantsAvatar = StringUtils.equals((String)"avatar", (String)view.getPathSegment(3));
        }
        boolean bl = wantsOfficial = StringUtils.equals((String)"official", (String)view.getPathSegment(3));
        if (log.isDebugEnabled()) {
            log.debug((Object)("wantsThumbnail:" + wantsThumbnail));
            log.debug((Object)("wantsAvatar:" + wantsAvatar));
            log.debug((Object)("wantsOfficial:" + wantsOfficial));
            log.debug((Object)("wantsBlank:" + wantsBlank));
        }
        if (StringUtils.isNotBlank((String)(siteId = (String)params.get("siteId"))) && !this.sakaiProxy.checkForSite(siteId)) {
            throw new EntityNotFoundException("Invalid siteId: " + siteId, ref.getReference());
        }
        if (wantsBlank) {
            image = this.imageLogic.getBlankProfileImage();
        } else {
            if (wantsThumbnail) {
                image = this.imageLogic.getProfileImage(uuid, null, null, 2, siteId);
            }
            if (!wantsThumbnail && wantsAvatar) {
                image = this.imageLogic.getProfileImage(uuid, null, null, 3, siteId);
            }
            if (!wantsThumbnail && !wantsAvatar) {
                image = this.imageLogic.getProfileImage(uuid, null, null, 1, siteId);
            }
            if (wantsOfficial) {
                image = this.imageLogic.getOfficialProfileImage(uuid, siteId);
            }
        }
        if (image == null) {
            throw new EntityNotFoundException("No profile image for " + id, ref.getReference());
        }
        byte[] bytes = image.getBinary();
        if (bytes != null && bytes.length > 0) {
            try {
                out.write(bytes);
                ActionReturn actionReturn = new ActionReturn("BASE64", image.getMimeType(), out);
                return actionReturn;
            }
            catch (IOException e) {
                throw new EntityException("Error retrieving profile image for " + id + " : " + e.getMessage(), ref.getReference());
            }
        }
        String url = image.getUrl();
        if (StringUtils.isNotBlank((String)url)) {
            try {
                this.requestGetter.getResponse().sendRedirect(url);
            }
            catch (IOException e) {
                throw new EntityException("Error redirecting to external image for " + id + " : " + e.getMessage(), ref.getReference());
            }
        }
        return null;
    }

    @EntityCustomAction(action="connections", viewKey="show")
    public Object getConnections(EntityView view, EntityReference ref) {
        if (!this.sakaiProxy.isLoggedIn()) {
            throw new SecurityException("You must be logged in to get a connection list.");
        }
        String uuid = this.sakaiProxy.ensureUuid(ref.getId());
        if (StringUtils.isBlank((String)uuid)) {
            throw new EntityNotFoundException("Invalid user.", ref.getId());
        }
        List connections = this.connectionsLogic.getBasicConnectionsForUser(uuid);
        if (connections == null) {
            throw new EntityException("Error retrieving connections for " + ref.getId(), ref.getReference());
        }
        ActionReturn actionReturn = new ActionReturn((Object)connections);
        return actionReturn;
    }

    @EntityCustomAction(action="friendStatus", viewKey="show")
    public Object getConnectionStatus(EntityReference ref, Map<String, Object> parameters) {
        if (!this.sakaiProxy.isLoggedIn()) {
            throw new SecurityException("You must be logged in to get a friend status record.");
        }
        String uuid = this.sakaiProxy.ensureUuid(ref.getId());
        if (StringUtils.isBlank((String)uuid)) {
            throw new EntityNotFoundException("Invalid user.", ref.getId());
        }
        if (!parameters.containsKey("friendId")) {
            throw new EntityNotFoundException("Parameter must be specified: friendId", ref.getId());
        }
        return this.connectionsLogic.getConnectionStatus(uuid, parameters.get("friendId").toString());
    }

    @EntityCustomAction(action="formatted", viewKey="show")
    public Object getFormattedProfile(EntityReference ref) {
        UserProfile userProfile = (UserProfile)this.getEntity(ref);
        String siteId = this.requestGetter.getRequest().getParameter("siteId");
        String formattedProfile = this.getUserProfileAsHTML(userProfile, siteId);
        ActionReturn actionReturn = new ActionReturn("UTF-8", "text/html", formattedProfile);
        return actionReturn;
    }

    @EntityCustomAction(action="requestFriend", viewKey="show")
    public Object requestFriend(EntityReference ref, Map<String, Object> params) {
        if (!this.sakaiProxy.isLoggedIn()) {
            throw new SecurityException("You must be logged in to make a connection request.");
        }
        String uuid = this.sakaiProxy.ensureUuid(ref.getId());
        if (StringUtils.isBlank((String)uuid)) {
            throw new EntityNotFoundException("Invalid user.", ref.getId());
        }
        String friendId = (String)params.get("friendId");
        if (!this.connectionsLogic.requestFriend(uuid, friendId)) {
            throw new EntityException("Error requesting friend connection for " + ref.getId(), ref.getReference());
        }
        return Messages.getString((String)"Label.friend.requested");
    }

    @EntityCustomAction(action="removeFriend", viewKey="show")
    public Object removeFriend(EntityReference ref, Map<String, Object> params) {
        if (!this.sakaiProxy.isLoggedIn()) {
            throw new SecurityException("You must be logged in to remove a connection.");
        }
        String uuid = this.sakaiProxy.ensureUuid(ref.getId());
        if (StringUtils.isBlank((String)uuid)) {
            throw new EntityNotFoundException("Invalid user.", ref.getId());
        }
        String friendId = (String)params.get("friendId");
        if (!this.connectionsLogic.removeFriend(uuid, friendId)) {
            throw new EntityException("Error removing friend connection for " + ref.getId(), ref.getReference());
        }
        return Messages.getString((String)"Label.friend.add");
    }

    @EntityCustomAction(action="confirmFriendRequest", viewKey="show")
    public Object confirmFriendRequest(EntityReference ref, Map<String, Object> params) {
        if (!this.sakaiProxy.isLoggedIn()) {
            throw new SecurityException("You must be logged in to confirm a connection request.");
        }
        String uuid = this.sakaiProxy.ensureUuid(ref.getId());
        if (StringUtils.isBlank((String)uuid)) {
            throw new EntityNotFoundException("Invalid user.", ref.getId());
        }
        String friendId = (String)params.get("friendId");
        if (!this.connectionsLogic.confirmFriendRequest(friendId, uuid)) {
            throw new EntityException("Error confirming friend connection for " + ref.getId(), ref.getReference());
        }
        return Messages.getString((String)"Label.friend.remove");
    }

    @EntityCustomAction(action="ignoreFriendRequest", viewKey="show")
    public Object ignoreFriendRequest(EntityReference ref, Map<String, Object> params) {
        if (!this.sakaiProxy.isLoggedIn()) {
            throw new SecurityException("You must be logged in to ignore a connection request.");
        }
        String uuid = this.sakaiProxy.ensureUuid(ref.getId());
        if (StringUtils.isBlank((String)uuid)) {
            throw new EntityNotFoundException("Invalid user.", ref.getId());
        }
        String friendId = (String)params.get("friendId");
        if (!this.connectionsLogic.ignoreFriendRequest(friendId, uuid)) {
            throw new EntityException("Error ignoring friend connection for " + ref.getId(), ref.getReference());
        }
        return Messages.getString((String)"Label.friend.add");
    }

    @EntityURLRedirect(value="/{prefix}/{id}/account")
    public String redirectUserAccount(Map<String, String> vars) {
        return "user/" + vars.get("id") + vars.get("dot-extension");
    }

    private String getUserProfileAsHTML(UserProfile userProfile, String siteId) {
        String favouriteQuotes;
        String favouriteMovies;
        String favouriteTvShows;
        String favouriteBooks;
        String subjects;
        String course;
        String room;
        String school;
        String department;
        String position;
        String nickname;
        String displayName;
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\" src=\"/profile2-tool/javascript/profile2-eb.js\"></script>");
        sb.append("<div class=\"profile2-profile\">");
        sb.append("<div class=\"profile2-profile-image\">");
        sb.append("<img src=\"");
        sb.append(userProfile.getImageUrl());
        sb.append("\" />");
        sb.append("</div>");
        sb.append("<div class=\"profile2-profile-content\">");
        if (StringUtils.isNotBlank((String)userProfile.getUserUuid())) {
            sb.append("<div class=\"profile2-profile-userUuid\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.userUuid"));
            sb.append("</span>");
            sb.append(userProfile.getUserUuid());
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(displayName = userProfile.getDisplayName()))) {
            sb.append("<div class=\"profile2-profile-displayName\">");
            sb.append(StringEscapeUtils.escapeHtml((String)displayName));
            sb.append("</div>");
        }
        if (userProfile.getStatus() != null) {
            String message = userProfile.getStatus().getMessage();
            if (StringUtils.isNotBlank((String)message)) {
                sb.append("<div class=\"profile2-profile-statusMessage\">");
                sb.append(StringEscapeUtils.escapeHtml((String)message));
                sb.append("</div>");
            }
            if (StringUtils.isNotBlank((String)userProfile.getStatus().getDateFormatted())) {
                sb.append("<div class=\"profile2-profile-statusDate\">");
                sb.append(userProfile.getStatus().getDateFormatted());
                sb.append("</div>");
            }
        }
        if (StringUtils.isNotBlank((String)userProfile.getUserUuid())) {
            sb.append("<div class=\"icon profile-image\">");
            sb.append("<div class=\"profile2-profile-view-full\">");
            sb.append("<a href=\"javascript:;\" onclick=\"window.open('" + this.linkLogic.getInternalDirectUrlToUserProfile(userProfile.getUserUuid()) + "','','resizable=yes,scrollbars=yes')\">" + Messages.getString((String)"profile.view.full") + "</a>");
            sb.append("</div>");
            sb.append("</div>");
        }
        if (!this.sakaiProxy.getCurrentUserId().equals(userProfile.getUserUuid())) {
            int connectionStatus = this.connectionsLogic.getConnectionStatus(this.sakaiProxy.getCurrentUserId(), userProfile.getUserUuid());
            if (connectionStatus == 3) {
                sb.append("<div id=\"profile_friend_" + userProfile.getUserUuid() + "\" class=\"icon connection-confirmed\"><a href=\"javascript:;\" onClick=\"return removeFriend('" + this.sakaiProxy.getCurrentUserId() + "','" + userProfile.getUserUuid() + "');\">" + Messages.getString((String)"Label.friend.remove") + "</a></div>");
            } else if (connectionStatus == 1) {
                sb.append("<div id=\"profile_friend_" + userProfile.getUserUuid() + "\" class=\"icon connection-request\">" + Messages.getString((String)"Label.friend.requested") + "</div>");
            } else if (connectionStatus == 2) {
                sb.append("<div id=\"profile_friend_" + userProfile.getUserUuid() + "\" class=\"icon connection-request\">" + Messages.getString((String)"Label.friend.requested") + "<a href=\"javascript:;\" title=\"" + Messages.getString((String)"Label.friend.confirm") + "\" onClick=\"return confirmFriendRequest('" + this.sakaiProxy.getCurrentUserId() + "','" + userProfile.getUserUuid() + "');\"><img src=\"/library/image/silk/accept.png\"></a><a href=\"javascript:;\" title=\"" + Messages.getString((String)"Label.friend.ignore") + "\" onClick=\"return ignoreFriendRequest('" + this.sakaiProxy.getCurrentUserId() + "','" + userProfile.getUserUuid() + "');\"><img src=\"/library/image/silk/cancel.png\"></a></div>");
            } else {
                sb.append("<div id=\"profile_friend_" + userProfile.getUserUuid() + "\" class=\"icon connection-add\"><a href=\"javascript:;\" onClick=\"return requestFriend('" + this.sakaiProxy.getCurrentUserId() + "','" + userProfile.getUserUuid() + "');\">" + Messages.getString((String)"Label.friend.add") + "</a></div>");
            }
            sb.append("<br />");
        }
        if (StringUtils.isNotBlank((String)(nickname = userProfile.getNickname()))) {
            sb.append("<div class=\"profile2-profile-nickname\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.nickname"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)nickname).toString());
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)userProfile.getPersonalSummary())) {
            sb.append("<div class=\"profile2-profile-personalSummary\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.personalSummary"));
            sb.append("</span>");
            int maxLength = Integer.parseInt(this.sakaiProxy.getServerConfigurationParameter("profile2.formatted.profile.summary.max", "1000"));
            sb.append(ProfileUtils.truncateAndAbbreviate((String)ProfileUtils.processHtml((String)userProfile.getPersonalSummary()), (int)maxLength, (boolean)true));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)userProfile.getEmail())) {
            sb.append("<div class=\"profile2-profile-email\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.email"));
            sb.append("</span>");
            sb.append(userProfile.getEmail());
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)userProfile.getHomepage())) {
            sb.append("<div class=\"profile2-profile-homepage\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.homepage"));
            sb.append("</span>");
            sb.append(userProfile.getHomepage());
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)userProfile.getHomephone())) {
            sb.append("<div class=\"profile2-profile-homephone\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.homephone"));
            sb.append("</span>");
            sb.append(userProfile.getHomephone());
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)userProfile.getWorkphone())) {
            sb.append("<div class=\"profile2-profile-workphone\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.workphone"));
            sb.append("</span>");
            sb.append(userProfile.getWorkphone());
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)userProfile.getMobilephone())) {
            sb.append("<div class=\"profile2-profile-mobilephone\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.mobilephone"));
            sb.append("</span>");
            sb.append(userProfile.getMobilephone());
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)userProfile.getFacsimile())) {
            sb.append("<div class=\"profile2-profile-facsimile\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.facsimile"));
            sb.append("</span>");
            sb.append(userProfile.getFacsimile());
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(position = userProfile.getPosition()))) {
            sb.append("<div class=\"profile2-profile-position\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.position"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)position));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(department = userProfile.getDepartment()))) {
            sb.append("<div class=\"profile2-profile-department\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.department"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)department));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(school = userProfile.getSchool()))) {
            sb.append("<div class=\"profile2-profile-school\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.school"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)school));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(room = userProfile.getRoom()))) {
            sb.append("<div class=\"profile2-profile-room\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.room"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)room));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(course = userProfile.getCourse()))) {
            sb.append("<div class=\"profile2-profile-course\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.course"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)course));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(subjects = userProfile.getSubjects()))) {
            sb.append("<div class=\"profile2-profile-subjects\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.subjects"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)subjects));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(favouriteBooks = userProfile.getFavouriteBooks()))) {
            sb.append("<div class=\"profile2-profile-favouriteBooks\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.favouriteBooks"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)favouriteBooks));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(favouriteTvShows = userProfile.getFavouriteTvShows()))) {
            sb.append("<div class=\"profile2-profile-favouriteTvShows\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.favouriteTvShows"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)favouriteTvShows));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(favouriteMovies = userProfile.getFavouriteMovies()))) {
            sb.append("<div class=\"profile2-profile-favouriteMovies\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.favouriteMovies"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)favouriteMovies));
            sb.append("</div>");
        }
        if (StringUtils.isNotBlank((String)(favouriteQuotes = userProfile.getFavouriteQuotes()))) {
            sb.append("<div class=\"profile2-profile-favouriteQuotes\">");
            sb.append("<span class=\"profile2-profile-label\">");
            sb.append(Messages.getString((String)"Label.favouriteQuotes"));
            sb.append("</span>");
            sb.append(StringEscapeUtils.escapeHtml((String)favouriteQuotes));
            sb.append("</div>");
        }
        sb.append("</div>");
        sb.append("</div>");
        sb.append("<link href=\"");
        sb.append("/profile2-tool/css/profile2-profile-entity.css");
        sb.append("\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />");
        return sb.toString();
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"html", "xml", "json"};
    }

    public void setRequestGetter(RequestGetter requestGetter) {
        this.requestGetter = requestGetter;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setProfileLogic(ProfileLogic profileLogic) {
        this.profileLogic = profileLogic;
    }

    public void setConnectionsLogic(ProfileConnectionsLogic connectionsLogic) {
        this.connectionsLogic = connectionsLogic;
    }

    public void setImageLogic(ProfileImageLogic imageLogic) {
        this.imageLogic = imageLogic;
    }

    public void setLinkLogic(ProfileLinkLogic linkLogic) {
        this.linkLogic = linkLogic;
    }
}

