/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.entityprovider;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Createable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Inputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Sampleable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Updateable;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.profile2.logic.ProfileStatusLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.ProfileStatus;

public class ProfileStatusEntityProvider
extends AbstractEntityProvider
implements CoreEntityProvider,
AutoRegisterEntityProvider,
Outputable,
Updateable,
Createable,
Inputable,
Sampleable,
Describeable {
    public static final String ENTITY_PREFIX = "profile-status";
    private SakaiProxy sakaiProxy;
    private ProfileStatusLogic statusLogic;

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public boolean entityExists(String eid) {
        return true;
    }

    public Object getSampleEntity() {
        return new ProfileStatus();
    }

    public Object getEntity(EntityReference ref) {
        if (!this.sakaiProxy.isLoggedIn()) {
            throw new SecurityException("You must be logged in to get a user's status.");
        }
        String uuid = this.sakaiProxy.ensureUuid(ref.getId());
        if (StringUtils.isBlank((String)uuid)) {
            return null;
        }
        return this.statusLogic.getUserStatus(uuid);
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        if (!this.sakaiProxy.isLoggedIn()) {
            throw new SecurityException("You must be logged in to update your status.");
        }
        String userId = ref.getId();
        if (StringUtils.isBlank((String)userId)) {
            throw new IllegalArgumentException("Cannot update, No userId in provided reference: " + ref);
        }
        if (!entity.getClass().isAssignableFrom(ProfileStatus.class)) {
            throw new IllegalArgumentException("Invalid entity for update, must be ProfileStatus object");
        }
        ProfileStatus status = (ProfileStatus)entity;
        this.statusLogic.setUserStatus(status);
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        String userUuid = null;
        if (entity.getClass().isAssignableFrom(ProfileStatus.class)) {
            ProfileStatus status = (ProfileStatus)entity;
            if (this.statusLogic.setUserStatus(status)) {
                userUuid = status.getUserUuid();
            }
            if (userUuid == null) {
                throw new EntityException("Could not create entity", ref.getReference());
            }
        } else {
            throw new IllegalArgumentException("Invalid entity for create, must be ProfileStatus object");
        }
        return userUuid;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return new String[]{"xml", "json", "html"};
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setStatusLogic(ProfileStatusLogic statusLogic) {
        this.statusLogic = statusLogic;
    }
}

