/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages;

import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.sakaiproject.profile2.exception.ProfilePrivacyNotDefinedException;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.tool.components.HashMapChoiceRenderer;
import org.sakaiproject.profile2.tool.components.IconWithClueTip;
import org.sakaiproject.profile2.tool.pages.BasePage;
import org.sakaiproject.profile2.tool.pages.MyPrivacy;

public class MyPrivacy
extends BasePage {
    private static final Logger log = Logger.getLogger(MyPrivacy.class);
    private transient ProfilePrivacy profilePrivacy;

    public MyPrivacy() {
        log.debug((Object)"MyPrivacy()");
        this.disableLink(this.myPrivacyLink);
        String userUuid = this.sakaiProxy.getCurrentUserId();
        this.profilePrivacy = this.privacyLogic.getPrivacyRecordForUser(userUuid, false);
        if (this.profilePrivacy == null) {
            throw new ProfilePrivacyNotDefinedException("Couldn't retrieve privacy record for " + userUuid);
        }
        Label heading = new Label("heading", (IModel)new ResourceModel("heading.privacy"));
        this.add(new Component[]{heading});
        Label infoLocked = new Label("infoLocked");
        infoLocked.setOutputMarkupPlaceholderTag(true);
        infoLocked.setVisible(false);
        this.add(new Component[]{infoLocked});
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        String formFeedbackId = formFeedback.getMarkupId();
        this.add(new Component[]{formFeedback});
        CompoundPropertyModel privacyModel = new CompoundPropertyModel((Object)this.profilePrivacy);
        Form form = new Form("form", (IModel)privacyModel);
        form.setOutputMarkupId(true);
        LinkedHashMap<Integer, String> privacySettingsStrict = new LinkedHashMap<Integer, String>();
        privacySettingsStrict.put(0, new StringResourceModel("privacy.option.everyone", (Component)this, null).getString());
        privacySettingsStrict.put(1, new StringResourceModel("privacy.option.onlyfriends", (Component)this, null).getString());
        privacySettingsStrict.put(2, new StringResourceModel("privacy.option.onlyme", (Component)this, null).getString());
        1 dropDownModelStrict = new /* Unavailable Anonymous Inner Class!! */;
        LinkedHashMap<Integer, String> privacySettingsRelaxed = new LinkedHashMap<Integer, String>();
        privacySettingsRelaxed.put(0, new StringResourceModel("privacy.option.everyone", (Component)this, null).getString());
        privacySettingsRelaxed.put(1, new StringResourceModel("privacy.option.onlyfriends", (Component)this, null).getString());
        2 dropDownModelRelaxed = new /* Unavailable Anonymous Inner Class!! */;
        LinkedHashMap<Integer, String> privacySettingsSuperStrict = new LinkedHashMap<Integer, String>();
        privacySettingsSuperStrict.put(1, new StringResourceModel("privacy.option.onlyfriends", (Component)this, null).getString());
        privacySettingsSuperStrict.put(3, new StringResourceModel("privacy.option.nobody", (Component)this, null).getString());
        3 dropDownModelSuperStrict = new /* Unavailable Anonymous Inner Class!! */;
        WebMarkupContainer profileImageContainer = new WebMarkupContainer("profileImageContainer");
        profileImageContainer.add(new Component[]{new Label("profileImageLabel", (IModel)new ResourceModel("privacy.profileimage"))});
        DropDownChoice profileImageChoice = new DropDownChoice("profileImage", (IModel)dropDownModelRelaxed, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsRelaxed));
        profileImageChoice.setMarkupId("imageprivacyinput");
        profileImageChoice.setOutputMarkupId(true);
        profileImageContainer.add(new Component[]{profileImageChoice});
        profileImageContainer.add(new Component[]{new IconWithClueTip("profileImageToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.profileimage.tooltip"))});
        form.add(new Component[]{profileImageContainer});
        profileImageChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer basicInfoContainer = new WebMarkupContainer("basicInfoContainer");
        basicInfoContainer.add(new Component[]{new Label("basicInfoLabel", (IModel)new ResourceModel("privacy.basicinfo"))});
        DropDownChoice basicInfoChoice = new DropDownChoice("basicInfo", (IModel)dropDownModelStrict, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsStrict));
        basicInfoChoice.setMarkupId("basicinfoprivacyinput");
        basicInfoChoice.setOutputMarkupId(true);
        basicInfoContainer.add(new Component[]{basicInfoChoice});
        basicInfoContainer.add(new Component[]{new IconWithClueTip("basicInfoToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.basicinfo.tooltip"))});
        form.add(new Component[]{basicInfoContainer});
        basicInfoChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer contactInfoContainer = new WebMarkupContainer("contactInfoContainer");
        contactInfoContainer.add(new Component[]{new Label("contactInfoLabel", (IModel)new ResourceModel("privacy.contactinfo"))});
        DropDownChoice contactInfoChoice = new DropDownChoice("contactInfo", (IModel)dropDownModelStrict, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsStrict));
        contactInfoChoice.setMarkupId("contactinfoprivacyinput");
        contactInfoChoice.setOutputMarkupId(true);
        contactInfoContainer.add(new Component[]{contactInfoChoice});
        contactInfoContainer.add(new Component[]{new IconWithClueTip("contactInfoToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.contactinfo.tooltip"))});
        form.add(new Component[]{contactInfoContainer});
        contactInfoChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer staffInfoContainer = new WebMarkupContainer("staffInfoContainer");
        staffInfoContainer.add(new Component[]{new Label("staffInfoLabel", (IModel)new ResourceModel("privacy.staffinfo"))});
        DropDownChoice staffInfoChoice = new DropDownChoice("staffInfo", (IModel)dropDownModelStrict, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsStrict));
        staffInfoChoice.setMarkupId("staffinfoprivacyinput");
        staffInfoChoice.setOutputMarkupId(true);
        staffInfoContainer.add(new Component[]{staffInfoChoice});
        staffInfoContainer.add(new Component[]{new IconWithClueTip("staffInfoToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.staff.tooltip"))});
        form.add(new Component[]{staffInfoContainer});
        staffInfoChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer studentInfoContainer = new WebMarkupContainer("studentInfoContainer");
        studentInfoContainer.add(new Component[]{new Label("studentInfoLabel", (IModel)new ResourceModel("privacy.studentinfo"))});
        DropDownChoice studentInfoChoice = new DropDownChoice("studentInfo", (IModel)dropDownModelStrict, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsStrict));
        studentInfoChoice.setMarkupId("studentinfoprivacyinput");
        studentInfoChoice.setOutputMarkupId(true);
        studentInfoContainer.add(new Component[]{studentInfoChoice});
        studentInfoContainer.add(new Component[]{new IconWithClueTip("studentInfoToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.student.tooltip"))});
        form.add(new Component[]{studentInfoContainer});
        studentInfoChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer businessInfoContainer = new WebMarkupContainer("businessInfoContainer");
        businessInfoContainer.add(new Component[]{new Label("businessInfoLabel", (IModel)new ResourceModel("privacy.businessinfo"))});
        DropDownChoice businessInfoChoice = new DropDownChoice("businessInfo", (IModel)dropDownModelStrict, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsStrict));
        businessInfoChoice.setMarkupId("businessinfoprivacyinput");
        businessInfoChoice.setOutputMarkupId(true);
        businessInfoContainer.add(new Component[]{businessInfoChoice});
        businessInfoContainer.add(new Component[]{new IconWithClueTip("businessInfoToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.businessinfo.tooltip"))});
        form.add(new Component[]{businessInfoContainer});
        businessInfoChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        businessInfoContainer.setVisible(this.sakaiProxy.isBusinessProfileEnabled());
        WebMarkupContainer socialNetworkingInfoContainer = new WebMarkupContainer("socialNetworkingInfoContainer");
        socialNetworkingInfoContainer.add(new Component[]{new Label("socialNetworkingInfoLabel", (IModel)new ResourceModel("privacy.socialinfo"))});
        DropDownChoice socialNetworkingInfoChoice = new DropDownChoice("socialNetworkingInfo", (IModel)dropDownModelStrict, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsStrict));
        socialNetworkingInfoChoice.setMarkupId("socialinfoprivacyinput");
        socialNetworkingInfoChoice.setOutputMarkupId(true);
        socialNetworkingInfoContainer.add(new Component[]{socialNetworkingInfoChoice});
        socialNetworkingInfoContainer.add(new Component[]{new IconWithClueTip("socialNetworkingInfoToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.socialinfo.tooltip"))});
        form.add(new Component[]{socialNetworkingInfoContainer});
        socialNetworkingInfoChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer personalInfoContainer = new WebMarkupContainer("personalInfoContainer");
        personalInfoContainer.add(new Component[]{new Label("personalInfoLabel", (IModel)new ResourceModel("privacy.personalinfo"))});
        DropDownChoice personalInfoChoice = new DropDownChoice("personalInfo", (IModel)dropDownModelStrict, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsStrict));
        personalInfoChoice.setMarkupId("personalinfoprivacyinput");
        personalInfoChoice.setOutputMarkupId(true);
        personalInfoContainer.add(new Component[]{personalInfoChoice});
        personalInfoContainer.add(new Component[]{new IconWithClueTip("personalInfoToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.personalinfo.tooltip"))});
        form.add(new Component[]{personalInfoContainer});
        personalInfoChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer birthYearContainer = new WebMarkupContainer("birthYearContainer");
        birthYearContainer.add(new Component[]{new Label("birthYearLabel", (IModel)new ResourceModel("privacy.birthyear"))});
        CheckBox birthYearCheckbox = new CheckBox("birthYear", (IModel)new PropertyModel((Object)privacyModel, "showBirthYear"));
        birthYearCheckbox.setMarkupId("birthyearprivacyinput");
        birthYearCheckbox.setOutputMarkupId(true);
        birthYearContainer.add(new Component[]{birthYearCheckbox});
        birthYearContainer.add(new Component[]{new IconWithClueTip("birthYearToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.birthyear.tooltip"))});
        form.add(new Component[]{birthYearContainer});
        birthYearCheckbox.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer myFriendsContainer = new WebMarkupContainer("myFriendsContainer");
        myFriendsContainer.add(new Component[]{new Label("myFriendsLabel", (IModel)new ResourceModel("privacy.myfriends"))});
        DropDownChoice myFriendsChoice = new DropDownChoice("myFriends", (IModel)dropDownModelStrict, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsStrict));
        myFriendsChoice.setMarkupId("friendsprivacyinput");
        myFriendsChoice.setOutputMarkupId(true);
        myFriendsContainer.add(new Component[]{myFriendsChoice});
        myFriendsContainer.add(new Component[]{new IconWithClueTip("myFriendsToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.myfriends.tooltip"))});
        form.add(new Component[]{myFriendsContainer});
        myFriendsChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer myStatusContainer = new WebMarkupContainer("myStatusContainer");
        myStatusContainer.add(new Component[]{new Label("myStatusLabel", (IModel)new ResourceModel("privacy.mystatus"))});
        DropDownChoice myStatusChoice = new DropDownChoice("myStatus", (IModel)dropDownModelRelaxed, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsRelaxed));
        myStatusChoice.setMarkupId("statusprivacyinput");
        myStatusChoice.setOutputMarkupId(true);
        myStatusContainer.add(new Component[]{myStatusChoice});
        myStatusContainer.add(new Component[]{new IconWithClueTip("myStatusToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.mystatus.tooltip"))});
        form.add(new Component[]{myStatusContainer});
        myStatusChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer myPicturesContainer = new WebMarkupContainer("myPicturesContainer");
        myPicturesContainer.add(new Component[]{new Label("myPicturesLabel", (IModel)new ResourceModel("privacy.mypictures"))});
        DropDownChoice myPicturesChoice = new DropDownChoice("myPictures", (IModel)dropDownModelRelaxed, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsRelaxed));
        myPicturesChoice.setMarkupId("picturesprivacyinput");
        myPicturesChoice.setOutputMarkupId(true);
        myPicturesContainer.add(new Component[]{myPicturesChoice});
        myPicturesContainer.add(new Component[]{new IconWithClueTip("myPicturesToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.mypictures.tooltip"))});
        form.add(new Component[]{myPicturesContainer});
        myPicturesChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        myPicturesContainer.setVisible(this.sakaiProxy.isProfileGalleryEnabledGlobally());
        WebMarkupContainer messagesContainer = new WebMarkupContainer("messagesContainer");
        messagesContainer.add(new Component[]{new Label("messagesLabel", (IModel)new ResourceModel("privacy.messages"))});
        DropDownChoice messagesChoice = new DropDownChoice("messages", (IModel)dropDownModelSuperStrict, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsSuperStrict));
        messagesChoice.setMarkupId("messagesprivacyinput");
        messagesChoice.setOutputMarkupId(true);
        messagesContainer.add(new Component[]{messagesChoice});
        messagesContainer.add(new Component[]{new IconWithClueTip("messagesToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.messages.tooltip"))});
        form.add(new Component[]{messagesContainer});
        messagesChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        messagesContainer.setVisible(this.sakaiProxy.isMessagingEnabledGlobally());
        WebMarkupContainer myKudosContainer = new WebMarkupContainer("myKudosContainer");
        myKudosContainer.add(new Component[]{new Label("myKudosLabel", (IModel)new ResourceModel("privacy.mykudos"))});
        DropDownChoice kudosChoice = new DropDownChoice("myKudos", (IModel)dropDownModelRelaxed, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsRelaxed));
        kudosChoice.setMarkupId("kudosprivacyinput");
        kudosChoice.setOutputMarkupId(true);
        myKudosContainer.add(new Component[]{kudosChoice});
        myKudosContainer.add(new Component[]{new IconWithClueTip("myKudosToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.mykudos.tooltip"))});
        form.add(new Component[]{myKudosContainer});
        kudosChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        WebMarkupContainer myWallContainer = new WebMarkupContainer("myWallContainer");
        myWallContainer.add(new Component[]{new Label("myWallLabel", (IModel)new ResourceModel("privacy.mywall"))});
        DropDownChoice myWallChoice = new DropDownChoice("myWall", (IModel)dropDownModelRelaxed, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsRelaxed));
        myWallChoice.setMarkupId("wallprivacyinput");
        myWallChoice.setOutputMarkupId(true);
        myWallContainer.add(new Component[]{myWallChoice});
        myWallContainer.add(new Component[]{new IconWithClueTip("myWallToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.mywall.tooltip"))});
        form.add(new Component[]{myWallContainer});
        myWallChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        myWallContainer.setVisible(this.sakaiProxy.isWallEnabledGlobally());
        WebMarkupContainer onlineStatusContainer = new WebMarkupContainer("onlineStatusContainer");
        onlineStatusContainer.add(new Component[]{new Label("onlineStatusLabel", (IModel)new ResourceModel("privacy.onlinestatus"))});
        DropDownChoice onlineStatusChoice = new DropDownChoice("onlineStatus", (IModel)dropDownModelRelaxed, (IChoiceRenderer)new HashMapChoiceRenderer(privacySettingsRelaxed));
        onlineStatusChoice.setMarkupId("onlinestatusprivacyinput");
        onlineStatusChoice.setOutputMarkupId(true);
        onlineStatusContainer.add(new Component[]{onlineStatusChoice});
        onlineStatusContainer.add(new Component[]{new IconWithClueTip("onlineStatusToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.privacy.onlinestatus.tooltip"))});
        form.add(new Component[]{onlineStatusContainer});
        onlineStatusChoice.add(new IBehavior[]{new /* Unavailable Anonymous Inner Class!! */});
        20 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.setModel((IModel)new ResourceModel("button.save.settings"));
        submitButton.setOutputMarkupId(true);
        form.add(new Component[]{submitButton});
        if (!this.sakaiProxy.isPrivacyChangeAllowedGlobally()) {
            infoLocked.setDefaultModel((IModel)new ResourceModel("text.privacy.cannot.modify"));
            infoLocked.setVisible(true);
            profileImageChoice.setEnabled(false);
            basicInfoChoice.setEnabled(false);
            contactInfoChoice.setEnabled(false);
            studentInfoChoice.setEnabled(false);
            businessInfoChoice.setEnabled(false);
            personalInfoChoice.setEnabled(false);
            birthYearCheckbox.setEnabled(false);
            myFriendsChoice.setEnabled(false);
            myStatusChoice.setEnabled(false);
            myPicturesChoice.setEnabled(false);
            messagesChoice.setEnabled(false);
            myWallChoice.setEnabled(false);
            onlineStatusChoice.setEnabled(false);
            submitButton.setEnabled(false);
            submitButton.setVisible(false);
            form.setEnabled(false);
        }
        this.add(new Component[]{form});
    }

    private boolean save(Form<ProfilePrivacy> form) {
        ProfilePrivacy profilePrivacy = (ProfilePrivacy)form.getModelObject();
        if (this.privacyLogic.savePrivacyRecord(profilePrivacy)) {
            log.info((Object)("Saved ProfilePrivacy for: " + profilePrivacy.getUserUuid()));
            return true;
        }
        log.info((Object)("Couldn't save ProfilePrivacy for: " + profilePrivacy.getUserUuid()));
        return false;
    }

    static /* synthetic */ boolean access$000(MyPrivacy x0, Form x1) {
        return x0.save(x1);
    }
}

