/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages;

import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import org.apache.log4j.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.PageableListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.tool.components.HashMapChoiceRenderer;
import org.sakaiproject.profile2.tool.components.IconWithClueTip;
import org.sakaiproject.profile2.tool.models.FriendAction;
import org.sakaiproject.profile2.tool.models.StringModel;
import org.sakaiproject.profile2.tool.pages.BasePage;
import org.sakaiproject.profile2.tool.pages.MySearch;
import org.sakaiproject.profile2.util.ProfileUtils;
import org.sakaiproject.site.api.Site;

public class MySearch
extends BasePage {
    private List<Person> results = new ArrayList();
    private static final Logger log = Logger.getLogger(MySearch.class);
    private WebMarkupContainer numSearchResultsContainer;
    private Label numSearchResults;
    private WebMarkupContainer resultsContainer;
    private AjaxButton clearButton;
    private AjaxButton clearHistoryButton;
    private TextField<String> searchField;
    private RadioGroup<String> searchTypeRadioGroup;
    private CheckBox connectionsCheckBox;
    private CheckBox worksiteCheckBox;
    private DropDownChoice worksiteChoice;
    private transient Cookie searchCookie = null;

    public MySearch() {
        log.debug((Object)"MySearch()");
        this.disableLink(this.searchLink);
        this.searchCookie = this.getWebRequestCycle().getWebRequest().getCookie("profile2-search");
        FriendAction friendActionModel = new FriendAction();
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        String currentUserType = this.sakaiProxy.getUserType(currentUserUuid);
        Label searchHeading = new Label("searchHeading", (IModel)new ResourceModel("heading.search"));
        this.add(new Component[]{searchHeading});
        StringModel searchStringModel = new StringModel();
        Form searchForm = new Form("searchForm", (IModel)new Model((Serializable)searchStringModel));
        searchForm.setOutputMarkupId(true);
        searchForm.add(new Component[]{new Label("searchLabel", (IModel)new ResourceModel("text.search.terms.label"))});
        this.searchField = new TextField("searchField", (IModel)new PropertyModel((Object)searchStringModel, "string"));
        this.searchField.setRequired(true);
        this.searchField.setMarkupId("searchinput");
        this.searchField.setOutputMarkupId(true);
        searchForm.add(new Component[]{this.searchField});
        searchForm.add(new Component[]{new IconWithClueTip("searchToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.search.terms.tooltip"))});
        this.searchTypeRadioGroup = new RadioGroup("searchTypeRadioGroup");
        this.searchTypeRadioGroup.setOutputMarkupId(true);
        this.searchTypeRadioGroup.setRenderBodyOnly(false);
        Radio searchTypeRadioName = new Radio("searchTypeName", (IModel)new Model((Serializable)((Object)"name")));
        searchTypeRadioName.setMarkupId("searchtypenameinput");
        searchTypeRadioName.setOutputMarkupId(true);
        searchTypeRadioName.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("text.search.byname.tooltip"))});
        this.searchTypeRadioGroup.add(new Component[]{searchTypeRadioName});
        Radio searchTypeRadioInterest = new Radio("searchTypeInterest", (IModel)new Model((Serializable)((Object)"interest")));
        searchTypeRadioInterest.setMarkupId("searchtypeinterestinput");
        searchTypeRadioInterest.setOutputMarkupId(true);
        searchTypeRadioInterest.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("text.search.byinterest.tooltip"))});
        this.searchTypeRadioGroup.add(new Component[]{searchTypeRadioInterest});
        this.searchTypeRadioGroup.add(new Component[]{new Label("searchTypeNameLabel", (IModel)new ResourceModel("text.search.byname.label"))});
        this.searchTypeRadioGroup.add(new Component[]{new Label("searchTypeInterestLabel", (IModel)new ResourceModel("text.search.byinterest.label"))});
        searchForm.add(new Component[]{this.searchTypeRadioGroup});
        searchForm.add(new Component[]{new Label("connectionsLabel", (IModel)new ResourceModel("text.search.include.connections"))});
        this.connectionsCheckBox = new CheckBox("connectionsCheckBox", (IModel)new Model((Serializable)Boolean.valueOf(true)));
        this.connectionsCheckBox.setMarkupId("includeconnectionsinput");
        this.connectionsCheckBox.setOutputMarkupId(true);
        searchForm.add(new Component[]{this.connectionsCheckBox});
        List worksites = this.sakaiProxy.getUserSites();
        boolean hasWorksites = worksites.size() > 0;
        searchForm.add(new Component[]{new Label("worksiteLabel", (IModel)new ResourceModel("text.search.include.worksite"))});
        this.worksiteCheckBox = new CheckBox("worksiteCheckBox", (IModel)new Model((Serializable)Boolean.valueOf(false)));
        this.worksiteCheckBox.setMarkupId("limittositeinput");
        this.worksiteCheckBox.setOutputMarkupId(true);
        this.worksiteCheckBox.setEnabled(hasWorksites);
        searchForm.add(new Component[]{this.worksiteCheckBox});
        Object defaultWorksiteIdModel = hasWorksites ? new Model((Serializable)((Object)((Site)worksites.get(0)).getId())) : new ResourceModel("text.search.no.worksite");
        LinkedHashMap<Object, Object> worksiteMap = new LinkedHashMap<Object, Object>();
        if (hasWorksites) {
            for (Site worksite : worksites) {
                worksiteMap.put(worksite.getId(), worksite.getTitle());
            }
        } else {
            worksiteMap.put(defaultWorksiteIdModel.getObject(), defaultWorksiteIdModel.getObject());
        }
        1 worksitesModel = new /* Unavailable Anonymous Inner Class!! */;
        this.worksiteChoice = new DropDownChoice("worksiteChoice", (IModel)defaultWorksiteIdModel, (IModel)worksitesModel, (IChoiceRenderer)new HashMapChoiceRenderer(worksiteMap));
        this.worksiteChoice.setMarkupId("worksiteselect");
        this.worksiteChoice.setOutputMarkupId(true);
        this.worksiteChoice.setNullValid(false);
        this.worksiteChoice.setEnabled(hasWorksites);
        searchForm.add(new Component[]{this.worksiteChoice});
        this.numSearchResultsContainer = new WebMarkupContainer("numSearchResultsContainer");
        this.numSearchResultsContainer.setOutputMarkupPlaceholderTag(true);
        this.numSearchResults = new Label("numSearchResults");
        this.numSearchResults.setOutputMarkupId(true);
        this.numSearchResults.setEscapeModelStrings(false);
        this.numSearchResultsContainer.add(new Component[]{this.numSearchResults});
        Form clearResultsForm = new Form("clearResults");
        clearResultsForm.setOutputMarkupPlaceholderTag(true);
        this.clearButton = new /* Unavailable Anonymous Inner Class!! */;
        this.clearButton.setOutputMarkupPlaceholderTag(true);
        if (null == this.searchCookie) {
            this.clearButton.setVisible(false);
        }
        this.clearButton.setModel((IModel)new ResourceModel("button.search.clear"));
        clearResultsForm.add(new Component[]{this.clearButton});
        this.numSearchResultsContainer.add(new Component[]{clearResultsForm});
        this.add(new Component[]{this.numSearchResultsContainer});
        3 resultsModel = new /* Unavailable Anonymous Inner Class!! */;
        this.resultsContainer = new WebMarkupContainer("searchResultsContainer");
        this.resultsContainer.setOutputMarkupPlaceholderTag(true);
        if (null == this.searchCookie) {
            this.resultsContainer.setVisible(false);
        }
        ModalWindow connectionWindow = new ModalWindow("connectionWindow");
        4 resultsListView = new /* Unavailable Anonymous Inner Class!! */;
        resultsListView.add(new IBehavior[]{new MySearchCookieBehavior(this, (PageableListView)resultsListView)});
        this.resultsContainer.add(new Component[]{resultsListView});
        PagingNavigator searchResultsNavigator = new PagingNavigator("searchResultsNavigator", (IPageable)resultsListView);
        searchResultsNavigator.setOutputMarkupId(true);
        searchResultsNavigator.setVisible(false);
        this.resultsContainer.add(new Component[]{searchResultsNavigator});
        this.add(new Component[]{connectionWindow});
        this.add(new Component[]{this.resultsContainer});
        WebMarkupContainer searchHistoryContainer = new WebMarkupContainer("searchHistoryContainer");
        searchHistoryContainer.setOutputMarkupPlaceholderTag(true);
        Label searchHistoryLabel = new Label("searchHistoryLabel", (IModel)new ResourceModel("text.search.history"));
        searchHistoryContainer.add(new Component[]{searchHistoryLabel});
        5 searchHistoryModel = new /* Unavailable Anonymous Inner Class!! */;
        6 searchHistoryList = new /* Unavailable Anonymous Inner Class!! */;
        searchHistoryContainer.add(new Component[]{searchHistoryList});
        this.add(new Component[]{searchHistoryContainer});
        if (null == this.searchLogic.getSearchHistory(currentUserUuid)) {
            searchHistoryContainer.setVisible(false);
        }
        Form clearHistoryForm = new Form("clearHistory");
        clearHistoryForm.setOutputMarkupPlaceholderTag(true);
        this.clearHistoryButton = new /* Unavailable Anonymous Inner Class!! */;
        this.clearHistoryButton.setOutputMarkupPlaceholderTag(true);
        if (null == this.searchLogic.getSearchHistory(currentUserUuid)) {
            this.clearHistoryButton.setVisible(false);
        }
        this.clearHistoryButton.setModel((IModel)new ResourceModel("button.search.history.clear"));
        clearHistoryForm.add(new Component[]{this.clearHistoryButton});
        searchHistoryContainer.add(new Component[]{clearHistoryForm});
        8 searchSubmitButton = new /* Unavailable Anonymous Inner Class!! */;
        searchSubmitButton.setModel((IModel)new ResourceModel("button.search.generic"));
        searchForm.add(new Component[]{searchSubmitButton});
        this.add(new Component[]{searchForm});
        if (null != this.searchCookie) {
            String searchString = this.getCookieSearchString(this.searchCookie.getValue());
            searchStringModel.setString(searchString);
            Boolean filterConnections = this.getCookieFilterConnections(this.searchCookie.getValue());
            String worksiteId = this.getCookieFilterWorksite(this.searchCookie.getValue());
            Boolean filterWorksite = null != worksiteId;
            this.connectionsCheckBox.setModel((IModel)new Model((Serializable)filterConnections));
            this.worksiteCheckBox.setModel((IModel)new Model((Serializable)filterWorksite));
            this.worksiteChoice.setModel((IModel)new Model((Serializable)(null == worksiteId ? defaultWorksiteIdModel : worksiteId)));
            if (this.searchCookie.getValue().startsWith("name")) {
                this.searchTypeRadioGroup.setModel((IModel)new Model((Serializable)((Object)"name")));
                this.searchByName((PageableListView)resultsListView, searchResultsNavigator, searchHistoryContainer, null, searchString, filterConnections.booleanValue(), worksiteId);
            } else if (this.searchCookie.getValue().startsWith("interest")) {
                this.searchTypeRadioGroup.setModel((IModel)new Model((Serializable)((Object)"interest")));
                this.searchByInterest((PageableListView)resultsListView, searchResultsNavigator, searchHistoryContainer, null, searchString, filterConnections.booleanValue(), worksiteId);
            }
        } else {
            this.searchTypeRadioGroup.setModel((IModel)new Model((Serializable)((Object)"name")));
        }
    }

    private void searchByName(PageableListView<Person> resultsListView, PagingNavigator searchResultsNavigator, WebMarkupContainer searchHistoryContainer, AjaxRequestTarget target, String searchTerm, boolean connections, String worksiteId) {
        this.results = new ArrayList(this.searchLogic.findUsersByNameOrEmail(searchTerm, connections, worksiteId));
        Collections.sort(this.results);
        int numResults = this.results.size();
        int maxResults = this.sakaiProxy.getMaxSearchResults();
        int maxResultsPerPage = this.sakaiProxy.getMaxSearchResultsPerPage();
        int currentPage = this.getCurrentPageNumber();
        this.numSearchResultsContainer.setVisible(true);
        String cleanedSearchTerm = ProfileUtils.stripAndCleanHtml((String)searchTerm);
        if (numResults == 0) {
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.byname.no.results", null, new Object[]{cleanedSearchTerm}));
            this.resultsContainer.setVisible(false);
            searchResultsNavigator.setVisible(false);
        } else if (numResults == 1) {
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.byname.one.result", null, new Object[]{cleanedSearchTerm}));
            this.resultsContainer.setVisible(true);
            searchResultsNavigator.setVisible(false);
        } else if (numResults == maxResults) {
            resultsListView.setCurrentPage(currentPage);
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.toomany.results", null, new Object[]{cleanedSearchTerm, maxResults, maxResults}));
            this.resultsContainer.setVisible(true);
            searchResultsNavigator.setVisible(true);
        } else if (numResults > maxResultsPerPage) {
            resultsListView.setCurrentPage(currentPage);
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.byname.paged.results", null, new Object[]{numResults, resultsListView.getViewSize(), cleanedSearchTerm}));
            this.resultsContainer.setVisible(true);
            searchResultsNavigator.setVisible(true);
        } else {
            resultsListView.setCurrentPage(currentPage);
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.byname.all.results", null, new Object[]{numResults, cleanedSearchTerm}));
            this.resultsContainer.setVisible(true);
            searchResultsNavigator.setVisible(false);
        }
        if (null != target) {
            target.addComponent((Component)this.searchField);
            target.addComponent((Component)this.searchTypeRadioGroup);
            target.addComponent((Component)this.connectionsCheckBox);
            target.addComponent((Component)this.worksiteCheckBox);
            target.addComponent((Component)this.worksiteChoice);
            target.addComponent((Component)this.clearButton);
            target.addComponent((Component)this.numSearchResultsContainer);
            this.clearButton.setVisible(true);
            target.addComponent((Component)this.resultsContainer);
            this.clearHistoryButton.setVisible(true);
            searchHistoryContainer.setVisible(true);
            target.addComponent((Component)searchHistoryContainer);
            target.appendJavascript("setMainFrameHeight(window.name);");
        }
    }

    private void searchByInterest(PageableListView<Person> resultsListView, PagingNavigator searchResultsNavigator, WebMarkupContainer searchHistoryContainer, AjaxRequestTarget target, String searchTerm, boolean connections, String worksiteId) {
        this.results = new ArrayList(this.searchLogic.findUsersByInterest(searchTerm, connections, worksiteId));
        Collections.sort(this.results);
        int numResults = this.results.size();
        int maxResults = this.sakaiProxy.getMaxSearchResults();
        int maxResultsPerPage = this.sakaiProxy.getMaxSearchResultsPerPage();
        int currentPage = this.getCurrentPageNumber();
        this.numSearchResultsContainer.setVisible(true);
        String cleanedSearchTerm = ProfileUtils.stripAndCleanHtml((String)searchTerm);
        if (numResults == 0) {
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.byinterest.no.results", null, new Object[]{cleanedSearchTerm}));
            this.resultsContainer.setVisible(false);
            searchResultsNavigator.setVisible(false);
        } else if (numResults == 1) {
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.byinterest.one.result", null, new Object[]{cleanedSearchTerm}));
            this.resultsContainer.setVisible(true);
            searchResultsNavigator.setVisible(false);
        } else if (numResults == maxResults) {
            resultsListView.setCurrentPage(currentPage);
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.toomany.results", null, new Object[]{cleanedSearchTerm, maxResults, maxResults}));
            this.resultsContainer.setVisible(true);
            searchResultsNavigator.setVisible(true);
        } else if (numResults > maxResultsPerPage) {
            resultsListView.setCurrentPage(currentPage);
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.byinterest.paged.results", null, new Object[]{numResults, resultsListView.getViewSize(), cleanedSearchTerm}));
            this.resultsContainer.setVisible(true);
            searchResultsNavigator.setVisible(true);
        } else {
            resultsListView.setCurrentPage(currentPage);
            this.numSearchResults.setDefaultModel((IModel)new StringResourceModel("text.search.byinterest.all.results", null, new Object[]{numResults, cleanedSearchTerm}));
            this.resultsContainer.setVisible(true);
            searchResultsNavigator.setVisible(false);
        }
        if (null != target) {
            target.addComponent((Component)this.searchField);
            target.addComponent((Component)this.searchTypeRadioGroup);
            target.addComponent((Component)this.connectionsCheckBox);
            target.addComponent((Component)this.worksiteCheckBox);
            target.addComponent((Component)this.worksiteChoice);
            target.addComponent((Component)this.clearButton);
            target.addComponent((Component)this.numSearchResultsContainer);
            this.clearButton.setVisible(true);
            target.addComponent((Component)this.resultsContainer);
            this.clearHistoryButton.setVisible(true);
            searchHistoryContainer.setVisible(true);
            target.addComponent((Component)searchHistoryContainer);
            target.appendJavascript("setMainFrameHeight(window.name);");
        }
    }

    private int getCurrentPageNumber() {
        if (null == this.searchCookie) {
            return 0;
        }
        return this.getCookiePageNumber();
    }

    private int getCookiePageNumber() {
        return Integer.parseInt(this.searchCookie.getValue().substring(this.searchCookie.getValue().indexOf("[") + 1, this.searchCookie.getValue().indexOf("]")));
    }

    private void updatePageNumber(int pageNumber, String cookieString) {
        this.setSearchCookie(this.getCookieSearchType(cookieString), this.getCookieSearchString(cookieString), pageNumber, this.getCookieFilterConnections(cookieString), this.getCookieFilterWorksite(cookieString));
    }

    private void setSearchCookie(String searchCookieValuePrefix, String searchText, int searchPageNumber, boolean connections, String worksiteId) {
        this.searchCookie = new Cookie("profile2-search", searchCookieValuePrefix + "(" + connections + ")" + worksiteId + "[" + searchPageNumber + "]" + searchText);
        this.searchCookie.setMaxAge(-1);
        this.getWebRequestCycle().getWebResponse().addCookie(this.searchCookie);
    }

    private String getCookieSearchString(String cookieString) {
        return URLDecoder.decode(cookieString.substring(cookieString.indexOf("]") + 1));
    }

    private String getCookieSearchType(String cookieString) {
        return cookieString.substring(0, cookieString.indexOf("("));
    }

    private boolean getCookieFilterConnections(String cookieString) {
        return Boolean.parseBoolean(cookieString.substring(cookieString.indexOf("(") + 1, cookieString.indexOf(")")));
    }

    private String getCookieFilterWorksite(String cookieString) {
        String worksiteId = cookieString.substring(cookieString.indexOf(")") + 1, cookieString.indexOf("["));
        return true == worksiteId.equals("null") ? null : worksiteId;
    }

    static /* synthetic */ Cookie access$000(MySearch x0) {
        return x0.searchCookie;
    }

    static /* synthetic */ WebRequestCycle access$100(MySearch x0) {
        return x0.getWebRequestCycle();
    }

    static /* synthetic */ TextField access$200(MySearch x0) {
        return x0.searchField;
    }

    static /* synthetic */ WebMarkupContainer access$300(MySearch x0) {
        return x0.numSearchResultsContainer;
    }

    static /* synthetic */ WebMarkupContainer access$400(MySearch x0) {
        return x0.resultsContainer;
    }

    static /* synthetic */ AjaxButton access$500(MySearch x0) {
        return x0.clearButton;
    }

    static /* synthetic */ List access$600(MySearch x0) {
        return x0.results;
    }

    static /* synthetic */ RadioGroup access$700(MySearch x0) {
        return x0.searchTypeRadioGroup;
    }

    static /* synthetic */ CheckBox access$800(MySearch x0) {
        return x0.connectionsCheckBox;
    }

    static /* synthetic */ CheckBox access$900(MySearch x0) {
        return x0.worksiteCheckBox;
    }

    static /* synthetic */ DropDownChoice access$1000(MySearch x0) {
        return x0.worksiteChoice;
    }

    static /* synthetic */ void access$1100(MySearch x0, String x1, String x2, int x3, boolean x4, String x5) {
        x0.setSearchCookie(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ void access$1200(MySearch x0, PageableListView x1, PagingNavigator x2, WebMarkupContainer x3, AjaxRequestTarget x4, String x5, boolean x6, String x7) {
        x0.searchByName(x1, x2, x3, x4, x5, x6, x7);
    }

    static /* synthetic */ void access$1300(MySearch x0, PageableListView x1, PagingNavigator x2, WebMarkupContainer x3, AjaxRequestTarget x4, String x5, boolean x6, String x7) {
        x0.searchByInterest(x1, x2, x3, x4, x5, x6, x7);
    }

    static /* synthetic */ AjaxButton access$1400(MySearch x0) {
        return x0.clearHistoryButton;
    }

    static /* synthetic */ Logger access$1500() {
        return log;
    }

    static /* synthetic */ void access$1600(MySearch x0, int x1, String x2) {
        x0.updatePageNumber(x1, x2);
    }
}

