/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.lang.Bytes;
import org.sakaiproject.profile2.logic.ProfileImageLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.tool.components.CloseButton;
import org.sakaiproject.profile2.tool.pages.MyProfile;
import org.sakaiproject.profile2.tool.pages.panels.ChangeProfilePictureUpload;

public class ChangeProfilePictureUpload
extends Panel {
    private static final long serialVersionUID = 1L;
    private FileUploadField uploadField;
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileImageLogic")
    private ProfileImageLogic imageLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;
    private static final Logger log = Logger.getLogger(ChangeProfilePictureUpload.class);
    private FeedbackPanel feedback;

    public ChangeProfilePictureUpload(String id) {
        super(id);
        log.debug((Object)"ChangeProfilePictureUpload()");
        String userUuid = this.sakaiProxy.getCurrentUserId();
        this.renderChangeProfilePictureUpload(userUuid);
    }

    public ChangeProfilePictureUpload(String id, String userUuid) {
        super(id);
        log.debug((Object)("ChangeProfilePictureUpload(" + userUuid + ")"));
        if (!this.sakaiProxy.isSuperUser()) {
            log.error((Object)("ChangeProfilePictureUpload: user " + this.sakaiProxy.getCurrentUserId() + " attempted to access ChangeProfilePictureUpload for " + userUuid + ". Redirecting..."));
            throw new RestartResponseException((Page)new MyProfile());
        }
        this.renderChangeProfilePictureUpload(userUuid);
    }

    private void renderChangeProfilePictureUpload(String userUuid) {
        1 form = new /* Unavailable Anonymous Inner Class!! */;
        int maxSize = this.sakaiProxy.getMaxProfilePictureSize();
        form.setMaxSize(Bytes.megabytes((long)maxSize));
        form.setOutputMarkupId(true);
        form.setMultiPart(true);
        Label editWarning = new Label("editWarning");
        editWarning.setVisible(false);
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userUuid)) {
            editWarning.setDefaultModel((IModel)new StringResourceModel("text.edit.other.warning", null, new Object[]{this.sakaiProxy.getUserDisplayName(userUuid)}));
            editWarning.setEscapeModelStrings(false);
            editWarning.setVisible(true);
        }
        form.add(new Component[]{editWarning});
        CloseButton closeButton = new CloseButton("closeButton", (Component)this);
        closeButton.setOutputMarkupId(true);
        form.add(new Component[]{closeButton});
        Label textSelectImage = new Label("textSelectImage", (IModel)new StringResourceModel("text.upload.image.file", null, new Object[]{maxSize}));
        form.add(new Component[]{textSelectImage});
        this.uploadField = new FileUploadField("picture");
        this.uploadField.setMarkupId("pictureupload");
        this.uploadField.setOutputMarkupId(true);
        form.add(new Component[]{this.uploadField});
        this.feedback = new FeedbackPanel("feedback");
        this.feedback.setOutputMarkupId(true);
        form.add(new Component[]{this.feedback});
        2 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{submitButton});
        this.add(new Component[]{form});
    }

    static /* synthetic */ FileUploadField access$000(ChangeProfilePictureUpload x0) {
        return x0.uploadField;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ FeedbackPanel access$200(ChangeProfilePictureUpload x0) {
        return x0.feedback;
    }

    static /* synthetic */ ProfileImageLogic access$300(ChangeProfilePictureUpload x0) {
        return x0.imageLogic;
    }

    static /* synthetic */ SakaiProxy access$400(ChangeProfilePictureUpload x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$500(ChangeProfilePictureUpload x0) {
        return x0.wallLogic;
    }
}

