/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.pages.panels.MyInfoDisplay;
import org.sakaiproject.profile2.util.ProfileUtils;

public class MyInfoDisplay
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyInfoDisplay.class);
    private int visibleFieldCount = 0;
    private String birthday = "";
    private String birthdayDisplay = "";
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePrivacyLogic")
    private ProfilePrivacyLogic privacyLogic;

    public MyInfoDisplay(String id, UserProfile userProfile) {
        super(id);
        log.debug((Object)"MyInfoDisplay()");
        MyInfoDisplay thisPanel = this;
        String userId = userProfile.getUserUuid();
        String nickname = userProfile.getNickname();
        String personalSummary = userProfile.getPersonalSummary();
        Date dateOfBirth = userProfile.getDateOfBirth();
        if (dateOfBirth != null) {
            this.birthday = ProfileUtils.convertDateToString((Date)dateOfBirth, null);
            this.birthdayDisplay = this.privacyLogic.isBirthYearVisible(userId) ? this.birthday : ProfileUtils.convertDateToString((Date)dateOfBirth, (String)"dd MMMM");
            userProfile.setBirthdayDisplay(this.birthdayDisplay);
            userProfile.setBirthday(this.birthday);
        }
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.basic"))});
        WebMarkupContainer nicknameContainer = new WebMarkupContainer("nicknameContainer");
        nicknameContainer.add(new Component[]{new Label("nicknameLabel", (IModel)new ResourceModel("profile.nickname"))});
        nicknameContainer.add(new Component[]{new Label("nickname", nickname)});
        this.add(new Component[]{nicknameContainer});
        if (StringUtils.isBlank((String)nickname)) {
            nicknameContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer birthdayContainer = new WebMarkupContainer("birthdayContainer");
        birthdayContainer.add(new Component[]{new Label("birthdayLabel", (IModel)new ResourceModel("profile.birthday"))});
        birthdayContainer.add(new Component[]{new Label("birthday", this.birthdayDisplay)});
        this.add(new Component[]{birthdayContainer});
        if (StringUtils.isBlank((String)this.birthdayDisplay)) {
            birthdayContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer personalSummaryContainer = new WebMarkupContainer("personalSummaryContainer");
        personalSummaryContainer.add(new Component[]{new Label("personalSummaryLabel", (IModel)new ResourceModel("profile.summary"))});
        personalSummaryContainer.add(new Component[]{new Label("personalSummary", ProfileUtils.processHtml((String)personalSummary)).setEscapeModelStrings(false)});
        this.add(new Component[]{personalSummaryContainer});
        if (StringUtils.isBlank((String)personalSummary)) {
            personalSummaryContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        1 editButton = new /* Unavailable Anonymous Inner Class!! */;
        editButton.add(new Component[]{new Label("editButtonLabel", (IModel)new ResourceModel("button.edit"))});
        editButton.setOutputMarkupId(true);
        if (userProfile.isLocked() && !this.sakaiProxy.isSuperUser()) {
            editButton.setVisible(false);
        }
        this.add(new Component[]{editButton});
        Label noFieldsMessage = new Label("noFieldsMessage", (IModel)new ResourceModel("text.no.fields"));
        this.add(new Component[]{noFieldsMessage});
        if (this.visibleFieldCount > 0) {
            noFieldsMessage.setVisible(false);
        }
    }
}

