/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.components.CKEditorConfig;
import org.sakaiproject.profile2.tool.components.CKEditorTextArea;
import org.sakaiproject.profile2.tool.components.ComponentVisualErrorBehaviour;
import org.sakaiproject.profile2.tool.components.FeedbackLabel;
import org.sakaiproject.profile2.tool.pages.panels.MyInterestsEdit;
import org.sakaiproject.profile2.tool.pages.panels.MyStaffEdit;
import org.sakaiproject.profile2.util.ProfileUtils;

public class MyStaffEdit
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyInterestsEdit.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    private ProfileLogic profileLogic;

    public MyStaffEdit(String id, UserProfile userProfile) {
        super(id);
        log.debug((Object)"MyStaffEdit()");
        MyStaffEdit thisPanel = this;
        String userId = userProfile.getUserUuid();
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.staff.edit"))});
        Form form = new Form("form", (IModel)new Model((Serializable)userProfile));
        form.setOutputMarkupId(true);
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        Label editWarning = new Label("editWarning");
        editWarning.setVisible(false);
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userId)) {
            editWarning.setDefaultModel((IModel)new StringResourceModel("text.edit.other.warning", null, new Object[]{userProfile.getDisplayName()}));
            editWarning.setEscapeModelStrings(false);
            editWarning.setVisible(true);
        }
        form.add(new Component[]{editWarning});
        WebMarkupContainer positionContainer = new WebMarkupContainer("positionContainer");
        positionContainer.add(new Component[]{new Label("positionLabel", (IModel)new ResourceModel("profile.position"))});
        TextField position = new TextField("position", (IModel)new PropertyModel((Object)userProfile, "position"));
        position.setMarkupId("positioninput");
        position.setOutputMarkupId(true);
        positionContainer.add(new Component[]{position});
        form.add(new Component[]{positionContainer});
        WebMarkupContainer departmentContainer = new WebMarkupContainer("departmentContainer");
        departmentContainer.add(new Component[]{new Label("departmentLabel", (IModel)new ResourceModel("profile.department"))});
        TextField department = new TextField("department", (IModel)new PropertyModel((Object)userProfile, "department"));
        department.setMarkupId("departmentinput");
        department.setOutputMarkupId(true);
        departmentContainer.add(new Component[]{department});
        form.add(new Component[]{departmentContainer});
        WebMarkupContainer schoolContainer = new WebMarkupContainer("schoolContainer");
        schoolContainer.add(new Component[]{new Label("schoolLabel", (IModel)new ResourceModel("profile.school"))});
        TextField school = new TextField("school", (IModel)new PropertyModel((Object)userProfile, "school"));
        school.setMarkupId("schoolinput");
        school.setOutputMarkupId(true);
        schoolContainer.add(new Component[]{school});
        form.add(new Component[]{schoolContainer});
        WebMarkupContainer roomContainer = new WebMarkupContainer("roomContainer");
        roomContainer.add(new Component[]{new Label("roomLabel", (IModel)new ResourceModel("profile.room"))});
        TextField room = new TextField("room", (IModel)new PropertyModel((Object)userProfile, "room"));
        room.setMarkupId("roominput");
        room.setOutputMarkupId(true);
        roomContainer.add(new Component[]{room});
        form.add(new Component[]{roomContainer});
        WebMarkupContainer staffProfileContainer = new WebMarkupContainer("staffProfileContainer");
        staffProfileContainer.add(new Component[]{new Label("staffProfileLabel", (IModel)new ResourceModel("profile.staffprofile"))});
        TextArea staffProfile = new TextArea("staffProfile", (IModel)new PropertyModel((Object)userProfile, "staffProfile"));
        staffProfile.setMarkupId("staffprofileinput");
        staffProfile.setOutputMarkupId(true);
        staffProfileContainer.add(new Component[]{staffProfile});
        form.add(new Component[]{staffProfileContainer});
        WebMarkupContainer universityProfileUrlContainer = new WebMarkupContainer("universityProfileUrlContainer");
        universityProfileUrlContainer.add(new Component[]{new Label("universityProfileUrlLabel", (IModel)new ResourceModel("profile.universityprofileurl"))});
        1 universityProfileUrl = new /* Unavailable Anonymous Inner Class!! */;
        universityProfileUrl.setMarkupId("universityprofileurlinput");
        universityProfileUrl.setOutputMarkupId(true);
        universityProfileUrl.add((IValidator)new UrlValidator());
        universityProfileUrlContainer.add(new Component[]{universityProfileUrl});
        FeedbackLabel universityProfileUrlFeedback = new FeedbackLabel("universityProfileUrlFeedback", (Component)universityProfileUrl);
        universityProfileUrlFeedback.setMarkupId("universityProfileUrlFeedback");
        universityProfileUrlFeedback.setOutputMarkupId(true);
        universityProfileUrlContainer.add(new Component[]{universityProfileUrlFeedback});
        universityProfileUrl.add(new IBehavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)universityProfileUrlFeedback)});
        form.add(new Component[]{universityProfileUrlContainer});
        WebMarkupContainer academicProfileUrlContainer = new WebMarkupContainer("academicProfileUrlContainer");
        academicProfileUrlContainer.add(new Component[]{new Label("academicProfileUrlLabel", (IModel)new ResourceModel("profile.academicprofileurl"))});
        2 academicProfileUrl = new /* Unavailable Anonymous Inner Class!! */;
        academicProfileUrl.setMarkupId("academicprofileurlinput");
        academicProfileUrl.setOutputMarkupId(true);
        academicProfileUrl.add((IValidator)new UrlValidator());
        academicProfileUrlContainer.add(new Component[]{academicProfileUrl});
        FeedbackLabel academicProfileUrlFeedback = new FeedbackLabel("academicProfileUrlFeedback", (Component)academicProfileUrl);
        academicProfileUrlFeedback.setMarkupId("academicProfileUrlFeedback");
        academicProfileUrlFeedback.setOutputMarkupId(true);
        academicProfileUrlContainer.add(new Component[]{academicProfileUrlFeedback});
        academicProfileUrl.add(new IBehavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)academicProfileUrlFeedback)});
        form.add(new Component[]{academicProfileUrlContainer});
        WebMarkupContainer publicationsContainer = new WebMarkupContainer("publicationsContainer");
        publicationsContainer.add(new Component[]{new Label("publicationsLabel", (IModel)new ResourceModel("profile.publications"))});
        CKEditorTextArea publications = new CKEditorTextArea("publications", (IModel)new PropertyModel((Object)userProfile, "publications"));
        publications.setMarkupId("publicationsinput");
        publications.setEditorConfig(CKEditorConfig.createCkConfig());
        publications.setOutputMarkupId(true);
        publicationsContainer.add(new Component[]{publications});
        form.add(new Component[]{publicationsContainer});
        3 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{submitButton});
        4 cancelButton = new /* Unavailable Anonymous Inner Class!! */;
        cancelButton.setDefaultFormProcessing(false);
        form.add(new Component[]{cancelButton});
        this.add(new Component[]{form});
    }

    private boolean save(Form form) {
        UserProfile userProfile = (UserProfile)form.getModelObject();
        String userId = userProfile.getUserUuid();
        SakaiPerson sakaiPerson = this.sakaiProxy.getSakaiPerson(userId);
        String tDepartment = ProfileUtils.truncate((String)userProfile.getDepartment(), (int)255, (boolean)false);
        String tPosition = ProfileUtils.truncate((String)userProfile.getPosition(), (int)255, (boolean)false);
        String tSchool = ProfileUtils.truncate((String)userProfile.getSchool(), (int)255, (boolean)false);
        String tRoom = ProfileUtils.truncate((String)userProfile.getRoom(), (int)255, (boolean)false);
        sakaiPerson.setOrganizationalUnit(tDepartment);
        sakaiPerson.setTitle(tPosition);
        sakaiPerson.setCampus(tSchool);
        sakaiPerson.setRoomNumber(tRoom);
        sakaiPerson.setStaffProfile(userProfile.getStaffProfile());
        sakaiPerson.setUniversityProfileUrl(userProfile.getUniversityProfileUrl());
        sakaiPerson.setAcademicProfileUrl(userProfile.getAcademicProfileUrl());
        sakaiPerson.setPublications(userProfile.getPublications());
        if (this.profileLogic.saveUserProfile(sakaiPerson)) {
            log.info((Object)("Saved SakaiPerson for: " + userId));
            return true;
        }
        log.info((Object)("Couldn't save SakaiPerson for: " + userId));
        return false;
    }

    static /* synthetic */ boolean access$000(MyStaffEdit x0, Form x1) {
        return x0.save(x1);
    }

    static /* synthetic */ SakaiProxy access$100(MyStaffEdit x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$200(MyStaffEdit x0) {
        return x0.wallLogic;
    }
}

