/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.components;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.ProfileStatusLogic;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.model.ProfilePrivacy;
import org.sakaiproject.profile2.model.ProfileStatus;

public class ProfileStatusRenderer
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ProfileStatusRenderer.class);
    private String userUuid;
    private ProfilePrivacy privacy;
    private String msgClass;
    private String dateClass;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePrivacyLogic")
    private ProfilePrivacyLogic privacyLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileStatusLogic")
    private ProfileStatusLogic statusLogic;

    public ProfileStatusRenderer(String id, String userUuid, String msgClass, String dateClass) {
        super(id);
        this.userUuid = userUuid;
        this.msgClass = msgClass;
        this.dateClass = dateClass;
        this.privacy = this.privacyLogic.getPrivacyRecordForUser(userUuid);
        this.renderStatus();
    }

    public ProfileStatusRenderer(String id, String userUuid, ProfilePrivacy privacy, String msgClass, String dateClass) {
        super(id);
        this.userUuid = userUuid;
        this.privacy = privacy;
        this.msgClass = msgClass;
        this.dateClass = dateClass;
        this.renderStatus();
    }

    public ProfileStatusRenderer(String id, Person person, String msgClass, String dateClass) {
        super(id);
        this.msgClass = msgClass;
        this.dateClass = dateClass;
        this.userUuid = person.getUuid();
        this.privacy = person.getPrivacy();
        this.renderStatus();
    }

    private void renderStatus() {
        log.debug((Object)"ProfileStatusRenderer has been added.");
        this.setOutputMarkupPlaceholderTag(true);
        ProfileStatus status = this.statusLogic.getUserStatus(this.userUuid, this.privacy);
        if (status == null) {
            log.debug((Object)"ProfileStatus null");
            this.setVisible(false);
            this.setupBlankFields();
            return;
        }
        if (StringUtils.isBlank((String)status.getMessage())) {
            log.debug((Object)"ProfileStatus message blank");
            this.setVisible(false);
            this.setupBlankFields();
            return;
        }
        this.add(new Component[]{new Label("message", status.getMessage()).add(new Behavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)this.msgClass)))})});
        this.add(new Component[]{new Label("date", status.getDateFormatted()).add(new Behavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)this.dateClass)))})});
    }

    private void setupBlankFields() {
        this.add(new Component[]{new Label("message")});
        this.add(new Component[]{new Label("date")});
    }
}

