/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.dataproviders;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileMessagingLogic;
import org.sakaiproject.profile2.model.Message;
import org.sakaiproject.profile2.tool.models.DetachableMessageModel;

public class MessagesDataProvider
implements IDataProvider<Message> {
    private static final long serialVersionUID = 1L;
    private final String threadId;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileMessagingLogic")
    protected ProfileMessagingLogic messagingLogic;

    public MessagesDataProvider(String threadId) {
        this.threadId = threadId;
        Injector.get().inject((Object)this);
    }

    public Iterator<Message> iterator(long first, long count) {
        int f = (int)first;
        int c = (int)count;
        try {
            List slice = this.messagingLogic.getMessagesInThread(this.threadId).subList(f, f + c);
            return slice.iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST.iterator();
        }
    }

    public long size() {
        return this.messagingLogic.getMessagesInThreadCount(this.threadId);
    }

    public IModel<Message> model(Message object) {
        return new DetachableMessageModel(object);
    }

    public void detach() {
    }
}

