/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages;

import java.io.Serializable;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.util.cookies.CookieUtils;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.exception.ProfileNotDefinedException;
import org.sakaiproject.profile2.exception.ProfilePreferencesNotDefinedException;
import org.sakaiproject.profile2.model.ProfilePreferences;
import org.sakaiproject.profile2.model.SocialNetworkingInfo;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.components.ProfileImage;
import org.sakaiproject.profile2.tool.models.FriendAction;
import org.sakaiproject.profile2.tool.pages.BasePage;
import org.sakaiproject.profile2.tool.pages.MyProfile;
import org.sakaiproject.profile2.tool.pages.panels.ChangeProfilePictureUpload;
import org.sakaiproject.profile2.tool.pages.panels.ChangeProfilePictureUrl;
import org.sakaiproject.profile2.tool.pages.panels.MyStatusPanel;
import org.sakaiproject.profile2.tool.pages.windows.AddFriend;

public class MyProfile
extends BasePage {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyProfile.class);
    private boolean locked;

    public MyProfile() {
        log.debug((Object)"MyProfile()");
        String userUuid = this.sakaiProxy.getCurrentUserId();
        this.renderMyProfile(userUuid);
    }

    public MyProfile(String userUuid) {
        log.debug((Object)("MyProfile(" + userUuid + ")"));
        if (!this.sakaiProxy.isSuperUser()) {
            log.error((Object)("MyProfile: user " + this.sakaiProxy.getCurrentUserId() + " attempted to access MyProfile for " + userUuid + ". Redirecting..."));
            throw new RestartResponseException((IRequestablePage)new MyProfile());
        }
        this.renderMyProfile(userUuid);
    }

    private void renderMyProfile(String userUuid) {
        ChangeProfilePictureUpload changePicture;
        if (!this.sakaiProxy.isSuperUserAndProxiedToUser(userUuid)) {
            this.disableLink(this.myProfileLink);
        }
        FeedbackPanel feedbackPanel = new FeedbackPanel("feedbackPanel");
        this.add(new Component[]{feedbackPanel});
        feedbackPanel.setVisible(false);
        ProfilePreferences prefs = this.preferencesLogic.getPreferencesRecordForUser(userUuid);
        if (prefs == null) {
            throw new ProfilePreferencesNotDefinedException("Couldn't create default preferences record for " + userUuid);
        }
        SakaiPerson sakaiPerson = this.sakaiProxy.getSakaiPerson(userUuid);
        if (sakaiPerson == null) {
            log.warn((Object)("No SakaiPerson for " + userUuid + ". Creating one."));
            sakaiPerson = this.sakaiProxy.createSakaiPerson(userUuid);
            if (sakaiPerson == null) {
                throw new ProfileNotDefinedException("Couldn't create a SakaiPerson for " + userUuid);
            }
            this.sakaiProxy.postEvent("profile.new", userUuid, true);
        }
        this.sakaiProxy.postEvent("profile.view.own", "/profile/" + userUuid, false);
        String userDisplayName = this.sakaiProxy.getUserDisplayName(userUuid);
        String userEmail = this.sakaiProxy.getUserEmail(userUuid);
        UserProfile userProfile = new UserProfile();
        userProfile.setUserUuid(userUuid);
        userProfile.setNickname(sakaiPerson.getNickname());
        userProfile.setDateOfBirth(sakaiPerson.getDateOfBirth());
        userProfile.setDisplayName(userDisplayName);
        userProfile.setEmail(userEmail);
        userProfile.setHomepage(sakaiPerson.getLabeledURI());
        userProfile.setHomephone(sakaiPerson.getHomePhone());
        userProfile.setWorkphone(sakaiPerson.getTelephoneNumber());
        userProfile.setMobilephone(sakaiPerson.getMobile());
        userProfile.setFacsimile(sakaiPerson.getFacsimileTelephoneNumber());
        userProfile.setDepartment(sakaiPerson.getOrganizationalUnit());
        userProfile.setPosition(sakaiPerson.getTitle());
        userProfile.setSchool(sakaiPerson.getCampus());
        userProfile.setRoom(sakaiPerson.getRoomNumber());
        userProfile.setCourse(sakaiPerson.getEducationCourse());
        userProfile.setSubjects(sakaiPerson.getEducationSubjects());
        userProfile.setStaffProfile(sakaiPerson.getStaffProfile());
        userProfile.setAcademicProfileUrl(sakaiPerson.getAcademicProfileUrl());
        userProfile.setUniversityProfileUrl(sakaiPerson.getUniversityProfileUrl());
        userProfile.setPublications(sakaiPerson.getPublications());
        userProfile.setBusinessBiography(sakaiPerson.getBusinessBiography());
        userProfile.setCompanyProfiles(this.profileLogic.getCompanyProfiles(userUuid));
        userProfile.setFavouriteBooks(sakaiPerson.getFavouriteBooks());
        userProfile.setFavouriteTvShows(sakaiPerson.getFavouriteTvShows());
        userProfile.setFavouriteMovies(sakaiPerson.getFavouriteMovies());
        userProfile.setFavouriteQuotes(sakaiPerson.getFavouriteQuotes());
        userProfile.setPersonalSummary(sakaiPerson.getNotes());
        SocialNetworkingInfo socialInfo = this.profileLogic.getSocialNetworkingInfo(userProfile.getUserUuid());
        if (socialInfo == null) {
            socialInfo = new SocialNetworkingInfo();
        }
        userProfile.setSocialInfo(socialInfo);
        if (sakaiPerson.getLocked() == null) {
            userProfile.setLocked(false);
            this.setLocked(false);
        } else {
            this.setLocked(sakaiPerson.getLocked().booleanValue());
            userProfile.setLocked(this.isLocked());
        }
        int profilePictureType = this.sakaiProxy.getProfilePictureType();
        if (profilePictureType == 1) {
            changePicture = this.sakaiProxy.isSuperUserAndProxiedToUser(userUuid) ? new ChangeProfilePictureUpload("changePicture", userUuid) : new ChangeProfilePictureUpload("changePicture");
        } else if (profilePictureType == 2) {
            changePicture = this.sakaiProxy.isSuperUserAndProxiedToUser(userUuid) ? new ChangeProfilePictureUrl("changePicture", userUuid) : new ChangeProfilePictureUrl("changePicture");
        } else if (profilePictureType == 3) {
            changePicture = new EmptyPanel("changePicture");
        } else {
            log.error((Object)("Invalid picture type returned: " + profilePictureType));
            changePicture = new EmptyPanel("changePicture");
        }
        changePicture.setOutputMarkupPlaceholderTag(true);
        changePicture.setVisible(false);
        this.add(new Component[]{changePicture});
        this.add(new Component[]{new ProfileImage("photo", (IModel)new Model((Serializable)((Object)userUuid)))});
        1 changePictureLink = new /* Unavailable Anonymous Inner Class!! */;
        changePictureLink.add(new Component[]{new Label("changePictureLabel", (IModel)new ResourceModel("link.change.profile.picture"))});
        if (!(this.sakaiProxy.isProfilePictureChangeEnabled() && !userProfile.isLocked() || this.sakaiProxy.isSuperUser())) {
            changePictureLink.setEnabled(false);
            changePictureLink.setVisible(false);
        }
        if (this.sakaiProxy.isOfficialImageEnabledGlobally() && (!this.sakaiProxy.isUsingOfficialImageButAlternateSelectionEnabled() || prefs.isUseOfficialImage())) {
            changePictureLink.setEnabled(false);
            changePictureLink.setVisible(false);
        }
        this.add(new Component[]{changePictureLink});
        WebMarkupContainer sideLinks = new WebMarkupContainer("sideLinks");
        int visibleSideLinksCount = 0;
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userUuid)) {
            boolean friend = false;
            boolean friendRequestToThisPerson = false;
            boolean friendRequestFromThisPerson = false;
            String currentUserUuid = this.sakaiProxy.getCurrentUserId();
            String nickname = userProfile.getNickname();
            if (StringUtils.isBlank((String)nickname)) {
                nickname = "";
            }
            FriendAction friendActionModel = new FriendAction();
            friend = this.connectionsLogic.isUserXFriendOfUserY(userUuid, currentUserUuid);
            if (!friend) {
                friendRequestToThisPerson = this.connectionsLogic.isFriendRequestPending(currentUserUuid, userUuid);
            }
            if (!friend && !friendRequestToThisPerson) {
                friendRequestFromThisPerson = this.connectionsLogic.isFriendRequestPending(userUuid, currentUserUuid);
            }
            WebMarkupContainer addFriendContainer = new WebMarkupContainer("addFriendContainer");
            ModalWindow addFriendWindow = new ModalWindow("addFriendWindow");
            2 addFriendLink = new /* Unavailable Anonymous Inner Class!! */;
            Label addFriendLabel = new Label("addFriendLabel");
            addFriendLink.add(new Component[]{addFriendLabel});
            addFriendContainer.add(new Component[]{addFriendLink});
            if (friend) {
                addFriendLabel.setDefaultModel((IModel)new ResourceModel("text.friend.confirmed"));
                addFriendLink.add(new Behavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"instruction icon connection-confirmed")))});
                addFriendLink.setEnabled(false);
            } else if (friendRequestToThisPerson) {
                addFriendLabel.setDefaultModel((IModel)new ResourceModel("text.friend.requested"));
                addFriendLink.add(new Behavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"instruction icon connection-request")))});
                addFriendLink.setEnabled(false);
            } else if (friendRequestFromThisPerson) {
                addFriendLabel.setDefaultModel((IModel)new ResourceModel("text.friend.pending"));
                addFriendLink.add(new Behavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"instruction icon connection-request")))});
                addFriendLink.setEnabled(false);
            } else {
                addFriendLabel.setDefaultModel((IModel)new StringResourceModel("link.friend.add.name", null, new Object[]{nickname}));
                addFriendLink.add(new Behavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"icon connection-add")))});
                addFriendWindow.setContent((Component)new AddFriend(addFriendWindow.getContentId(), addFriendWindow, friendActionModel, currentUserUuid, userUuid));
            }
            sideLinks.add(new Component[]{addFriendContainer});
            addFriendWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.add(new Component[]{addFriendWindow});
            ++visibleSideLinksCount;
            WebMarkupContainer lockProfileContainer = new WebMarkupContainer("lockProfileContainer");
            Label lockProfileLabel = new Label("lockProfileLabel");
            4 lockProfileLink = new /* Unavailable Anonymous Inner Class!! */;
            if (this.isLocked()) {
                lockProfileLink.add(new Behavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"icon locked")))});
            } else {
                lockProfileLink.add(new Behavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)"icon unlocked")))});
            }
            lockProfileLink.add(new Component[]{lockProfileLabel});
            lockProfileLabel.setDefaultModel((IModel)new ResourceModel("link.profile.locked." + this.isLocked()));
            lockProfileLink.add(new Behavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("text.profile.locked." + this.isLocked()))});
            lockProfileContainer.add(new Component[]{lockProfileLink});
            sideLinks.add(new Component[]{lockProfileContainer});
            ++visibleSideLinksCount;
        } else {
            WebMarkupContainer addFriendContainer = new WebMarkupContainer("addFriendContainer");
            addFriendContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */}).add(new Component[]{new Label("addFriendLabel")});
            sideLinks.add(new Component[]{addFriendContainer});
            this.add(new Component[]{new WebMarkupContainer("addFriendWindow")});
            WebMarkupContainer lockProfileContainer = new WebMarkupContainer("lockProfileContainer");
            lockProfileContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */}).add(new Component[]{new Label("lockProfileLabel")});
            sideLinks.add(new Component[]{lockProfileContainer});
        }
        if (visibleSideLinksCount == 0) {
            sideLinks.setVisible(false);
        }
        this.add(new Component[]{sideLinks});
        MyStatusPanel myStatusPanel = new MyStatusPanel("myStatusPanel", userProfile);
        this.add(new Component[]{myStatusPanel});
        ArrayList<Object> tabs = new ArrayList<Object>();
        7 tabbedPanel = new /* Unavailable Anonymous Inner Class!! */;
        CookieUtils utils = new CookieUtils();
        Cookie tabCookie = utils.getCookie("profile2-tab");
        if (this.sakaiProxy.isProfileFieldsEnabled()) {
            tabs.add(new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.sakaiProxy.isWallEnabledGlobally()) {
            tabs.add(new /* Unavailable Anonymous Inner Class!! */);
            if (this.sakaiProxy.isWallDefaultProfilePage() && null == tabCookie) {
                tabbedPanel.setSelectedTab(1);
            }
        }
        if (null != tabCookie) {
            try {
                tabbedPanel.setSelectedTab(Integer.parseInt(tabCookie.getValue()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.add(new Component[]{tabbedPanel});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

