/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import org.apache.log4j.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.tool.dataproviders.ConfirmedFriendsDataProvider;
import org.sakaiproject.profile2.tool.models.FriendAction;
import org.sakaiproject.profile2.tool.pages.panels.ConfirmedFriends;
import org.sakaiproject.profile2.tool.pages.panels.CreateWorksitePanel;

public class ConfirmedFriends
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ConfirmedFriends.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileConnectionsLogic")
    protected ProfileConnectionsLogic connectionsLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePrivacyLogic")
    protected ProfilePrivacyLogic privacyLogic;
    private Integer numConfirmedFriends = 0;
    private boolean ownList = false;

    public ConfirmedFriends(String id, String userUuid) {
        super(id);
        log.debug((Object)"ConfirmedFriends()");
        FriendAction friendActionModel = new FriendAction();
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (userUuid.equals(currentUserUuid)) {
            this.ownList = true;
        }
        ConfirmedFriendsDataProvider provider = new ConfirmedFriendsDataProvider(userUuid);
        this.numConfirmedFriends = (int)provider.size();
        1 numConfirmedFriendsModel = new /* Unavailable Anonymous Inner Class!! */;
        WebMarkupContainer confirmedFriendsHeading = new WebMarkupContainer("confirmedFriendsHeading");
        Label confirmedFriendsLabel = new Label("confirmedFriendsLabel");
        if (this.ownList) {
            confirmedFriendsLabel.setDefaultModel((IModel)new ResourceModel("heading.friends.my"));
        } else {
            String displayName = this.sakaiProxy.getUserDisplayName(userUuid);
            confirmedFriendsLabel.setDefaultModel((IModel)new StringResourceModel("heading.friends.view", null, new Object[]{displayName}));
        }
        confirmedFriendsHeading.add(new Component[]{confirmedFriendsLabel});
        confirmedFriendsHeading.add(new Component[]{new Label("confirmedFriendsNumber", (IModel)numConfirmedFriendsModel)});
        confirmedFriendsHeading.setOutputMarkupId(true);
        this.add(new Component[]{confirmedFriendsHeading});
        Form confirmedFriendsButtonForm = new Form("confirmedFriendsButtonForm");
        this.add(new Component[]{confirmedFriendsButtonForm});
        CreateWorksitePanel createWorksitePanel = new CreateWorksitePanel("createWorksitePanel", this.connectionsLogic.getConnectionsForUser(userUuid));
        createWorksitePanel.setOutputMarkupPlaceholderTag(true);
        createWorksitePanel.setVisible(false);
        confirmedFriendsButtonForm.add(new Component[]{createWorksitePanel});
        2 createWorksiteButton = new /* Unavailable Anonymous Inner Class!! */;
        createWorksiteButton.setModel((IModel)new ResourceModel("link.worksite.create"));
        createWorksiteButton.add(new Behavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("link.title.worksite.create"))});
        createWorksiteButton.setVisible(this.sakaiProxy.isUserAllowedAddSite(userUuid));
        confirmedFriendsButtonForm.add(new Component[]{createWorksiteButton});
        3 searchConnectionsButton = new /* Unavailable Anonymous Inner Class!! */;
        searchConnectionsButton.setModel((IModel)new ResourceModel("link.my.friends.search"));
        confirmedFriendsButtonForm.add(new Component[]{searchConnectionsButton});
        WebMarkupContainer confirmedFriendsContainer = new WebMarkupContainer("confirmedFriendsContainer");
        confirmedFriendsContainer.setOutputMarkupId(true);
        ModalWindow connectionWindow = new ModalWindow("connectionWindow");
        4 confirmedFriendsDataView = new /* Unavailable Anonymous Inner Class!! */;
        confirmedFriendsDataView.setOutputMarkupId(true);
        confirmedFriendsDataView.setItemsPerPage(15L);
        confirmedFriendsContainer.add(new Component[]{confirmedFriendsDataView});
        this.add(new Component[]{confirmedFriendsContainer});
        this.add(new Component[]{connectionWindow});
        AjaxPagingNavigator pager = new AjaxPagingNavigator("navigator", (IPageable)confirmedFriendsDataView);
        this.add(new Component[]{pager});
        if (this.numConfirmedFriends == 0) {
            confirmedFriendsContainer.setVisible(false);
            pager.setVisible(false);
        }
        if (this.numConfirmedFriends <= 15) {
            pager.setVisible(false);
        }
    }

    static /* synthetic */ Integer access$000(ConfirmedFriends x0) {
        return x0.numConfirmedFriends;
    }

    static /* synthetic */ boolean access$100(ConfirmedFriends x0) {
        return x0.ownList;
    }

    static /* synthetic */ Integer access$002(ConfirmedFriends x0, Integer x1) {
        x0.numConfirmedFriends = x1;
        return x0.numConfirmedFriends;
    }
}

