/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.SocialNetworkingInfo;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.components.ComponentVisualErrorBehaviour;
import org.sakaiproject.profile2.tool.components.FeedbackLabel;
import org.sakaiproject.profile2.tool.components.IconWithClueTip;
import org.sakaiproject.profile2.tool.pages.panels.MySocialNetworkingEdit;
import org.sakaiproject.profile2.util.ProfileUtils;

public class MySocialNetworkingEdit
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MySocialNetworkingEdit.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    private ProfileLogic profileLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;

    public MySocialNetworkingEdit(String id, UserProfile userProfile) {
        super(id);
        log.debug((Object)"MySocialNetworkingEdit()");
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.social.edit"))});
        Form form = new Form("form", (IModel)new Model((Serializable)userProfile));
        form.setOutputMarkupId(true);
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        Label editWarning = new Label("editWarning");
        editWarning.setVisible(false);
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userProfile.getUserUuid())) {
            editWarning.setDefaultModel((IModel)new StringResourceModel("text.edit.other.warning", null, new Object[]{userProfile.getDisplayName()}));
            editWarning.setEscapeModelStrings(false);
            editWarning.setVisible(true);
        }
        form.add(new Component[]{editWarning});
        WebMarkupContainer facebookContainer = new WebMarkupContainer("facebookContainer");
        facebookContainer.add(new Component[]{new Label("facebookLabel", (IModel)new ResourceModel("profile.socialnetworking.facebook.edit"))});
        1 facebookUrl = new /* Unavailable Anonymous Inner Class!! */;
        facebookUrl.setMarkupId("facebookurlinput");
        facebookUrl.setOutputMarkupId(true);
        facebookUrl.add((IValidator)new UrlValidator());
        facebookContainer.add(new Component[]{facebookUrl});
        facebookContainer.add(new Component[]{new IconWithClueTip("facebookToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.profile.facebook.tooltip"))});
        FeedbackLabel facebookUrlFeedback = new FeedbackLabel("facebookUrlFeedback", (Component)facebookUrl);
        facebookUrlFeedback.setOutputMarkupId(true);
        facebookUrlFeedback.setMarkupId("facebookUrlFeedback");
        facebookContainer.add(new Component[]{facebookUrlFeedback});
        facebookUrl.add(new Behavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)facebookUrlFeedback)});
        form.add(new Component[]{facebookContainer});
        WebMarkupContainer linkedinContainer = new WebMarkupContainer("linkedinContainer");
        linkedinContainer.add(new Component[]{new Label("linkedinLabel", (IModel)new ResourceModel("profile.socialnetworking.linkedin.edit"))});
        2 linkedinUrl = new /* Unavailable Anonymous Inner Class!! */;
        linkedinUrl.setMarkupId("linkedinurlinput");
        linkedinUrl.setOutputMarkupId(true);
        linkedinUrl.add((IValidator)new UrlValidator());
        linkedinContainer.add(new Component[]{linkedinUrl});
        linkedinContainer.add(new Component[]{new IconWithClueTip("linkedinToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.profile.linkedin.tooltip"))});
        FeedbackLabel linkedinUrlFeedback = new FeedbackLabel("linkedinUrlFeedback", (Component)linkedinUrl);
        linkedinUrlFeedback.setMarkupId("linkedinUrlFeedback");
        linkedinUrlFeedback.setOutputMarkupId(true);
        linkedinContainer.add(new Component[]{linkedinUrlFeedback});
        linkedinUrl.add(new Behavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)linkedinUrlFeedback)});
        form.add(new Component[]{linkedinContainer});
        WebMarkupContainer myspaceContainer = new WebMarkupContainer("myspaceContainer");
        myspaceContainer.add(new Component[]{new Label("myspaceLabel", (IModel)new ResourceModel("profile.socialnetworking.myspace.edit"))});
        3 myspaceUrl = new /* Unavailable Anonymous Inner Class!! */;
        myspaceUrl.setMarkupId("myspaceurlinput");
        myspaceUrl.setOutputMarkupId(true);
        myspaceUrl.add((IValidator)new UrlValidator());
        myspaceContainer.add(new Component[]{myspaceUrl});
        myspaceContainer.add(new Component[]{new IconWithClueTip("myspaceToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.profile.myspace.tooltip"))});
        FeedbackLabel myspaceUrlFeedback = new FeedbackLabel("myspaceUrlFeedback", (Component)myspaceUrl);
        myspaceUrlFeedback.setMarkupId("myspaceUrlFeedback");
        myspaceUrlFeedback.setOutputMarkupId(true);
        myspaceContainer.add(new Component[]{myspaceUrlFeedback});
        myspaceUrl.add(new Behavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)myspaceUrlFeedback)});
        form.add(new Component[]{myspaceContainer});
        WebMarkupContainer twitterContainer = new WebMarkupContainer("twitterContainer");
        twitterContainer.add(new Component[]{new Label("twitterLabel", (IModel)new ResourceModel("profile.socialnetworking.twitter.edit"))});
        4 twitterUrl = new /* Unavailable Anonymous Inner Class!! */;
        twitterUrl.setMarkupId("twitterurlinput");
        twitterUrl.setOutputMarkupId(true);
        twitterUrl.add((IValidator)new UrlValidator());
        twitterContainer.add(new Component[]{twitterUrl});
        twitterContainer.add(new Component[]{new IconWithClueTip("twitterToolTip", "/library/image/silk/information.png", (IModel)new ResourceModel("text.profile.twitter.tooltip"))});
        FeedbackLabel twitterUrlFeedback = new FeedbackLabel("twitterUrlFeedback", (Component)twitterUrl);
        twitterUrlFeedback.setMarkupId("twitterUrlFeedback");
        twitterUrlFeedback.setOutputMarkupId(true);
        twitterContainer.add(new Component[]{twitterUrlFeedback});
        twitterUrl.add(new Behavior[]{new ComponentVisualErrorBehaviour("onblur", (Component)twitterUrlFeedback)});
        form.add(new Component[]{twitterContainer});
        WebMarkupContainer skypeContainer = new WebMarkupContainer("skypeContainer");
        skypeContainer.add(new Component[]{new Label("skypeLabel", (IModel)new ResourceModel("profile.socialnetworking.skype.edit"))});
        TextField skypeUsername = new TextField("skypeUsername", (IModel)new PropertyModel((Object)userProfile, "socialInfo.skypeUsername"));
        skypeUsername.setMarkupId("skypeusernameinput");
        skypeUsername.setOutputMarkupId(true);
        skypeContainer.add(new Component[]{skypeUsername});
        form.add(new Component[]{skypeContainer});
        5 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{submitButton});
        6 cancelButton = new /* Unavailable Anonymous Inner Class!! */;
        cancelButton.setDefaultFormProcessing(false);
        form.add(new Component[]{cancelButton});
        this.add(new Component[]{form});
    }

    private void validateUrl(TextField<String> urlTextField) {
        String input = urlTextField.getInput();
        if (StringUtils.isNotBlank((String)input) && !input.startsWith("http://") && !input.startsWith("https://")) {
            urlTextField.setConvertedInput((Object)("http://" + input));
        } else {
            urlTextField.setConvertedInput((Object)(StringUtils.isBlank((String)input) ? null : input));
        }
    }

    private boolean save(Form form) {
        UserProfile userProfile = (UserProfile)form.getModelObject();
        SocialNetworkingInfo socialNetworkingInfo = new SocialNetworkingInfo(userProfile.getUserUuid());
        String tFacebook = ProfileUtils.truncate((String)userProfile.getSocialInfo().getFacebookUrl(), (int)255, (boolean)false);
        String tLinkedin = ProfileUtils.truncate((String)userProfile.getSocialInfo().getLinkedinUrl(), (int)255, (boolean)false);
        String tMyspace = ProfileUtils.truncate((String)userProfile.getSocialInfo().getMyspaceUrl(), (int)255, (boolean)false);
        String tSkype = ProfileUtils.truncate((String)userProfile.getSocialInfo().getSkypeUsername(), (int)255, (boolean)false);
        String tTwitter = ProfileUtils.truncate((String)userProfile.getSocialInfo().getTwitterUrl(), (int)255, (boolean)false);
        socialNetworkingInfo.setFacebookUrl(tFacebook);
        socialNetworkingInfo.setLinkedinUrl(tLinkedin);
        socialNetworkingInfo.setMyspaceUrl(tMyspace);
        socialNetworkingInfo.setSkypeUsername(tSkype);
        socialNetworkingInfo.setTwitterUrl(tTwitter);
        return this.profileLogic.saveSocialNetworkingInfo(socialNetworkingInfo);
    }

    static /* synthetic */ void access$000(MySocialNetworkingEdit x0, TextField x1) {
        x0.validateUrl(x1);
    }

    static /* synthetic */ boolean access$100(MySocialNetworkingEdit x0, Form x1) {
        return x0.save(x1);
    }

    static /* synthetic */ SakaiProxy access$200(MySocialNetworkingEdit x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$300(MySocialNetworkingEdit x0) {
        return x0.wallLogic;
    }
}

